-- myTypes.e
-- v1.0
-- 2010-11-13
-- common types

-- type positive(atom x)
--   >=0
-- type string(object x)
--   string

global constant
  ON = 1,
  OFF = 0,
  SUCCESS = 1,
  FAIL = 0

global constant
  DIGITS = "0123456789ABCDEF"

global object
  void    -- used when return value doesn't care

------------------------------------------------------------------------------

global type positive(atom x)
  return x>=0
end type

------------------------------------------------------------------------------

global type string(object x)
-- checks if a sequence is a string
  atom is_string
  if sequence(x) then
    is_string = 1
    for i = 1 to length(x) do
      if sequence(x[i]) then
        is_string = 0
      else
        if (x[i] < ' ') and (x[i] != 9) and (x[i] != 13) and (x[i] != 10) then is_string = 0 end if
        if x[i]> 254 then is_string = 0 end if
      end if
    end for
  else
    is_string = 0
  end if
  return is_string
end type

------------------------------------------------------------------------------

global function isNumber(sequence s)
-- checks if a sequence represents a number
  integer lg

  lg = length(s)
  if lg = 0 then return 0 end if
  for i = 1 to lg do
    if sequence(s[i]) then
      return 0
    else
      if ((s[i] < '0') or (s[i] > '9')) and (s[i] != ',') and (s[i] != '.') and (s[i] != '-') and (s[i] != '+') then return 0 end if
    end if
  end for
  return 1
end function

------------------------------------------------------------------------------

global function isDate(sequence x)
  integer n, n2

-- checks if a sequence represents a number
  n = length(x) if (n < 6) or (n > 10) then return 0 end if
  for i = 1 to length(x) do
    if sequence(x[i]) then return 0 end if
    if ((x[i] < '0') or (x[i] > '9')) and (x[i] != '/') then return 0 end if
    n = find('/', x) if (n != 2) and (n != 3) then return 0 end if
    n2 = find('/', x[n+1..$]) if (n2 != 2) and (n2 != 3) then return 0 end if
  end for
  return 1
end function

------------------------------------------------------------------------------

global function isHex(sequence s)
-- checks if a sequence represents a hexadecimal number
  integer lg

  lg = length(s)
  if lg <= 1 then return 0 end if         -- min 2 cars (#n)
  if s[1] != '#' then return 0 end if
  for i = 2 to lg do
    if sequence(s[i]) then
      return 0
    else
      if not find(s[i], DIGITS) then return 0 end if
    end if
  end for
  return 1
end function

