-- myMath.e
-- v1.0
-- 2010-11-13
-- mathematical functions

-- constant E = 2.718281828459045
-- function ceil(atom x1)
-- function div(integer a,integer b)
-- function mod(integer a,integer b)
-- function abs(atom x)
-- function exp(atom x)
-- function nthroot(atom x, atom pwr)
-- function log10(positive x)
-- function cosh(object x)
-- function sinh(object x)
-- function tanh(object x)
-- function arcsinh(object x)
-- function arccosh(object x)
-- function arctanh(object x)
-- function logbase(object b, object n)
-- function fact(atom x)
-- function round(atom a, integer dec)
--   rounds atom a to n decimals
--   ex: round(112.234, 1) = 112.2
--   n may be negative
--   ex: round(112, -2) = 100
-- function max(sequence lst)
--   returns the highest value from the list lst
--   if lst is empty, returns 0
-- function min(sequence lst)
--   returns the lowest value from the list lst
--   if lst is empty, returns 0

include myTypes.e
include myDebug.e

-------------------------------------------------------------------------------

global constant E     = 2.718281828459045

-------------------------------------------------------------------------------

global function ceil(atom x1)
  atom x
  x=floor(x1)
  if (x<x1) then return (x+1) else return x1 end if
end function

-------------------------------------------------------------------------------

global function div(integer a,integer b)
  return  floor(a/b)
end function   -- div

-------------------------------------------------------------------------------

global function mod(integer a,integer b)
  return remainder(a,b)
end function   -- mod

-------------------------------------------------------------------------------

global function abs(atom x)
  if x<0 then return (-x) else return x end if
end function

-------------------------------------------------------------------------------

global function exp(atom x)
  return power(E,x)
end function

-------------------------------------------------------------------------------

global function nthroot(atom x, atom pwr)
  if x>=0 then
    return power(x,(1/pwr))
  else
    return power(-1,pwr)*power(abs(x),(1/pwr))
  end if
end function

-------------------------------------------------------------------------------

global function log10(positive x)
  return log(x)/log(10)
end function

-------------------------------------------------------------------------------

global function cosh(object x)
  return ((exp(x)+exp(-x))/2)
end function

-------------------------------------------------------------------------------

global function sinh(object x)
  return ((exp(x)-exp(-x))/2)
end function

-------------------------------------------------------------------------------

global function tanh(object x)
  return sinh(x)/cosh(x)
end function

-------------------------------------------------------------------------------

global function arcsinh(object x)
  return log((2*x)+1)
end function

-------------------------------------------------------------------------------

global function arccosh(object x)
  return log((2*x)-1)
end function

-------------------------------------------------------------------------------

global function arctanh(object x)
  return (log((x+1)/(x-1))/2)
end function

-------------------------------------------------------------------------------

global function logbase(object b, object n)
  return log(n)/log(b)
end function

-------------------------------------------------------------------------------

global function fact(atom x)
  if x = 1 then
    return 1
  else
    return (x * fact(x -1))
  end if
end function

------------------------------------------------------------------------------

global function round(atom a, integer dec)
-- rounds atom a to n decimals
-- ex: round(112.234, 1) = 112.2
-- n may be negative
-- ex: round(112, -2) = 100
  atom n

  n = power(10, dec)
  return (floor((n*a)+ 0.5) / n)
end function

------------------------------------------------------------------------------

global function max(sequence lst)
-- returns the highest value from the list lst
-- if lst is empty, returns 0
  atom maxi

  if length(lst) =0 then return 0 end if
  for i = 1 to length(lst) do
    if sequence(lst[i]) then
      return {}  -- to generate an error: there should be no sequence in lst
    elsif i=1 then
      maxi = lst[i]
    elsif lst[i] > maxi then
      maxi = lst[i]
    end if
  end for
  return maxi
end function

------------------------------------------------------------------------------

global function min(sequence lst)
-- returns the lowest value from the list lst
-- if lst is empty, returns 0
  atom mini

  if length(lst) =0 then return 0 end if
  for i = 1 to length(lst) do
    if sequence(lst[i]) then
      return {}  -- to generate an error: there should be no sequence in lst
    elsif i=1 then
      mini = lst[i]
    elsif lst[i] < mini then
      mini = lst[i]
    end if
  end for
  return mini
end function


