-- myGraph.e
-- v1.0
-- 2010-11-13
-- graphic functions

include graphics.e
include mouse.e
include image.e
include keys.e
include myTypes.e
include myConv.e
include myDebug.e
include myMath.e
include mySeq.e

global sequence TextAttr
TextAttr = {WHITE, BLACK}

global constant KEYB = 0, SCREEN = 1, ERR = 2

constant KEY_EVENT = 1, MOUSE_EVENT = 2  -- type of events

integer
  listLine, listSelected, listOffset

------------------------------------------------------------------------------

global procedure clrEol(integer color)
-- clears end of line
sequence r, CurPos, vc
integer ScrCol      -- number of screen colomns
   vc = video_config()
   ScrCol = vc[VC_COLUMNS]
   CurPos = get_position()
   r = repeat(0,10)
   r[REG_AX] = #600
   r[REG_CX] = (CurPos[1]-1)*256+CurPos[2]-1
   r[REG_DX] = (CurPos[1]-1)*256 + ScrCol-1
   r[REG_BX] = color*16*256
   r = dos_interrupt(#10,r)
end procedure

------------------------------------------------------------------------------

global function mousePresent()
-- returns 1 if mouse detected
integer MouseVector
sequence r
   MouseVector = (256*peek(207)+peek(206)) *16 + 256*peek(205)+peek(204)
   if MouseVector  = 0 or peek(MouseVector) = #CF then
     return 0  -- no mouse
   end if
   r = repeat(0,10)
   r[REG_AX] =  0
   r = dos_interrupt(#33,r)
   return r[REG_AX] = #FFFF  -- r[REG_AX] = #FFFF if mouse present
end function -- MousePresent

------------------------------------------------------------------------------

global function getEvent()
-- loop and wait for a mouse or key event.
integer key object mouse
    while 1 do
    key = upper(get_key())
    if key > -1 then
	return {KEY_EVENT,key}
    end if
    mouse = get_mouse()
    if sequence(mouse) then
       if mouse[1] = LEFT_DOWN or mouse[1] = RIGHT_DOWN then
	return {MOUSE_EVENT,mouse}
       end if
    end if
    end while
end function -- getEvent

------------------------------------------------------------------------------

global procedure scrollVideo(atom x1, atom y1, atom x2, atom y2, atom nl, atom down, atom c)
  sequence reg_list -- list of register values

  if ((x2 <= x1) or (y2 <= y1)) then
    return
  end if
  reg_list = repeat(0, 10)
  if (down) then
    reg_list[REG_AX] = byte2word(nl, 7)
  else
    reg_list[REG_AX] = byte2word(nl, 6)
  end if
  reg_list[REG_BX] = byte2word(0, c)
  reg_list[REG_CX] = byte2word(x1-1, y1-1)
  reg_list[REG_DX] = byte2word(x2-1, y2-1)
  reg_list = dos_interrupt(#10, reg_list) -- Call DOS video interrupt #10
  if and_bits(reg_list[REG_FLAGS], 1) then
    puts(ERR, "Problem with DOS video interrupt\n")
  end if
  text_color(lowByte(c))
  bk_color(highByte(c))
end procedure

------------------------------------------------------------------------------

global procedure chgAttr(atom x, atom y, atom attr, atom count)
-- Change l'attribut des Count caracteres commencant  X, Y
  atom offset

  offset = ((y-1)*160) + ((x-1)*2)
  for i=1 to count do
    poke(#B8000+offset+1, attr)
    offset = offset + 2
  end for
end procedure

------------------------------------------------------------------------------

global procedure setTextAttr(sequence col)
-- Definit les couleurs de texte et de fond et sauve la couleur
  text_color(col[1])
  bk_color(col[2])
  TextAttr = col
end procedure

------------------------------------------------------------------------------

procedure drawFrame(integer x1, integer y1, integer x2, integer y2, sequence attr)
  setTextAttr(attr)
  position(y1, x1)
  puts(1,""&repeat('', x2-x1-1)&"")
  for i = 1 to y2-y1-1 do
    position(y1+i, x1) puts(1,"")
    position(y1+i, x2) puts(1,"")
  end for
  position(y2, x1)
  puts(1,""&repeat('', x2-x1-1)&"")
end procedure

-------------------------------------------------------------------------------

global function editText(sequence s, sequence attr, sequence pos, integer longueur)
  sequence chaine
  integer l, pointeur_chaine
  atom ex
  sequence col
  atom fl_out, fl_ins, premier

  col = TextAttr
  fl_ins = 1
  cursor(#0E0F)
  fl_out = 0
  setTextAttr(attr)
  chaine = s  l = 0
  pointeur_chaine = 1
  premier = 1
  while fl_out = 0 do
    position(pos[2], pos[1])  puts(1, repeat(' ', longueur))
    position(pos[2], pos[1])  puts(1, mid(chaine, 1, longueur))
    position(pos[2], pos[1] + pointeur_chaine - 1)
    ex = wait_key()
    if ex = HOME then
       pointeur_chaine = 1
    elsif ex = END then
      if length(chaine) < longueur then
        pointeur_chaine = length(chaine) + 1
      else
        pointeur_chaine = length(chaine)
      end if
    elsif ex = LEFT then
      if pointeur_chaine > 1 then
        pointeur_chaine = pointeur_chaine - 1
      end if
    elsif ex = RIGHT then
      if (pointeur_chaine < longueur) and (pointeur_chaine < length(chaine)+1) then
        pointeur_chaine = pointeur_chaine + 1
      end if
    elsif ex = DELETE then
      l = length(chaine)
      if pointeur_chaine <= l then
        if pointeur_chaine = 1 then
          chaine = chaine[2..l]
        elsif pointeur_chaine = l then
          chaine = chaine[1..l-1]
          pointeur_chaine = l-1
        else
          chaine = delete(chaine, pointeur_chaine, 1)
        end if
      end if
    elsif ex = INSERT then
      fl_ins = not fl_ins
      if fl_ins then
        cursor(#0E0F)
      else
        cursor(#000F)
      end if
    elsif (ex = UP) or (ex = DOWN) or (ex = ENTER) or (ex = ESC) then
      fl_out = 1
    elsif ex = BACKSPACE then
      l = length(chaine)
      if pointeur_chaine > 1 then
        chaine = delete(chaine, pointeur_chaine-1, 1)
        pointeur_chaine = pointeur_chaine-1
      end if
    else
      if premier then
        chaine = append("", ex)
        pointeur_chaine = 2
      elsif fl_ins and (length(chaine) < longueur) then
        chaine = insert(chaine, ex, pointeur_chaine)
        if (pointeur_chaine < longueur) and (pointeur_chaine < length(chaine)+1) then
          pointeur_chaine = pointeur_chaine + 1
        end if
      elsif (not fl_ins) and (pointeur_chaine <= length(chaine)) then
        chaine[pointeur_chaine] = ex
        if (pointeur_chaine < longueur) and (pointeur_chaine < length(chaine)+1) then
          pointeur_chaine = pointeur_chaine + 1
        end if
      end if
    end if
    premier = 0
  end while
  setTextAttr(col)
  cursor(#2000)
  return {chaine, ex}
end function

-------------------------------------------------------------------------------

procedure listGoFirst(sequence currentList)
  if length(currentList)=0 then return end if
  listSelected = 1
  listLine = 1
  listOffset = 0
end procedure

-------------------------------------------------------------------------------

procedure listGoPrevious(sequence currentList)
  if length(currentList)=0 then return end if
  if listSelected=1 then return end if
  listSelected -= 1
  if listLine=1 then
    listOffset -= 1
  else
    listLine -= 1
  end if
end procedure

-------------------------------------------------------------------------------

procedure listGoNext(sequence currentList)
  if length(currentList)=0 then return end if
  if listSelected=length(currentList) then return end if
  listSelected += 1
  if listLine=3 then
    listOffset += 1
  else
    listLine += 1
  end if
end procedure

-------------------------------------------------------------------------------

procedure listGoLast(sequence currentList)
  integer lg

  lg = length(currentList)
  if lg=0 then
    listLine = 0
    listSelected = 0
    listOffset = 0
    return
  end if
  if lg >= 3 then
    listLine = 3
    listOffset = lg-3
  else
    listGoFirst(currentList)
    listLine = lg
  end if
  listSelected = lg
end procedure

-------------------------------------------------------------------------------

procedure listGo(sequence currentList, integer pos)
  if pos = 0 then
    listLine = 0
    listSelected = 0
    listOffset = 0
  elsif pos = 1 then
    listGoFirst(currentList)
  elsif pos = length(currentList) then
    listGoLast(currentList)
  else
    listLine = 2
    listSelected = pos
    listOffset = pos-2
  end if
end procedure

-------------------------------------------------------------------------------

procedure refreshListBox(sequence liste, sequence pos, integer long)
  sequence s

  for i = 1 to min({3,length(liste)}) do
    position(pos[1]+i,pos[2]+1)
    if i = listLine then
      setTextAttr({WHITE,BLUE})
    else
      setTextAttr({GRAY,WHITE})
    end if
    s = liste[listOffset+i]
    puts(1, rightPad(s[1..min({long, $})], long))
  end for
end procedure

-------------------------------------------------------------------------------

function drawListBox(sequence liste, integer defaut, sequence pos, integer long)
  sequence saved, vc, col
  integer m, x1, y1, x2, y2

  col = TextAttr
  vc = video_config()
  x1 = pos[1]-1
  x2 = pos[1]+long
  m = min({3,length(liste)})
  y2 = pos[2]+m+2
  if y2 <= vc[VC_LINES] then
    y1 = pos[2]+1
  else
    y1 = pos[2]-m-2
    y2 = pos[2]-1
  end if
  saved = save_text_image({y1,x1}, {y2,x2})
  drawFrame(x1, y1, x2, y2, {GRAY,WHITE})
  listGo(liste, defaut)
  refreshListBox(liste, {y1,x1}, long)
  setTextAttr(col)
  return {{y1,x1},saved}
end function

-------------------------------------------------------------------------------

global procedure displayMsg(sequence msg, object pos)
-- prints a message in a frame at position pos
-- if pos is an atom (mostly 0), then center the frame in the screen
  sequence saved, vc, col, s
  integer h, w, x1, y1, x2, y2
  atom c

  col = TextAttr
  vc = video_config()
  s = splitString(msg, '\n')
  h = length(s)
  w = 0
  for i = 1 to h do
    if length(s[i]) > w then w = length(s[i]) end if
  end for
  if atom(pos) then
    x1 = floor((VC_COLUMNS-w)/2)
    y1 = floor((VC_LINES-h)/2)
    x2 = x1+w+1
    y2 = y1+h+1
  else
    x1 = pos[1]-1
    x2 = pos[1]+w
    y2 = pos[2]+h+2
    if y2 <= vc[VC_LINES] then
      y1 = pos[2]+1
    else
      y1 = pos[2]-h-2
      y2 = pos[2]-1
    end if
  end if
  saved = save_text_image({y1,x1}, {y2,x2})
  drawFrame(x1, y1, x2, y2, {GRAY,WHITE})
  position(y1+1,x1+1)
  setTextAttr({GRAY,WHITE})
  puts(1, msg)
  c = wait_key()
  display_text_image({y1,x1}, saved)
  setTextAttr(col)
end procedure

-------------------------------------------------------------------------------

global function listBox(sequence liste, integer defaut, sequence attr, sequence pos, integer long)
  sequence saved, s, box, col
  sequence resultat

  col = TextAttr
  setTextAttr(attr)
  s = drawListBox(liste, defaut, pos, long)
  saved = s[2]
  box = s[1]
  resultat = {0, 0}
  while (resultat[2] != ENTER) and (resultat[2] != ESC) do
    position(pos[2],pos[1])
    puts(1, rightPad(liste[listSelected], long))
    resultat[2] = ' '
    while (resultat[2] != ENTER) and (resultat[2] != ESC)
      and (resultat[2] != UP) and (resultat[2] != DOWN) do
      resultat[2] = wait_key()
    end while
    if resultat[2] = ENTER then
      resultat[1] = liste[listSelected]
    elsif resultat[2] = UP then
      listGoPrevious(liste)
    elsif resultat[2] = DOWN then
      listGoNext(liste)
    elsif resultat[2] = ESC then
      resultat[1] = ""
    end if
    refreshListBox(liste, box, long)
  end while
  display_text_image(box, saved)
  setTextAttr(col)
  position(pos[2],pos[1])
  puts(1, rightPad(resultat[1], long))
  return resultat
end function

-------------------------------------------------------------------------------

global function comboBox(sequence liste, integer defaut, sequence attr, sequence pos, integer long)
  sequence saved, s, box, col
  sequence resultat

puts(f_debug, "comboBox\n")
  col = TextAttr
  setTextAttr(attr)
  s = drawListBox(liste, defaut, pos, long)
  saved = s[2]
  box = s[1]
  resultat = {0, 0}
  if defaut = 0 then
    s = ""
  else
    s = liste[listSelected]
  end if
--analyzeSequence(s, "s", f_debug)
  while (resultat[2] != ENTER) and (resultat[2] != ESC) do
    resultat = editText(s, attr, pos, long)
--analyzeSequence(resultat, "resultat", f_debug)
    if resultat[2] = ENTER then
    elsif resultat[2] = UP then
      listGoPrevious(liste)
      s = liste[listSelected]
    elsif resultat[2] = DOWN then
      listGoNext(liste)
      s = liste[listSelected]
    elsif resultat[2] = ESC then
      resultat[1] = ""
    end if
    refreshListBox(liste, box, long)
  end while
  display_text_image(box, saved)
  setTextAttr(col)
  position(pos[2],pos[1])
  puts(1, rightPad(resultat[1], long))
  return resultat
end function

