-- myFile.e
-- v1.0
-- 2010-11-13
-- file functions

-- function splitFilename(sequence filename)
   -- splits a complete filename in path, name and extension
-- function parentDir(sequence path)
   -- remove last sub directory from path if there is one and return it.
   -- if root return empty sequence
-- procedure fileCopy(sequence source, sequence dest)
   -- copy a file from source to dest using Euphoria get_bytes/puts
-- procedure textReplace(sequence old_file, sequence new_file, sequence old, sequence new)
   -- replaces sub-sequence old by new in all sequences from file old_file
   -- result is written in file new_file
   -- old_file is not affected
-- function md5sum(sequence filename)
   -- returns MD5 checksum of a file
-- function fileExists(sequence filename)
-- function readCSV(sequence filename)
   -- reads a CSV file in a sequence
   -- CSV separator is a semicolon
   -- CSV strings may be surrounded by quotes
-- sequence2CSV(sequence section)
   -- converts a sequence to a CSV line
   -- CSV separator is a semicolon
   -- CSV strings are surrounded by quotes
-- procedure saveCSV(sequence filename, sequence section)
   -- saves a sequence in a CSV file
   -- CSV separator is a semicolon
   -- CSV strings are surrounded by quotes
-- function readFile(sequence filename, integer file_type)
   -- reads a file structured as an Ini file in a sequence { {section name, section content}, ... }
   -- each section content may be:
   --   a list of parameters and values { {parameter, value}, ... } if file_type = INI_FILE
   --   a list of CSV data if file_type = DATA_FILE
-- function readIniFile(sequence filename)
   -- reads a Ini file in a sequence { {section name, section content}, ... }
   -- each section content is a list of parameters and values { {parameter, value}, ... }
-- function readDataFile(sequence filename)
   -- reads a data file in a sequence { {section name, section content}, ... }
   -- each section content is a list of CSV data
-- saveFile(sequence filename, sequence content, integer file_type)
   -- saves a sequence in a file structured as an Ini file
   -- each section content may be:
   --   a list of parameters and values { {parameter, value}, ... } if file_type = INI_FILE
   --   a list of CSV data if file_type = DATA_FILE
-- procedure saveIniFile(sequence filename, sequence content)
   -- saves a sequence { {section name, section content}, ... } in an Ini file
   -- each section content is a list of parameters and values { {parameter, value}, ... }
-- procedure saveDataFile(sequence filename, sequence content)
   -- saves a sequence { {section name, section content}, ... } in a data file
   -- each section content is a list of CSV data
-- function searchINI(sequence ini, sequence section, sequence key)
-- function readINI(sequence file, sequence section, sequence name, object value)
   -- reads an element of an INI file
-- procedure writeINI(sequence file, sequence section, sequence name, object value)
   -- writes an element of an INI file

include myTypes.e
include myDebug.e
include mySeq.e
include myConv.e
include md5.e
include common.e

constant
  INI_FILE  = 1,
  DATA_FILE = 2

------------------------------------------------------------------------------

global function splitFilename(sequence filename)
-- splits a complete filename in path, name and extension
  sequence path, name, ext
  integer l, p, e     -- separators for path and extension

  l = length(filename)
  if l = 0 then return {"","",""} end if
  path = {}
  name = {}
  ext = {}
  p = 0
  e = l+1
  for i = l to 1 by -1 do
    if e = l+1 then     -- only one extension allowed, the last one
      if filename[i] = '.' then
        e = i
        ext = filename[e+1..$]
      end if
    end if
    if p = 0 then
      if filename[i] = '\\' then
        p = i
        path = filename[1..p-1]
        exit
      end if
    end if
  end for
  if p = 0 then
    name = filename[1..e-1]
  else
    name = filename[p+1..e-1]
  end if
  return {path,name,ext}
end function

------------------------------------------------------------------------------

global function parentDir(sequence path)
-- remove last sub directory from path if there is one and return it.
-- if root return empty sequence
  sequence parent integer i

  if path[length(path)]  = '\\' then
     path = path[1..length(path)-1]
  end if
  i = length(path)
  while i > 0 do
    if path[i] = '\\' or path[i] = ':' then
      exit
    end if
    i = i-1
  end while
  if i = 0 then
    return {}
  end if
  parent = path[1..i]
  if parent[length(parent)] != '\\' then
    parent = parent & '\\'
  end if
  return parent
end function -- parentDir()

------------------------------------------------------------------------------

global procedure fileCopy(sequence source, sequence dest)
-- copy a file from source to dest using Euphoria get_bytes/puts
  integer s, d
  sequence chunk

  s = open(source, "rb")
  if s = -1 then return end if
  d = open(dest, "wb")
  if d = -1 then close(s) return end if
  while 1 do
    chunk = get_bytes(s, 4096) -- read 4096 bytes at a time
	puts(d, chunk)
    if length(chunk) < 4096 then
        exit
    end if
  end while
  close(s)
  close(d)
end procedure

------------------------------------------------------------------------------

global procedure textReplace(sequence old_file, sequence new_file, sequence old, sequence new)
-- replaces sub-sequence old by new in all sequences from file old_file
-- result is written in file new_file
-- old_file is not affected
  sequence s
  integer f_in, f_tmp
  object line

  s = {}
  f_in = open(old_file, "r")
  f_tmp = open("temp.$$$", "w")
  if (f_in != -1) and (f_tmp != -1) then
    while 1 do
      line = gets(f_in)
      if atom(line) then
        exit
      end if
      puts(f_tmp, replaceString(line, old, new))
    end while
    close(f_in)
    close(f_tmp)
  end if
  system("copy temp.$$$ " & new_file, 2)
  system("del temp.$$$", 2)
end procedure

------------------------------------------------------------------------------

global function md5sum(sequence filename)
-- returns MD5 checksum of a file
  integer fn
  sequence whole_file, chunk

  whole_file = {}
  fn = open(filename, "rb")  -- an existing file
  while 1 do
    chunk = get_bytes (fn, 100) -- read 100 bytes at a time
    whole_file &= chunk        -- chunk might be empty, that's ok
    if length(chunk) < 100 then exit end if
  end while
  close(fn)
  return hexString(md5(whole_file))
end function

------------------------------------------------------------------------------

global function fileExists(sequence filename)
  if atom(dir(filename)) then
    return 0
  else
    return 1
  end if
end function

------------------------------------------------------------------------------

global function readCSV(sequence filename)
-- reads a CSV file in a sequence
-- CSV separator is a semicolon
-- CSV strings may be surrounded by quotes
  sequence section
  integer f_in
  object line

  section = {}
  f_in = open(filename, "r")
  if f_in != -1 then
    while 1 do
      line = gets(f_in)
      if atom(line) then
        exit
      end if
      line = line[1..length(line)-1]
      if length(line)>0 then
        section = append(section, strtok(line, ';') )
      end if
    end while
    close(f_in)
  end if
  return section
end function

------------------------------------------------------------------------------

global function sequence2CSV(sequence section)
-- converts a sequence to a CSV line
-- CSV separator is a semicolon
-- CSV strings are surrounded by quotes
  integer l
  sequence line

  if atom(section) then
    line = object2string(section)
  else
    l = length(section)
    line = {}
    if l > 0 then
      for j = 1 to l-1 do
        if atom(section[j]) or isDate(section[j]) then
          line &= object2string(section[j])&";"
        else
          line &= "\""&object2string(section[j])&"\";"
        end if
      end for
      if atom(section[l]) or isDate(section[l]) then
        line &= object2string(section[l])
      else
        line &= "\""&object2string(section[l])&"\""
      end if
    end if
  end if
  return line
end function

------------------------------------------------------------------------------

global procedure saveCSV(sequence filename, sequence section)
-- saves a sequence in a CSV file
-- CSV separator is a semicolon
-- CSV strings are surrounded by quotes
  integer f_out

  f_out = open(filename, "w")
  if f_out != -1 then
    for i = 1 to length(section) do
      puts(f_out, sequence2CSV(section[i])&"\n")
    end for
    close(f_out)
  end if
end procedure

------------------------------------------------------------------------------

global function readFile(sequence filename, integer file_type)
-- reads a file structured as an Ini file in a sequence { {section name, section content}, ... }
-- each section content may be:
--   a list of parameters and values { {parameter, value}, ... } if file_type = INI_FILE
--   a list of CSV data if file_type = DATA_FILE
  sequence content
  sequence Item, s
  object line
  integer f_in

  Item = {}
  s = {}
  content = {}
  f_in = open(filename, "r")
  if f_in != -1 then
    while 1 do
      line = gets(f_in)
      if atom(line) then
        if length(Item) > 0 then
          Item = append(Item, s)
          content = append(content, Item)
        end if
        exit
      end if
      --Add some items to the list
      if line[1] = '[' then
        if length(Item) > 0 then
          Item = append(Item, s)
          s = {}
          content = append(content, Item)
          Item = {}
        end if
        line = line[2..length(line)-2]
        Item = append(Item, line)
      else
        line = line[1..length(line)-1]
        if length(line)>0 then
          if file_type = INI_FILE then
            s = append(s, splitString(line, '=') )
          elsif file_type = DATA_FILE then
            s = append(s, strtok(line, ';') )
          end if
        end if
      end if
    end while
  end if
  close(f_in)
  return content
end function

------------------------------------------------------------------------------

global function readIniFile(sequence filename)
-- reads a Ini file in a sequence { {section name, section content}, ... }
-- each section content is a list of parameters and values { {parameter, value}, ... }
  return readFile(filename, INI_FILE)
end function

------------------------------------------------------------------------------

global function readDataFile(sequence filename)
-- reads a data file in a sequence { {section name, section content}, ... }
-- each section content is a list of CSV data
  return readFile(filename, DATA_FILE)
end function

------------------------------------------------------------------------------

global procedure saveFile(sequence filename, sequence content, integer file_type)
-- saves a sequence in a file structured as an Ini file
-- each section content may be:
--   a list of parameters and values { {parameter, value}, ... } if file_type = INI_FILE
--   a list of CSV data if file_type = DATA_FILE
  integer f_out

  f_out = open(filename, "w")
  for i = 1 to length(content) do
    puts(f_out, "["&content[i][1]&"]\n")
    for j = 1 to length(content[i][2]) do
      if length(content[i][2]) > 0 then
        if file_type = INI_FILE then
          puts(f_out, content[i][2][j][1]&"="&object2string(content[i][2][j][2])&"\n")
        elsif file_type = DATA_FILE then
          puts(f_out, sequence2CSV(content[i][2][j])&"\n")
        end if
      end if
    end for
    puts(f_out, "\n")
  end for
  close(f_out)
end procedure

------------------------------------------------------------------------------

global procedure saveIniFile(sequence filename, sequence content)
-- saves a sequence { {section name, section content}, ... } in an Ini file
-- each section content is a list of parameters and values { {parameter, value}, ... }
  saveFile(filename, content, INI_FILE)
end procedure

------------------------------------------------------------------------------

global procedure saveDataFile(sequence filename, sequence content)
-- saves a sequence { {section name, section content}, ... } in a data file
-- each section content is a list of CSV data
  saveFile(filename, content, DATA_FILE)
end procedure

------------------------------------------------------------------------------

global function searchINI(sequence ini, sequence section, sequence key)
  sequence s, words

  s = commonField(ini, 1, section)
  if length(s) = 1 then
    words = ini[s[1]][2]
    s = commonField(words, 1, key)
    if length(s) = 1 then
      return unquote(words[s[1]][2])
    else
      return ""
    end if
  else
    return ""
  end if
end function

------------------------------------------------------------------------------

global function readINI(sequence file, sequence section, sequence name, object value)
  -- reads an element of an INI file
  sequence s
  object x

  s = readIniFile(file)
--analyzeSequence(s, "s", f_debug)
  x = findID(s, section)
--analyzeSequence(x, "x", f_debug)
  if atom(x) then return value end if
  if length(x)<2 then return value end if
  s = x[2]
--analyzeSequence(s, "s", f_debug)
  x = findID(s, name)
--analyzeSequence(x, "x", f_debug)
  if atom(x) then return value end if
  if length(x)<2 then return value end if
  return unquote(x[2])
end function

------------------------------------------------------------------------------

global procedure writeINI(sequence file, sequence section, sequence name, object value)
  -- writes an element of an INI file
  sequence s, t, ini
  integer sec

  ini = readIniFile(file)
  s = commonField(ini, 1, section)   --recherche section
  if length(s)=0 then    -- nouvelle section
    ini = append(ini, {section, {{name,value}}})
  else   -- section existante
    sec = s[1]
    s = ini[sec]
    if length(s)<2 then  -- section vide
      s = append( s, {{name,value}} )
      ini[sec] = s
    else
      t = commonField(s[2], 1, name)    -- recherche item
      if length(t)=0 then    -- nouvel item
        s[2] = append( s[2], {name,value} )
        ini[sec] = s
      else                   -- item existant, a remplacer
        s[2][t[1]] = {name,value}
        ini[sec] = s
      end if
    end if
  end if
  saveIniFile(file, ini)
end procedure


