include machine.e
include graphics.e
include wildcard.e
include mouse.e
include myLibs\myTypes.e
include myLibs\myDebug.e
include myLibs\myMath.e
include myLibs\myConsole.e
include myLibs\myConv.e

global constant KEYB = 0, SCREEN = 1, ERR = 2
global constant Digit = "0123456789ABCDEF"
constant KEY_EVENT = 1, MOUSE_EVENT = 2  -- type of events

global procedure ClrEol(integer color)
-- clear end of line
sequence r, CurPos, vc
integer ScrCol      -- number of screen colomns
   vc = video_config()
   ScrCol = vc[VC_COLUMNS]
   CurPos = get_position()
   r = repeat(0,10)
   r[REG_AX] = #600
   r[REG_CX] = (CurPos[1]-1)*256+CurPos[2]-1
   r[REG_DX] = (CurPos[1]-1)*256 + ScrCol-1
   r[REG_BX] = color*16*256
   r = dos_interrupt(#10,r)
end procedure -- Clreol()

global function MousePresent()
-- return 1 if mouse detected
integer MouseVector
sequence r
   MouseVector = (256*peek(207)+peek(206)) *16 + 256*peek(205)+peek(204)
   if MouseVector  = 0 or peek(MouseVector) = #CF then
     return 0  -- no mouse
   end if
   r = repeat(0,10)
   r[REG_AX] =  0
   r = dos_interrupt(#33,r)
   return r[REG_AX] = #FFFF  -- r[REG_AX] = #FFFF if mouse present
end function -- MousePresent

global function GetEvent()
-- loop and wait for a mouse or key event.
integer key object mouse
    while 1 do
    key = upper(get_key())
    if key > -1 then
	return {KEY_EVENT,key}
    end if
    mouse = get_mouse()
    if sequence(mouse) then
       if mouse[1] = LEFT_DOWN or mouse[1] = RIGHT_DOWN then
	return {MOUSE_EVENT,mouse}
       end if
    end if
    end while
end function -- GetEvent

global function DetectCD_ROM()
sequence r
integer FirstCD, NbrCD
    r = repeat(0,10)
    r[REG_AX] = #1500
    r = dos_interrupt(#2F,r)
    FirstCD = remainder(r[REG_CX],256)
    NbrCD = remainder(r[REG_BX],256)
    return {FirstCD,NbrCD}
end function -- DetectCD_ROM()

-- This will return a list of floppies, hard drives and CD-ROM
global function GetDriveList()
  integer hdn,fdn
  sequence fl,hl,cdl, cdInfo

  fdn = floor(peek(#410) / 64) -- number of floppies
  if fdn = 0 then
    fl = "A"
  elsif fdn = 1 then
    fl = "AB"
  end if

  hdn = peek(#475) -- number of hard disk
  if hdn = 1 then
     hl = "C"
  elsif hdn = 2 then
     hl = "CD"
  end if
--check for CD-ROM
  cdl = ""
  cdInfo = DetectCD_ROM()
  if cdInfo[2] then
    for i = 0  to cdInfo[2] -1  do
    cdl = cdl & "A"+i+cdInfo[1]
    end for
  end if
  return fl & hl & cdl
end function -- GetDriveList()

global procedure Scroll(atom x1, atom y1, atom x2, atom y2, atom nl, atom down, atom c)
  sequence reg_list -- list of register values

  if ((x2 <= x1) or (y2 <= y1)) then
    return
  end if
  reg_list = repeat(0, 10)
  if (down) then
    reg_list[REG_AX] = byte2word(nl, 7)
  else
    reg_list[REG_AX] = byte2word(nl, 6)
  end if
  reg_list[REG_BX] = byte2word(0, c)
  reg_list[REG_CX] = byte2word(x1-1, y1-1)
  reg_list[REG_DX] = byte2word(x2-1, y2-1)
  reg_list = dos_interrupt(#10, reg_list) -- Call DOS video interrupt #10
  if and_bits(reg_list[REG_FLAGS], 1) then
    puts(ERR, "Problem with DOS video interrupt\n")
  end if
  text_color(lowByte(c))
  bk_color(highByte(c))
end procedure

-----------------------------------------------------------
--      Calcul deplacement dans le segment VIDEO
-----------------------------------------------------------

function Adresse(atom x, atom y)
  return (((y-1)*160) + ((x-1)*2))
end function

-----------------------------------------------------------
-- Change l'attribut des Count caracteres commencant  X, Y
-----------------------------------------------------------

global procedure ChgAttr(atom x, atom y, atom attr, atom count)
  atom offset

  offset = Adresse(x, y)
  for i=1 to count do
    poke(#B8000+offset+1, attr)
    offset = offset + 2
  end for
end procedure

