-- myConsole.e
-- v1.0
-- 2012-08-14
-- console functions

-------------------------------------------------------------------------------

-- global sequence TextAttr
-- global integer  TextRows, TextCols
-- global constant KEYB = 0, SCREEN = 1, ERR = 2

-- global procedure setTextAttr(sequence col)
-- global function  editText(sequence s, sequence attr, sequence pos, integer longueur)
-- global procedure displayMsg(sequence msg, object pos)
-- global function  listBox(sequence liste, integer defaut, sequence attr, sequence pos, integer long)
-- global function  comboBox(sequence liste, integer defaut, sequence attr, sequence pos, integer long)

-------------------------------------------------------------------------------

include graphics.e
include image.e
include keys.e
include get.e
include myTypes.e
include myConv.e
include myDebug.e
include myMath.e
include mySeq.e
include klrconio.e

global sequence TextAttr
global integer TextRows, TextCols
TextAttr = {WHITE, BLACK}
TextRows = 25
TextCols = 80

global constant KEYB = 0, SCREEN = 1, ERR = 2

integer
  listLine, listSelected, listOffset

------------------------------------------------------------------------------

global procedure setTextAttr(sequence col)
  text_color(col[1])
  bk_color(col[2])
  TextAttr = col
end procedure

------------------------------------------------------------------------------

global procedure printAt(sequence pos, object obj, sequence format, sequence col)
  sequence Attr

  if sequence(obj) and (length(obj)=0) then return end if
  Attr = TextAttr
  setTextAttr(col)
  gotoXY(pos[2], pos[1])
  if sequence(obj) then
    cPrintf(format, {obj})
  else
    cPrintf(format, obj)
  end if
  setTextAttr(Attr)
end procedure

------------------------------------------------------------------------------

procedure drawFrame(integer x1, integer y1, integer x2, integer y2, sequence attr)
  setTextAttr(attr)
  gotoXY(x1, y1)
  cPuts(""&repeat('', x2-x1-1)&"")
  for i = 1 to y2-y1-1 do
    gotoXY(x1, y1+i) cPuts("")
    gotoXY(x2, y1+i) cPuts("")
  end for
  gotoXY(x1, y2)
  cPuts(""&repeat('', x2-x1-1)&"")
end procedure

-------------------------------------------------------------------------------

global procedure displayMsg(sequence msg, object pos)
-- prints a message in a frame at position pos
-- if pos is an atom (mostly 0), then center the frame in the screen
  sequence saved, col, s
  integer h, w, x1, y1, x2, y2
  atom c

  col = TextAttr
  s = splitString(msg, '\n')
  h = length(s)
  w = 0
  for i = 1 to h do
    if length(s[i]) > w then w = length(s[i]) end if
  end for
  if atom(pos) then
    x1 = floor((TextCols-w)/2)
    y1 = floor((TextRows-h)/2)
    x2 = x1+w+1
    y2 = y1+h+1
  else
    x1 = pos[2]-1
    x2 = pos[2]+w
    y1 = pos[1]-1
    y2 = pos[1]+h
  end if
  saved = save_text_image({y1,x1}, {y2,x2})
  drawFrame(x1, y1, x2, y2, {GRAY,WHITE})
  gotoXY(x1+1,y1+1)
  setTextAttr({GRAY,WHITE})
  cPuts( msg)
  c = wait_key()
  display_text_image({y1,x1}, saved)
  setTextAttr(col)
end procedure

-------------------------------------------------------------------------------

global function editText(sequence s, sequence attr, sequence pos, integer longueur)
  sequence text
  integer l, strPtr
  atom ex
  sequence col
  atom fl_out, fl_ins, first

  col = TextAttr
  fl_ins = 1
  cursor(#0E0F)
  fl_out = 0
  setTextAttr(attr)
  text = s  l = 0
  strPtr = 1
  first = 1
  while fl_out = 0 do
    gotoXY(pos[2], pos[1])  cPuts( repeat(' ', longueur))
    gotoXY(pos[2], pos[1])  cPuts( mid(text, 1, longueur))
    gotoXY(pos[2] + strPtr - 1, pos[1])
    ex = wait_key()
    if ex = HOME then
       strPtr = 1
    elsif ex = END then
      if length(text) < longueur then
        strPtr = length(text) + 1
      else
        strPtr = length(text)
      end if
    elsif ex = LEFT then
      if strPtr > 1 then
        strPtr = strPtr - 1
      end if
    elsif ex = RIGHT then
      if (strPtr < longueur) and (strPtr < length(text)+1) then
        strPtr = strPtr + 1
      end if
    elsif ex = DELETE then
      l = length(text)
      if strPtr <= l then
        if strPtr = 1 then
          text = text[2..l]
        elsif strPtr = l then
          text = text[1..l-1]
          strPtr = l-1
        else
          text = delete(text, strPtr, 1)
        end if
      end if
    elsif ex = INSERT then
      fl_ins = not fl_ins
      if fl_ins then
        cursor(#0E0F)
      else
        cursor(#000F)
      end if
    elsif (ex = UP) or (ex = DOWN) or (ex = ENTER) or (ex = ESC) then
      fl_out = 1
    elsif ex = BACKSPACE then
      l = length(text)
      if strPtr > 1 then
        text = delete(text, strPtr-1, 1)
        strPtr = strPtr-1
      end if
    else
      if first then
        text = append("", ex)
        strPtr = 2
      elsif fl_ins and (length(text) < longueur) then
        text = insert(text, ex, strPtr)
        if (strPtr < longueur) and (strPtr < length(text)+1) then
          strPtr = strPtr + 1
        end if
      elsif (not fl_ins) and (strPtr <= length(text)) then
        text[strPtr] = ex
        if (strPtr < longueur) and (strPtr < length(text)+1) then
          strPtr = strPtr + 1
        end if
      end if
    end if
    first = 0
  end while
  setTextAttr(col)
  cursor(#2000)
  return {text, ex}
end function

-------------------------------------------------------------------------------

procedure listGoFirst(sequence currentList)
  if length(currentList)=0 then return end if
  listSelected = 1
  listLine = 1
  listOffset = 0
end procedure

-------------------------------------------------------------------------------

procedure listGoPrevious(sequence currentList)
  if length(currentList)=0 then return end if
  if listSelected=1 then return end if
  listSelected -= 1
  if listLine=1 then
    listOffset -= 1
  else
    listLine -= 1
  end if
end procedure

-------------------------------------------------------------------------------

procedure listGoNext(sequence currentList)
  if length(currentList)=0 then return end if
  if listSelected=length(currentList) then return end if
  listSelected += 1
  if listLine=3 then
    listOffset += 1
  else
    listLine += 1
  end if
end procedure

-------------------------------------------------------------------------------

procedure listGoLast(sequence currentList)
  integer lg

  lg = length(currentList)
  if lg=0 then
    listLine = 0
    listSelected = 0
    listOffset = 0
    return
  end if
  if lg >= 3 then
    listLine = 3
    listOffset = lg-3
  else
    listGoFirst(currentList)
    listLine = lg
  end if
  listSelected = lg
end procedure

-------------------------------------------------------------------------------

procedure listGo(sequence currentList, integer pos)
  if pos = 0 then
    listLine = 0
    listSelected = 0
    listOffset = 0
  elsif pos = 1 then
    listGoFirst(currentList)
  elsif pos = length(currentList) then
    listGoLast(currentList)
  else
    listLine = 2
    listSelected = pos
    listOffset = pos-2
  end if
end procedure

-------------------------------------------------------------------------------

procedure refreshListBox(sequence liste, sequence pos, integer long)
  sequence s

  for i = 1 to min({3,length(liste)}) do
    gotoXY(pos[2]+1,pos[1]+i)
    if i = listLine then
      setTextAttr({WHITE,BLUE})
    else
      setTextAttr({GRAY,WHITE})
    end if
    s = liste[listOffset+i]
    cPuts( rightPad(s[1..min({long, $})], long))
  end for
end procedure

-------------------------------------------------------------------------------

function drawListBox(sequence liste, integer defaut, sequence pos, integer long)
  sequence saved, col
  integer m, x1, y1, x2, y2

  col = TextAttr
  x1 = pos[2]-1
  x2 = pos[2]+long
  m = min({3,length(liste)})
  y1 = pos[1]-1
  y2 = pos[1]+m
  saved = save_text_image({y1,x1}, {y2,x2})
  drawFrame(x1, y1, x2, y2, {GRAY,WHITE})
  listGo(liste, defaut)
  refreshListBox(liste, {y1,x1}, long)
  setTextAttr(col)
  return {{y1,x1},saved}
end function

-------------------------------------------------------------------------------

global function listBox(sequence liste, integer defaut, sequence attr, sequence pos, integer long)
  sequence saved, s, box, col
  sequence resultat

  col = TextAttr
  setTextAttr(attr)
  s = drawListBox(liste, defaut, pos, long)
  saved = s[2]
  box = s[1]
  resultat = {0, 0}
  listSelected = defaut
  while (resultat[2] != ENTER) and (resultat[2] != ESC) do
    gotoXY(pos[1],pos[2])
    resultat[2] = ' '
    while (resultat[2] != ENTER) and (resultat[2] != ESC)
      and (resultat[2] != UP) and (resultat[2] != DOWN) do
      resultat[2] = wait_key()
    end while
    if resultat[2] = ENTER then
      resultat[1] = liste[listSelected]
    elsif resultat[2] = UP then
      listGoPrevious(liste)
    elsif resultat[2] = DOWN then
      listGoNext(liste)
    elsif resultat[2] = ESC then
      resultat[1] = ""
    end if
    refreshListBox(liste, box, long)
  end while
  setTextAttr(col)
  return resultat
end function

-------------------------------------------------------------------------------

function drawComboListBox(sequence liste, integer defaut, sequence pos, integer long)
  sequence saved, col
  integer m, x1, y1, x2, y2

  col = TextAttr
  x1 = pos[2]-1
  x2 = pos[2]+long
  m = min({3,length(liste)})
  y2 = pos[1]+m+2
  if y2 <= TextRows then
printf(f_debug, "ScreenWidth = %d\n", TextCols)
printf(f_debug, "ScreenHeight = %d\n", TextRows)
    y1 = pos[1]+1
  else
    y1 = pos[1]-m-2
    y2 = pos[1]-1
  end if
  saved = save_text_image({y1,x1}, {y2,x2})
  drawFrame(x1, y1, x2, y2, {GRAY,WHITE})
  listGo(liste, defaut)
  refreshListBox(liste, {y1,x1}, long)
  setTextAttr(col)
  return {{y1,x1},saved}
end function

-------------------------------------------------------------------------------

global function comboBox(sequence liste, integer defaut, sequence attr, sequence pos, integer long)
  sequence saved, s, box, col
  sequence resultat

puts(f_debug, "comboBox\n")
  col = TextAttr
  setTextAttr(attr)
  s = drawComboListBox(liste, defaut, pos, long)
  saved = s[2]
  box = s[1]
  resultat = {0, 0}
  listSelected = defaut
  if (defaut = 0) or (length(liste)=0) then
    s = ""
  else
    s = liste[listSelected]
  end if
--analyzeSequence(s, "s", f_debug)
  while (resultat[2] != ENTER) and (resultat[2] != ESC) do
    resultat = editText(s, attr, pos, long)
--analyzeSequence(resultat, "resultat", f_debug)
    if resultat[2] = ENTER then
    elsif resultat[2] = UP then
      listGoPrevious(liste)
      s = liste[listSelected]
    elsif resultat[2] = DOWN then
      listGoNext(liste)
      s = liste[listSelected]
    elsif resultat[2] = ESC then
      resultat[1] = ""
    end if
    refreshListBox(liste, box, long)
  end while
  display_text_image(box, saved)
  setTextAttr(col)
  gotoXY(pos[2],pos[1])
  cPuts( rightPad(resultat[1], long))
  return resultat
end function

-------------------------------------------------------------------------------

global function textCombo(sequence liste, integer defaut, sequence attr, sequence pos, integer long)
  sequence resultat
  sequence text
  integer n, nb, f

  nb = length(liste)
  resultat = {0, 0}
  if nb=0 then
    text = ""
    n = 0
  else
    if defaut = 0 then
      text = liste[1]
      n = 1
    else
      text = liste[defaut]
      n = defaut
    end if
  end if
  while (resultat[2] != ENTER) and (resultat[2] != ESC) do
    resultat = editText(text, attr, pos, long)
    if resultat[2] = ENTER then
    elsif resultat[2] = UP then
      if compare(resultat[1], text) != 0 then
        f = 0
        for i = 1 to length(liste) do
          if match(resultat[1], liste[i]) = 1 then
	       f = i
            exit
          end if
        end for
	   if f > 0 then n = f end if
      elsif n > 1 then
        n = n-1
      end if
    elsif resultat[2] = DOWN then
      if compare(resultat[1], text) != 0 then
        f = 0
        for i = 1 to length(liste) do
          if match(resultat[1], liste[i]) = 1 then
	       f = i
            exit
          end if
        end for
	   if f > 0 then n = f end if
      elsif n < nb then
        n = n+1
      end if
    elsif resultat[2] = ESC then
      n = 0
    end if
    if n > 0 then text = liste[n] end if
  end while
  return resultat
end function
