-- klrconio.e
-- text mode Euphoria routines for the Windows console based on kernel32

-- globals
-- cPuts(sequence s)
-- cPrintf(sequence format, object data)
-- gotoXY(integer x, integer y)
-- clrScr()
-- clrEol()
-- insLine()
-- delLine()
-- whereX() returns integer
-- whereY() returns integer
-- getScreenHeight() returns integer
-- getScreenWidth() returns integer
-- getText(int x1, int y1, int x2, int y2, atom savebuf)
-- putText(int x1, int y1, int x2, int y2, atom savebuf)
-- cBreakOn()  allows Ctrl_c to stop execution
-- cBreakOff()  Ctrl_c will not stop execution (but Ctrl_Break will)
--   getCh() will return ascii integer 3 for Ctrl_c
-- setScreenTitle(sequence s)
-- getCh() reads but does not echo a keypress and returns a
--   sequence of five integers
--   (1)  ascii code, or zero if none
--   (2)  dos extended key code, or zero if key is ascii
--   (3)  win32 virtual key code
--   (4)  shift state, considers capslock and shift keys
--   (5)  control key state, one for set, zero for not
-- cGets() echos and returns a character sequence from the keyboard
-- seq2int(sequence s) returns object
-- seq2float(sequence s) returns object
--   the object is an atom if s contains (only) a valid number, or else
--   it is a sequence containing the characters "nan"

-- notes
-- screen coordinates start at 1
-- getText and putText save and restore (a portion of) the screen
--   example--save and restore the entire screen:
--   integer savex, savey, maxx, maxy
--   atom savebuf
--   maxx=getScreenWidth()
--   maxy=getScreenHeight()
--   savebuf=allocate(2*maxx*maxy)
--   savex=whereX()
--   savey=whereY()
--   getText(1,1,maxx,maxy,savebuf)
--   clrScr()
--   ...
--   putText(1,1,maxx,maxy,savebuf)
--   gotoXY(savex,savey)
--   free(savebuf)

include dll.e
include machine.e
include myDebug.e
include mySeq.e

--constants, none of these are global

constant STD_OUTPUT_HANDLE = #FFFFFFF5
constant STD_INPUT_HANDLE = #FFFFFFF6

atom kernel32
  kernel32 = open_dll("kernel32.dll")

constant GetStdHandle =
  define_c_func(kernel32,"GetStdHandle",
  {C_UINT},C_INT)

constant SetConsoleTitle =
  define_c_proc(kernel32,"SetConsoleTitleA",
  {C_POINTER})

constant SetConsoleMode =
  define_c_proc(kernel32,"SetConsoleMode",
  {C_INT,C_INT})

constant WriteConsole =
  define_c_proc(kernel32,"WriteConsoleA",
  {C_INT,C_POINTER,C_INT,C_POINTER,C_POINTER})

constant GetConsoleScreenBufferInfo =
  define_c_proc(kernel32,"GetConsoleScreenBufferInfo",
  {C_INT,C_POINTER})

constant FillConsoleOutputAttribute =
  define_c_proc(kernel32,"FillConsoleOutputAttribute",
  {C_INT,C_CHAR,C_INT,C_UINT,C_POINTER})

constant FillConsoleOutputCharacter =
  define_c_proc(kernel32,"FillConsoleOutputCharacterA",
  {C_INT,C_CHAR,C_INT,C_UINT,C_POINTER})

constant SetConsoleScreenBufferSize =
  define_c_proc(kernel32,"SetConsoleScreenBufferSize",
  {C_INT,C_UINT})


constant SetConsoleCursorPosition =
  define_c_proc(kernel32,"SetConsoleCursorPosition",
  {C_INT,C_UINT})

constant ScrollConsoleScreenBuffer =
  define_c_proc(kernel32,"ScrollConsoleScreenBufferA",
  {C_INT,C_POINTER,C_POINTER,C_UINT,C_POINTER})

constant ReadConsoleOutput =
  define_c_proc(kernel32,"ReadConsoleOutputA",
  {C_INT,C_POINTER,C_UINT,C_UINT,C_POINTER})

constant WriteConsoleOutput =
  define_c_proc(kernel32,"WriteConsoleOutputA",
  {C_INT,C_POINTER,C_UINT,C_UINT,C_POINTER})

constant ReadConsoleInput =
  define_c_proc(kernel32,"ReadConsoleInputA",
  {C_INT,C_POINTER,C_INT,C_POINTER})

constant
  SBI_BYTES = 22,
  SBI_SIZEX = 0,      -- size of the console screen buffer, in character columns
  SBI_SIZEY = 2,      -- size of the console screen buffer, in character rows
  SBI_CPOSX = 4,      -- column coordinates of the cursor in the console screen buffer
  SBI_CPOSY = 6,      -- row coordinates of the cursor in the console screen buffer
  SBI_ATTR = 8,       -- attributes of the characters written to a screen buffer
  SBI_WINX1 = 10,     -- console screen buffer upper-left column
  SBI_WINX2 = 12,     -- console screen buffer upper-left row
  SBI_WINY1 = 14,     -- console screen buffer lower-right column
  SBI_WINY2 = 16,     -- console screen buffer lower-right row
  SBI_MAX_X = 18,     -- maximum size of the console window, in character columns
  SBI_MAX_Y = 20      -- maximum size of the console window, in character rows


constant
  INREC_BYTES = 20,
  INREC_EVENT = 0,
  INREC_KEYDOWN = 4,
  INREC_VKCODE = 10,
  INREC_ASCII = 14,
  INREC_CTRL = 16,

  CTRL_C_EVENT = 0,
  KEY_EVENT = 1,

  RIGHT_ALT_PRESSED = #1,
  LEFT_ALT_PRESSED =  #2,
  RIGHT_CTRL_PRESSED = #4,
  LEFT_CTRL_PRESSED = #8,
  SHIFT_PRESSED = #10,
  CAPSLOCK_ON = #80,

  VK_SHIFT = #10,
  VK_CONTROL = #11,
  VK_CAPITAL = #14,
  VK_NUMLOCK = #90,
  VK_SCROLL = #91,
  VK_SNAPSHOT = #2C,
  VK_MENU = #12,
  VK_LEFT = #25,
  VK_RIGHT = #27,
  VK_UP = #26,
  VK_DOWN = #28,
  VK_DELETE = #2E,
  VK_HOME = #24,
  VK_END = #23,
  VK_PRIOR = #21,
  VK_NEXT = #22,
  VK_INSERT = #2D,
  VK_F1 = #70,
  VK_F2 = #71,
  VK_F3 = #72,
  VK_F4 = #73,
  VK_F5 = #74,
  VK_F6 = #75,
  VK_F7 = #76,
  VK_F8 = #77,
  VK_F9 = #78,
  VK_F10 = #79,
  VK_F11 = #7A,
  VK_F12 = #7B


-- functions and procedures (not all of these are global)

function coord(integer x, integer y)
  return (x+y*#10000)
  end function

global procedure cPuts(sequence s)
  integer hout
  atom cs, pdm
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  cs=allocate_string(s)
  pdm=allocate(4)
  c_proc(WriteConsole,{hout,cs,length(s),pdm,NULL})
  free(pdm)
  free(cs)
  end procedure

global procedure cPrintf(sequence fs, object data)
  sequence s
  s=sprintf(fs,data)
  cPuts(s)
  end procedure

global function getConsoleInfo()
  integer hout, nx, ny, attr, cx, cy, x1, x2, y1, y2, maxx, maxy
  atom sbi
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  hexDump(peek({sbi,SBI_BYTES}), f_debug)
  nx=peek(sbi+SBI_SIZEX)
  ny=peek(sbi+SBI_SIZEY)
  cx=1+peek(sbi+SBI_CPOSX)
  cy=1+peek(sbi+SBI_CPOSY)
  attr=peek(sbi+SBI_ATTR)
  x1=peek(sbi+SBI_WINX1)
  x2=peek(sbi+SBI_WINX2)
  y1=peek(sbi+SBI_WINY1)
  y2=peek(sbi+SBI_WINY2)
  maxx=peek(sbi+SBI_MAX_X)
  maxy=peek(sbi+SBI_MAX_Y)
  free(sbi)
  return {nx,ny,cx,cy,attr,x1,x2,y1,y2,maxx,maxy}
  end function

global procedure clrScr()
  integer hout, ntot, nx, ny, attr
  atom sbi, ncw
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  ncw=allocate(4)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  nx=peek(sbi+SBI_SIZEX)
  ny=peek(sbi+SBI_SIZEY)
  attr=peek(sbi+SBI_ATTR)
  ntot=nx*ny
  c_proc(FillConsoleOutputAttribute,{hout,attr,ntot,coord(0,0),ncw})
  c_proc(FillConsoleOutputCharacter,{hout,' ',ntot,coord(0,0),ncw})
  c_proc(SetConsoleCursorPosition,{hout,coord(0,0)})
  free(ncw)
  free(sbi)
  end procedure

global procedure setWindowSize(integer x, integer y)
  integer hout
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  c_proc(SetConsoleScreenBufferSize,{hout,coord(x-1,y-1)})
  end procedure

global procedure gotoXY(integer x, integer y)
  integer hout
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  c_proc(SetConsoleCursorPosition,{hout,coord(x-1,y-1)})
  end procedure

global function whereX()
  integer hout, x
  atom sbi
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  x=1+peek(sbi+SBI_CPOSX)
  free(sbi)
  return x
  end function

global function whereY()
  integer hout, y
  atom sbi
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  y=1+peek(sbi+SBI_CPOSY)
  free(sbi)
  return y
  end function

global function getScreenHeight()
  integer hout, h
  atom sbi
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  h=peek(sbi+SBI_SIZEY)
  free(sbi)
  return h
  end function

global function getScreenWidth()
  integer hout, w
  atom sbi
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  w=peek(sbi+SBI_SIZEX)
  free(sbi)
  return w
  end function

global procedure clrEol()
  integer hout
  atom sbi, ncw, where
  integer nc, attr
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  sbi=allocate(SBI_BYTES)
  ncw=allocate(4)
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  nc=peek(sbi+SBI_SIZEX)-peek(sbi+SBI_CPOSX)
  where=coord(peek(sbi+SBI_CPOSX),peek(sbi+SBI_CPOSY))
  attr=peek(sbi+SBI_ATTR)
  c_proc(FillConsoleOutputCharacter,{hout,' ',nc,where,ncw})
  c_proc(FillConsoleOutputAttribute,{hout,attr,nc,where,ncw})
  free(ncw)
  free(sbi)
  end procedure

global procedure insLine()
  integer hout, left, top, right, bottom, attr
  atom sbi, rect, charinfo
  sbi=allocate(SBI_BYTES)
  rect=allocate(8)
  charinfo=allocate(4)
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  attr=peek(sbi+SBI_ATTR)
  left=peek(sbi+SBI_WINX1)
  top=peek(sbi+SBI_CPOSY)
  right=peek(sbi+SBI_WINX2)
  bottom=peek(sbi+SBI_WINY2)
  poke(rect,{left,0,top,0,right,0,bottom,0})
  poke(charinfo,{' ',0,attr,0})
  c_proc(ScrollConsoleScreenBuffer,{hout,rect,NULL,coord(left,1+top),charinfo})
  free(charinfo)
  free(rect)
  free(sbi)
  end procedure

global procedure delLine()
  integer hout, left, top, right, bottom, attr
  atom sbi, rect, charinfo
  sbi=allocate(SBI_BYTES)
  rect=allocate(8)
  charinfo=allocate(4)
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  c_proc(GetConsoleScreenBufferInfo,{hout,sbi})
  attr=peek(sbi+SBI_ATTR)
  left=peek(sbi+SBI_WINX1)
  top=peek(sbi+SBI_CPOSY)
  right=peek(sbi+SBI_WINX2)
  bottom=peek(sbi+SBI_WINY2)
  poke(rect,{left,0,1+top,0,right,0,bottom,0})
  poke(charinfo,{' ',0,attr,0})
  c_proc(ScrollConsoleScreenBuffer,{hout,rect,NULL,coord(left,top),charinfo})
  free(charinfo)
  free(rect)
  free(sbi)
  end procedure

global procedure getText(integer left, integer top, integer right,
    integer bottom, atom textbuf)
  integer hout, bufx, bufy, nbuf
  atom charinfobuf, rect
  sequence sdm
  rect=allocate(8)
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  poke(rect,{left-1,0,top-1,0,right-1,0,bottom-1,0})
  bufx=(1+right-left)
  bufy=(1+bottom-top)
  nbuf=bufx*bufy
  charinfobuf=allocate(4*nbuf)
  c_proc(ReadConsoleOutput,{hout,charinfobuf,coord(bufx,bufy),
    coord(0,0),rect})
  for i=0 to (nbuf-1) do
    sdm=peek({charinfobuf+4*i,4})
    poke(textbuf+2*i,{sdm[1],sdm[3]})
    end for
  free(charinfobuf)
  free(rect)
  end procedure

global procedure putText(integer left, integer top, integer right,
    integer bottom, atom textbuf)
  integer hout, bufx, bufy, nbuf
  atom charinfobuf, rect
  sequence sdm
  rect=allocate(8)
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  poke(rect,{left-1,0,top-1,0,right-1,0,bottom-1,0})
  bufx=(1+right-left)
  bufy=(1+bottom-top)
  nbuf=bufx*bufy
  charinfobuf=allocate(4*nbuf)
  for i=0 to (nbuf-1) do
    sdm=peek({textbuf+2*i,2})
    poke(charinfobuf+4*i,{sdm[1],0,sdm[2],0})
    end for
  c_proc(WriteConsoleOutput,{hout,charinfobuf,coord(bufx,bufy),
    coord(0,0),rect})
  free(charinfobuf)
  free(rect)
  end procedure

global procedure setScreenTitle(sequence s)
  integer hout
  atom cs
  hout=c_func(GetStdHandle,{STD_OUTPUT_HANDLE})
  cs=allocate_string(s)
  c_proc(SetConsoleTitle,{cs})
  free(cs)
  end procedure

function doscode(integer vk, integer ctr)
  -- returns the dos extended key code for non-ascii keys
  integer ret
  if vk=VK_LEFT then
      if ctr then ret=#73 else ret=#4B end if
    elsif vk=VK_RIGHT then
      if ctr then ret=#74 else ret=#4D end if
    elsif vk=VK_UP then ret=#48
    elsif vk=VK_DOWN then ret=#50
    elsif vk=VK_DELETE then ret=#53
    elsif vk=VK_HOME then
      if ctr then ret=#77 else ret=#47 end if
    elsif vk=VK_END then
      if ctr then ret=#75 else ret=#4F end if
    elsif vk=VK_PRIOR then ret= #49
    elsif vk=VK_NEXT then ret=#51
    elsif vk=VK_INSERT then ret=#52
    elsif vk=VK_F1 then ret=#3B
    elsif vk=VK_F2 then ret=#3C
    elsif vk=VK_F3 then ret=#3D
    elsif vk=VK_F4 then ret=#3E
    elsif vk=VK_F5 then ret=#3F
    elsif vk=VK_F6 then ret=#40
    elsif vk=VK_F7 then ret=#41
    elsif vk=VK_F8 then ret=#42
    elsif vk=VK_F9 then ret=#43
    elsif vk=VK_F10 then ret=#44
    elsif vk=VK_F11 then ret=#85
    elsif vk=VK_F12 then ret=#86
    else  ret=0
    end if
  return ret
  end function

global function getCh()
  integer hin, ascii, dos, vk, shift, ctrl, s, k, shp, cpl, done
  atom inrec, nr
  inrec=allocate(INREC_BYTES)
  nr=allocate(4)
  hin=c_func(GetStdHandle,{STD_INPUT_HANDLE})
  done=0
  while not done do
    c_proc(ReadConsoleInput,{hin,inrec,1,nr})
    if(peek(inrec+INREC_EVENT)=KEY_EVENT) then
      if(peek(inrec+INREC_KEYDOWN)) then
        k=peek(inrec+INREC_VKCODE)
        if not ( (k=VK_SHIFT) or (k=VK_CONTROL) or (k=VK_CAPITAL) or
          (k=VK_NUMLOCK) or (k=VK_SCROLL) or (k=VK_SNAPSHOT) or
          (k=VK_MENU) ) then
          s=peek(inrec+INREC_CTRL)
          if not (and_bits(s,LEFT_ALT_PRESSED)
            or and_bits(s,RIGHT_ALT_PRESSED)) then
            shp=and_bits(s,SHIFT_PRESSED)
            cpl=and_bits(s,CAPSLOCK_ON)
            ascii=peek(inrec+INREC_ASCII)
            shift=(shp and not cpl) or (not shp and cpl)
            ctrl=and_bits(s,RIGHT_CTRL_PRESSED) or
              and_bits(s,LEFT_CTRL_PRESSED)  -- or (ascii=3)
            vk=k
            done=1
            end if
          end if
        end if
      end if
    end while
  if shp and (ascii=9) then  --tabLeft
    dos=#0F
    ascii=0
    elsif ascii then dos=0
    else dos=doscode(vk,ctrl)
    end if
  return {ascii,dos,vk,shift,ctrl}
  end function

global function cGets()
  sequence gs, resp
  integer zz, ia
  resp=""
  ia=0
  while(1) do
    gs=getCh()
    zz=gs[1]
    if zz>=' ' and zz<='~' then
      resp=append(resp,zz)
      ia=ia+1
      cPuts({zz})
    elsif (ia and zz=8) then  --backspace
      ia=ia-1
      resp=resp[1..ia]
      cPuts({8,' ',8})
    elsif zz='\r' or zz='\n' then exit
    elsif zz=27 then resp="" exit  --escape forces null return
    end if
    end while
  return resp
  end function

global function seq2int(sequence s)
  integer n, minus, c, k, issign
  sequence s1
  s1=""
  minus=0 k=0 issign=0
  for i=1 to length(s) do
    c=s[i]
    if c>='0' and c<='9' then s1=append(s1,c) k=k+1
      elsif c='-' and k=0 and issign=0 then minus=1 issign=1
      elsif c='+' and k=0 and issign=0 then issign=1
      elsif c=' ' and k=0 and issign=0 then  --ignore leading blank
      else exit  --parsing stops at unexpected character
      end if
    end for
  if k=0 then return "nan" end if
  n=0
  for i=1 to k do n=10*n+(s1[i]-'0') end for
  if minus then n= -n end if
  return n
  end function

global function seq2float(sequence s)
  atom x, fp
  integer c, minus, iexp, eminus,
    issign, isd, isesign, ise, ki, kf, ke
  sequence si, sf, se
  si="" sf="" se=""
  minus=0 eminus=0 issign=0 isd=0 ise=0 isesign=0
  ki=0 kf=0 ke=0
  for i=1 to length(s) do
    c=s[i]
    if c>='0' and c<='9' then
      if ise then se=append(se,c) ke=ke+1
        elsif isd then sf=append(sf,c) kf=kf+1
        else si=append(si,c) ki=ki+1
        end if
      elsif c='-' and isd=0 and ki=0 and issign=0 then minus=1 issign=1
      elsif c='+' and isd=0 and ki=0 and issign=0 then issign=1
      elsif c='-' and ise and ke=0 and isesign=0 then eminus=1 isesign=1
      elsif c='+' and ise and ke=0 and isesign=0 then isesign=1
      elsif c='.' and isd=0 then isd=1
      elsif (c='e' or c='E') and ise=0 then ise=1
      elsif c=' ' and ki=0 and isd=0 and ise=0 and issign=0 then
        --ignore leading blank
      else exit  --parsing stops at unexpected character
      end if
    end for
  if ki=0 and kf=0 then return "nan" end if
  x=0.0
  for i=1 to ki do x=10*x+(si[i]-'0') end for
  fp=1.0
  for i=1 to kf do fp=0.1*fp x=x+fp*(sf[i]-'0') end for
  if minus then x= -x end if
  iexp=0
  for i=1 to ke do iexp=10*iexp+(se[i]-'0') end for
  if eminus then iexp= -iexp end if
  x=x*power(10,iexp)
  return x
  end function

global procedure cBreakOn()
  integer hin
  hin=c_func(GetStdHandle,{STD_INPUT_HANDLE})
  c_proc(SetConsoleMode,{hin,1})
  end procedure

global procedure cBreakOff()
  integer hin
  hin=c_func(GetStdHandle,{STD_INPUT_HANDLE})
  c_proc(SetConsoleMode,{hin,0})
  end procedure
