-- common.e
-- library of common reusable functions
-- v1.13
-- 2013-03-08
-- history:
-- v1.0   2010-07-26
-- v1.01
--   changed french terms to english ones
--   saveCSV uses quotes around strings
-- v1.02
--   changed id from atom to object in findID
-- v1.03  2010-07-28
--   added dateStamp function
-- v1.04  2010-07-29
--   added min and max functions
-- v1.05  2010-08-04
--   added  function appendIfNew
-- v1.06  2010-09-29
--   added function utf8_to_ascii
-- v1.07  2010-10-04
--   new INI files management
-- v1.08  2010-11-05
--   added searchINI
-- v1.09  2010-11-05
-- added insert, delete, replace, mid from Irv Mullins (irv@ellijay.com)
-- v1.10  2010-11-06
-- modified strtok to convert floats
-- v1.11  2010-11-10
-- added copyFile
-- v1.12  2013-03-06
-- added execTask
-- v1.13  2013-03-08
-- added itemPos, modified findID

include get.e
include md5.e
include msgbox.e
include file.e
include myTypes.e
include mySeq.e
include myDebug.e
include win32lib.ew
--with trace

------------------------------------------------------------------------------

-- returns first item from sheet sht with value val in field fld
global function itemPos(sequence sht, integer fld, object val)
  if fld = 0 then return 0 end if
  for i = 1 to length(sht) do
    if compare(sht[i][fld], val) = 0 then return i end if
  end for
  return 0
end function

------------------------------------------------------------------------------

global function commonField(sequence sht, integer fld, object val)
-- lists records from sheet sht with value val in field fld
  sequence res

  if fld = 0 then return {} end if
  res = {}
  for i = 1 to length(sht) do
--analyzeSequence(sht[i][fld], "sht[i][fld]", f_debug)
--analyzeSequence(val, "val", f_debug)
    if compare(sht[i][fld], val) = 0 then
      res = append(res, i)
    end if
  end for
  return res
end function

------------------------------------------------------------------------------

global function findID(sequence sht, object id)
-- find the record in sheet sht which ID (value in first column) is id
-- returns the record (sequence) if successful
-- returns 0 (atom) if not
  integer n

  n = itemPos(sht, 1, id)
  if n then return sht[n] else return 0 end if
end function

------------------------------------------------------------------------------

global function selectedFields(sequence sht, integer fld, object val, sequence fields)
-- list selected fields from sheet sht records with value val in field fld
-- ex: selectedFields(tab, 2, "John", {1,3}) will list items having
-- "John" in second column and return a sequence containing columns 1 and 3
--NB is this still useful? commonField returns the whole records
  sequence s, res
  integer l

  if (fld = 0) or (length(fields) = 0) then return {} end if
  s = commonField(sht, fld, val)
  l = length(s)
  res = {}
  if l = 1 then
    for i = 1 to length(fields) do
      res = append(res, sht[s[1]][fields[i]])
    end for
    return res
  else
    return {}
  end if
end function

------------------------------------------------------------------------------

global function commonFields(sequence sht, sequence fields, sequence vals)
-- list records from sheet sht with selected values in selected fields
-- ex: commonFields(tab, {1,3}, {5,"John"}) will list items having 5 in first column and "John" in third
  sequence res
  integer found
  
  if (length(fields) = 0) or (length(vals) = 0) or (length(fields) != length(vals)) then return {} end if
  res = {}
  for i = 1 to length(sht) do
    found = 1
    for j = 1 to length(fields) do
      if compare(sht[i][fields[j]], vals[j]) != 0 then
        found = 0
      end if
    end for
    if found = 1 then  
      res = append(res, i)
    end if
  end for
  return res
end function

------------------------------------------------------------------------------

global procedure delay(atom dt)
   atom t
   t=time()
   while time()-t<dt do
   end while
end procedure  -- delay

------------------------------------------------------------------------------

procedure execTask(sequence exc, sequence parms, sequence rep)
  integer exit_code

  exit_code = shellExecuteEx("open",
                     exc,
                     parms,
                     rep,
                     SW_MINIMIZE, -- SW_SHOWNORMAL,  --SW_HIDE,
                     0)
  if exit_code > 32 then
    -- logMsg( sprintf("Tche '%s %s' excute", {exc,parms}) )
  elsif exit_code = SE_ERR_FNF then
    logMsg( sprintf("Echec excution tche '%s %s', fichier non trouv", {exc,parms}) )
  elsif exit_code = SE_ERR_PNF then
    logMsg( sprintf("Echec excution tche '%s %s', chemin non trouv", {exc,parms}) )
  elsif exit_code = SE_ERR_ACCESSDENIED then
    logMsg( sprintf("Echec excution tche '%s %s', accs interdit", {exc,parms}) )
  else
--    logMsg( sprintf("Echec excution tche '%s %s', code d'erreur: %d", {exc,parms, exit_code}) )
    warnError( sprintf("Echec excution tche '%s %s', code d'erreur: %d", {exc,parms, exit_code}), 0)
  end if
end procedure

