-- classes.e
-- v0.51 - 2013-03-27
-- do not modify this file

include myLibs/myDebug.e
include myLibs/common.e
include myLibs/mySeq.e

------------------------------------------------------------------------------
-- INTERNAL CONSTANTS
------------------------------------------------------------------------------

constant CLASS_NAME   =1, CLASS_PROPERTY=2,   CLASS_METHOD=3
constant PROPERTY_NAME=1, PROPERTY_VALUE=2
constant METHOD_NAME  =1, METHOD_ROUTINE_ID=2
constant ENTITY_ID    =1, ENTITY_CLASS  =2,   ENTITY_VALUES=3

------------------------------------------------------------------------------
-- GLOBAL CONSTANTS
------------------------------------------------------------------------------


------------------------------------------------------------------------------
-- INTERNAL VARIABLES
------------------------------------------------------------------------------

global sequence classes
classes = {}

integer lastID
lastID = 0

global sequence entities
entities = {}

------------------------------------------------------------------------------
-- INTERNAL FUNCTIONS
------------------------------------------------------------------------------

global procedure analyzeProperty(object x, sequence Name, integer Output)
  analyzeSequence(x, Name, Output, {
    {{'?'}, {"PROPERTY_NAME","PROPERTY_VALUE"}}
  })
end procedure

------------------------------------------------------------------------------

global procedure analyzeMethod(object x, sequence Name, integer Output)
  analyzeSequence(x, Name, Output, {
    {{'?'}, {"METHOD_NAME","METHOD_ROUTINE_ID"}}
  })
end procedure

------------------------------------------------------------------------------

global procedure analyzeClass(object x, sequence Name, integer Output)
  analyzeSequence(x, Name, Output, {
    {{'?'}, {"CLASS_NAME","CLASS_PROPERTY","CLASS_METHOD"}},
    {{'?',CLASS_PROPERTY,'?'}, {"PROPERTY_NAME","PROPERTY_VALUE"}},
    {{'?',CLASS_METHOD,'?'}, {"METHOD_NAME","METHOD_ROUTINE_ID"}}
  })
end procedure

------------------------------------------------------------------------------
-- GLOBAL CLASS FUNCTIONS
------------------------------------------------------------------------------

-- define a ClassName
-- given the ClassName Name returns the ClassName ID
global function defineClass(sequence className)
  classes = append(classes, {className, {}, {}})
  if with_debug then
    printf(f_debug, "%d = defineClass(\"%s\")\n", {length(classes), className})
  end if
  return length(classes)
end function

------------------------------------------------------------------------------

-- define a ClassName property
global function defineClassProperty(integer classID, sequence propertyName, object defaultValue)
  if classID > 0 then
    classes[classID][CLASS_PROPERTY] = append(classes[classID][CLASS_PROPERTY], {propertyName, defaultValue})
  else
    warnError(sprintf("defineClassProperty(%d, \"%s\", %s): no ClassName parameter\n",
                      {classID, propertyName, object2string(defaultValue)}), 1)
  end if
  if with_debug then
    printf(f_debug, "defineClassProperty(%d, \"%s\", %s)\n",
                      {classID, propertyName, object2string(defaultValue)})
  end if
  return length(classes[classID][CLASS_PROPERTY])
end function

------------------------------------------------------------------------------

-- define a ClassName method
global function defineClassMethod(integer classID, sequence methodName, integer routineId)
  if classID > 0 then
    classes[classID][CLASS_METHOD] = append(classes[classID][CLASS_METHOD], {methodName, routineId})
  else
    warnError(sprintf("defineClassMethod(%d, \"%s\", %d): no ClassName parameter\n",
                      {classID, methodName, routineId}), 1)
  end if
  if with_debug then
    printf(f_debug, "defineClassMethod(%d, \"%s\", %d)\n",
                      {classID, methodName, routineId})
  end if
  return length(classes[classID][CLASS_METHOD])
end function

------------------------------------------------------------------------------

-- get the class name of a class ID
global function getClassName(integer classID)
  return classes[classID][CLASS_NAME]
end function

------------------------------------------------------------------------------

-- get a method routine_id
global function getMethodName(integer classID, integer methodID)
  return classes[classID][CLASS_METHOD][methodID][METHOD_NAME]
end function

------------------------------------------------------------------------------

-- get a method routine_id
global function getMethodRoutineId(integer classID, integer methodID)
  return classes[classID][CLASS_METHOD][methodID][METHOD_ROUTINE_ID]
end function

------------------------------------------------------------------------------
-- GLOBAL ENTITY FUNCTIONS
------------------------------------------------------------------------------

global procedure analyzeEntity(object x, sequence Name, integer Output)
  analyzeSequence(x, Name, Output, {
    {{'?'}, {"ENTITY_ID","ENTITY_CLASS","ENTITY_VALUES"}},
    {{'?',ENTITY_VALUES,'?'}, {"PROPERTY_NAME","PROPERTY_VALUE"}}
  })
end procedure

------------------------------------------------------------------------------

-- create an Entity of the class ClassName
global function createEntity(integer classID)
  lastID += 1
  entities = append(entities, {lastID, classID,
                               classes[classID][CLASS_PROPERTY]})
  return lastID
end function

------------------------------------------------------------------------------

-- find entities ID matching class classID
global function findEntitiesOfClass(integer classID)
  return commonField(entities, ENTITY_CLASS, classID)
end function

------------------------------------------------------------------------------

-- remove an Entity
global procedure removeEntity(integer entityID)
  entities[entityID] = {0, 0, {}}
end procedure

------------------------------------------------------------------------------

-- get entity class ID
global function getEntityClassID(integer entityID)
  return entities[entityID][ENTITY_CLASS]
end function

------------------------------------------------------------------------------

-- set a property
global procedure setEntityProperty(integer entityID, integer propertyID, object propertyValue)
  integer entityClassID
  sequence entityClassName, propertyName

  if with_debug then
    puts(f_debug, "------------------------------------------------------\n")
    propertyName = entities[entityID][ENTITY_VALUES][propertyID][PROPERTY_NAME]
    printf(f_debug, "setEntityProperty(%d, %d (%s), %s)\n",
                    {entityID, propertyID, propertyName, object2string(propertyValue)})
  end if
  entityClassID = getEntityClassID(entityID)
  if entityClassID > 0 then
    entityClassName = getClassName(entityClassID)
  else -- entity always needs a class
    analyzeClass(classes, "classes", f_debug)
    warnError(sprintf("setEntityProperty(%d, %d (%s), %s): class not found",
              {entityID, propertyID, propertyName, object2string(propertyValue)}), 1)
  end if
  entities[entityID][ENTITY_VALUES][propertyID][PROPERTY_VALUE] = propertyValue
  if with_debug then
    printf(f_debug, "setEntityProperty(%d (%s), %d (%s), %s)\n",
                    {entityID, entityClassName, propertyID, propertyName, object2string(propertyValue)})
    puts(f_debug, "------------------------------------------------------\n")
  end if
end procedure

------------------------------------------------------------------------------

-- get a property
global function getEntityProperty(integer entityID, integer propertyID)
  integer entityClassID
  sequence entityClassName, propertyName
  object propertyValue

  if with_debug then
    puts(f_debug, "------------------------------------------------------\n")
    propertyName = entities[entityID][ENTITY_VALUES][propertyID][PROPERTY_NAME]
    printf(f_debug, "getEntityProperty(%d, %d (%s))\n",
                    {entityID, propertyID, propertyName})
  end if
  entityClassID = getEntityClassID(entityID)
  if entityClassID > 0 then
    entityClassName = getClassName(entityClassID)
  else -- entity always needs a class
    analyzeClass(classes, "classes", f_debug)
    warnError(sprintf("getEntityProperty(%d, %d (%s)): class not found",
              {entityID, propertyID, propertyName}), 1)
  end if
  propertyValue = entities[entityID][ENTITY_VALUES][propertyID][PROPERTY_VALUE]
  if with_debug then
    printf(f_debug, "%s = getEntityProperty(%d (%s), %d (%s))\n",
                    {object2string(propertyValue), entityID, entityClassName, propertyID, propertyName})
    puts(f_debug, "------------------------------------------------------\n")
  end if
  return propertyValue
end function

------------------------------------------------------------------------------

-- call a method (function) within an Entity
global function callEntityMethod(integer senderID, integer entityID, integer methodID, object methodParams)
  integer  entityClassID, senderClassID, routineID
  sequence entityClassName, senderClassName, methodName
  object result

  if with_debug then
    puts(f_debug, "------------------------------------------------------\n")
    printf(f_debug, "callEntityMethod(%d, %d, %d, %s)\n",
             {senderID, entityID, methodID, object2string(methodParams)})
  end if
  entityClassID = getEntityClassID(entityID)
  if entityClassID > 0 then
    entityClassName = getClassName(entityClassID)
  else -- entity always needs a class
    analyzeClass(classes, "classes", f_debug)
    warnError(sprintf("callEntityMethod(%d, %d, %d, %s): class not found",
              {senderID, entityID, methodID, object2string(methodParams)}), 1)
  end if
  if senderID > 0 then
    senderClassID = getEntityClassID(senderID)
    if senderClassID > 0 then
      senderClassName = getClassName(senderClassID)
    else  -- sender may not be an entity, so it may not have a class
      senderClassName = "?"
    end if
  else  -- sender may not be an entity, so it may not have a class
    senderClassName = "?"
  end if
  routineID  = getMethodRoutineId(entityClassID, methodID)
  methodName = getMethodName(entityClassID, methodID)
  result = call_func(routineID, {senderID, entityID, methodParams})
  if with_debug then
    if atom(result) and (result = 0) then
      printf(f_debug, "void = callEntityMethod(%d (%s), %d (%s), %d (%s), %s)\n",
             {senderID, senderClassName, entityID, entityClassName, methodID,
              methodName, object2string(methodParams)})
    else
      printf(f_debug, "%s = callEntityMethod(%d (%s), %d (%s), %d (%s), %s)\n",
             {object2string(result), senderID, senderClassName, entityID, entityClassName,
              methodID, methodName, object2string(methodParams)})
    end if
    puts(f_debug, "------------------------------------------------------\n")
  end if
  return result
end function

------------------------------------------------------------------------------

global function findComponentEntity(integer componentID)
  integer entityID
  
  if with_debug then
    puts(f_debug, "------------------------------------------------------\n")
    printf(f_debug, "findComponentEntity(%d)\n", {componentID})
  end if
  entityID = 0
  for i = 1 to length(entities) do
    if compare(entities[i][ENTITY_VALUES][1], componentID) = 0 then
      entityID = entities[i][ENTITY_ID]
      exit
    end if
  end for
  if with_debug then
    printf(f_debug, "%d = findComponentEntity(%d)\n", {entityID, componentID})
    puts(f_debug, "------------------------------------------------------\n")
  end if
  return entityID
end function

