-- Extended Key Handling Routines v2.2
-- David Cuny 11/22/97
-- Internet:  dcuny@hw1.cahwnet.gov
--
-- Bit optimization suggested by Robert Craig
-- Alt+Gr key support 

include machine.e       -- int_to_bits()
include graphics.e      -- cursor()
        
without warning

-- display clock on the screen
global integer editorClockId
    editorClockId = -1

-- allow/disallow type ahead
constant    TYPE_AHEAD = 1

-- vga graphics flag
global integer VGA_MODE
    VGA_MODE = 0

-- cursor position
sequence cursorPosition
    cursorPosition = get_position()

global integer
    KEY_CODE,                   -- key read from keyboard
    SCAN_CODE                   -- scan code of key read

constant
    KEY_BUFFER      = 1054,     -- keyboard buffer; circular queue
    FIRST_INDEX     = 1050,     -- index to first key in buffer
    LAST_INDEX      = 1052      -- index to last key in buffer

constant
    SHIFT_FLAG1_BIT     = 1,    -- status byte for these are at #417
    SHIFT_FLAG2_BIT     = 2,    -- both left and right shifts are tracked
    CTRL_FLAG_BIT       = 3,    -- at #417
    ALT_FLAG_BIT        = 4     -- at #417
--  LEFT_CTRL_FLAG_BIT  = 1,    -- at #418
--  LEFT_ALT_FLAG_BIT   = 2     -- at #418

-- key definitions

global constant    
                
    BACKSPACE = 8, TAB = 9, ENTER = 13, ESC = 27,
--    BACKSPACE = 8, TAB = 9, ENTER = 284, ESC = 27,
    SHIFT_TAB = 271,

    ALT_A = 286, ALT_B = 304, ALT_C = 302,
    ALT_D = 288, ALT_E = 274, ALT_F = 289,
    ALT_G = 290, ALT_H = 291, ALT_I = 279,
    ALT_J = 292, ALT_K = 293, ALT_L = 294,
    ALT_M = 306, ALT_N = 305, ALT_O = 280,
    ALT_P = 281, ALT_Q = 272, ALT_R = 275,
    ALT_S = 287, ALT_T = 276, ALT_U = 278,
    ALT_V = 303, ALT_W = 273, ALT_X = 301,
    ALT_Y = 277, ALT_Z = 300, ALT_1 = 376,
    ALT_2 = 377, ALT_3 = 378, ALT_4 = 379,
    ALT_5 = 380, ALT_6 = 381, ALT_7 = 382,
    ALT_8 = 383, ALT_9 = 384, ALT_0 = 385,

    CTRL_A = 01, CTRL_B = 02, CTRL_C = 03,
    CTRL_D = 04, CTRL_E = 05, CTRL_F = 06,
    CTRL_G = 07, CTRL_H = 08, CTRL_I = 09,
    CTRL_J = 10, CTRL_K = 11, CTRL_L = 12,
    CTRL_M = 13, CTRL_N = 14, CTRL_O = 15,
    CTRL_P = 16, CTRL_Q = 17, CTRL_R = 18,        
    CTRL_S = 19, CTRL_T = 20, CTRL_U = 21,
    CTRL_V = 22, CTRL_W = 23, CTRL_X = 24,
    CTRL_Y = 25, CTRL_Z = 26, 

    F1 = 315, F2 = 316, F3 = 317, F4 = 318, F5 = 319,    
    F6 = 320, F7 = 321, F8 = 322, F9 = 323, F10 = 324,
--    F11 = 389, F12 = 390,
    F11 = 343, F12 = 344,

    HOME = 327, UP = 328, PAGE_UP = 329, LEFT = 331,
    RIGHT = 333, END = 335, DOWN = 336, 
    PAGE_DOWN = 337, INSERT = 338, DELETE = 339, 

    CTRL_LEFT = 371, CTRL_RIGHT = 372, CTRL_END = 373,
    CTRL_HOME = 375, CTRL_PAGE_UP = 388, CTRL_PAGE_DOWN = 374,
    CTRL_UP = 397, CTRL_DOWN = 401, CTRL_INSERT = 402,
    CTRL_TAB = 404, CTRL_ENTER = 10,

    ALT_TAB = 421,

    ALT_PRESSED = 600, ALT_RELEASED = 601,
    SHIFT_PRESSED = 603, SHIFT_RELEASED = 604

-- key state stuff

-- edit mode
global integer editMode
global constant
    INSERT_MODE = 0,
    OVERWRITE_MODE = 1

-- default mode
    editMode = INSERT_MODE


-- clipboard
global sequence clipboard
    clipboard = ""

-- last key pressed
global integer last_key_pressed


----------------------------------------------------------------------------
global function alt_key_state()
        
    -- look for alt key flag (4th bit in peek 477H)

    sequence altFlag

    -- check if either alt key is pressed
    altFlag = int_to_bits( peek( #417 ), ALT_FLAG_BIT )
    return altFlag[ALT_FLAG_BIT]

end function


----------------------------------------------------------------------------
global function ctrl_key_state()
        
    -- look for alt key flag (3rd bit in peek 477H)

    sequence ctrlFlag

    -- check if either alt key is pressed
    ctrlFlag = int_to_bits( peek( #417 ), CTRL_FLAG_BIT )
    return ctrlFlag[CTRL_FLAG_BIT]

end function


----------------------------------------------------------------------------
global function shift_key_state()
        
    -- look for shift key flag (1st or 2nd bit in peek 477H)

    sequence shiftFlag
    
    shiftFlag = int_to_bits( peek( #417 ), 4 )
    return ( shiftFlag[SHIFT_FLAG1_BIT] or shiftFlag[SHIFT_FLAG2_BIT] )

end function


----------------------------------------------------------------------------
global function natural_key( integer k )
        
        -- key pressed is not a command key (32-126)

        return ( k > 31 and k < 256 )

end function



----------------------------------------------------------------------------
global function get_safe_key()

    -- return key currently being pressed
    -- or zero if no event

    object priorTime
    integer priorRow, priorCol, key_code

    -- buffer is empty is indexes point to each other
    if peek( FIRST_INDEX ) = peek( LAST_INDEX ) then
        -- nothing in the buffer
        return 0
    end if
    
    -- get the key code and the alt key code
    SCAN_CODE = peek( KEY_BUFFER + peek( FIRST_INDEX ) - 29 )
    KEY_CODE = peek( KEY_BUFFER + peek( FIRST_INDEX ) - 30 )
    
    -- look for control-c
    if SCAN_CODE = 46 and KEY_CODE = 3 then
        -- clear the buffer
        poke( FIRST_INDEX, peek( LAST_INDEX ) )
                            
        -- return a control C
        return CTRL_C
    else
    
        -- read through the normal process
    
        if TYPE_AHEAD then
    
            return get_key()
    
        else
    
            -- get the key
            key_code = get_key()
    
            -- clear the buffer
            poke( FIRST_INDEX, peek( LAST_INDEX ) )
    
            -- return the key
            return key_code
    
        end if
    
    end if

end function


constant Null = {}
----------------------------------------------------------------------------
global function watch_keys()
        
    -- return an event - key press or mouse
        
    integer keyPress
    integer oldShiftState, oldAltState
    integer newShiftState, newAltState

    -- get initial states       
    oldShiftState = shift_key_state()
    oldAltState = alt_key_state()

    -- clear scan and key codes
    SCAN_CODE = 0
    KEY_CODE = 0

    keyPress = 0
    while keyPress = 0 do

        -- run the clock, if defined
        if editorClockId > -1 then
            call_proc( editorClockId, Null )
        end if

        -- look for a key
        keyPress = get_safe_key()
                    
        -- toggle insert/delete mode on Insert        
            if keyPress = INSERT                -- insert pressed
            and not( shift_key_state() )        -- not Shift+Insert
            and not( alt_key_state() )          -- not Alt+Insert
            and not( ctrl_key_state() ) then    -- not Ctrl+Insert
                if editMode = INSERT_MODE then
                    editMode = OVERWRITE_MODE
                else
                    editMode = INSERT_MODE
                end if
            end if

        -- current shift state        
        newShiftState = shift_key_state()
        newAltState = alt_key_state()

        -- return new states
        if  oldAltState != newAltState then
            if newAltState then
                return ALT_PRESSED
            else
                return ALT_RELEASED
            end if
        end if

        if  oldShiftState != newShiftState then
            if newShiftState then
                return SHIFT_PRESSED
            else
                return SHIFT_RELEASED
            end if
        end if

    end while

    return keyPress

end function

----------------------------------------------------------------------------
global function edit_mode()
        return editMode
end function

----------------------------------------------------------------------------
global procedure show_cursor()

    if editMode = INSERT_MODE then
        cursor( UNDERLINE_CURSOR )
    else
        cursor( BLOCK_CURSOR )
    end if

end procedure


----------------------------------------------------------------------------
global procedure hide_cursor()
    cursor( NO_CURSOR )
end procedure



-- Revision History
-- v2.6     08-01-97: added and_bits() to mouse event testing
--
-- v2.5     05-29-97: Added ctrl_key_state.
--                    Ctrl+Ins in editor.
--                    Added check to Insert key so Alt+Insert, Shift+Insert
--                    and Ctrl+Insert do not toggle insert state.
--                    Added constant CTRL_INSERT.
--
-- v2.4     04-11-97: Made SCAN_CODE and KEY_CODE global variables
--                    Removed Alt_Gr; now handled in editor.
--                    Removed graphic mode aware cursor code
--
-- v2.3     03-11-97: Type ahead is optional. On my 386, it's a nuisance.
--
-- v2.2     03-11-97: Added support for Alt_Gr key (foreign keyboards)
--
-- v2.1     02-10-97: Added mouse_released() to keep button state in sync.
--                    Thanks Jiri Babor! Taken from ratbag.e.
--
-- v2.0     02-07-97: Added mouse routines
--
-- v1.1     11-22-97: Corrected CRTL_0 value
--
-- v1.0     11-22-97: First release

