-- Date Calculations

-- Sep 1, 1996
-- written by Junko C. Miura, Rapid Deployment Software
-- Contributed to the Public Domain

-- Aug 5, 2010
-- converted by Jean-Marc Duro to a reusable unit

include common.e

-- declares
global constant WEEK = {"Samedi", "Dimanche", "Lundi", "Mardi", "Mercredi",
		 "Jeudi", "Vendredi"}
global constant MONTH = {"Janvier", "Fvrier", "Mars", "Avril", "Mai", "Juin",
         "Juillet", "Aot", "Septembre", "Octobre", "Novembre", "Dcembre"}

-- procedures and functions definition
function INT(atom x)
  if x >= 0 then
    return floor(x)
  else
    return -1 * floor(-x)
  end if
end function

global function getFactor(integer yyyy, integer mm, integer dd)
  integer factor
     
  if yyyy <= 1582 then
	warnError("year must be >1582", 0)
  end if
  if mm < 1 or mm > 12 then
	warnError("month must be >0 and <=12", 0)
  end if
  if mm < 1 or mm > 31 then
	warnError("day must be >0 and <=31", 0)
  end if
  if mm > 2 then
    factor = 365 * yyyy + dd + 31 * (mm - 1) - INT(0.4 * mm + 2.3)
		 + INT(yyyy / 4) - INT(0.75 * (INT(yyyy / 100) + 1))
  else
	factor = 365 * yyyy + dd + 31 * (mm - 1) + INT((yyyy - 1) / 4)
		 - INT(0.75 * (INT(((yyyy - 1) / 100) + 1)))
  end if
  return factor
end function

global function dayOfWeek(integer yyyy, integer mm, integer dd)
  integer factor, dayOfWeek
    
  factor = getFactor(yyyy, mm, dd)
  dayOfWeek = factor + (INT(-factor / 7) * 7)
  if dayOfWeek > 6 then              -- start of DEBUG
	warnError(sprintf("WARNING-- dayOfWeek : %d\n", dayOfWeek), 0)
	dayOfWeek = remainder(dayOfWeek, 7) 
  end if                             -- end of DEBUG
  return dayOfWeek + 1
end function

global function getDaysBetwDates(sequence date1, sequence date2)
  integer factor1, factor2, numDays
    
  factor1 = getFactor(date1[1],date1[2],date1[3])
  factor2 = getFactor(date2[1],date2[2],date2[3])
  if factor2 > factor1 then
    numDays = factor2 - factor1
  else
    numDays = factor1 - factor2
  end if
  return numDays
end function

