-- bindres.ex  v.1.0a
-- bind resource file to an executable
--
-- (c) david cuny
-- e-mail: dcuny@lanset.com

--
-- input:   <file>[.exe]
-- output:  <file>[.exe]
--
-- the resource file <file>.res must be built first!


include wildcard.e
include file.e

-----------------------------------------------------------------------------
function getInFileName()
    -- get the file name from the command line
    -- if none is found, ask the user for it
    
    sequence args, fName

    -- clear fName
    fName = ""

    -- get the command line
    args = command_line()
    if length( args ) > 2 then
        fName = args[3]
    end if

    -- not in command line?
    if length( fName ) = 0 then
        -- get prompt from user
        puts( 1, "File to link? " )
        fName = gets(0)
        puts( 1, "\n" )
        
        -- remove line feed
        fName = fName[1..length(fName)-1]
        
        -- empty?
        if length( fName ) = 0 then
            abort(0)
        end if   
        
    end if

    -- not an exe?
    if not match( ".exe", lower(fName) ) then
        -- they forgot the .EXE
        fName = fName & ".EXE"
    end if
    
    return fName
             
end function            


-----------------------------------------------------------------------------
function getResFileName( sequence s )
    
    -- convert the input file name into an output file name
    integer at
    
    -- outfile
    at = find( '.', s)
    if at = 0 then
        puts( 1, "Please include an extention in the file name.\n" )
        abort(0)
    end if      

    -- replace with "res"
    return s[1..at] & "RES"
    
end function


-----------------------------------------------------------------------------
function getFileSize( sequence fName )
    -- return length of a file
    object list
    
    -- get file information
    list = dir( fName )
    
    -- doesn't exist
    if compare( list, -1 ) = 0 then
        return 0
    end if
    
    -- return length
    return list[1][D_SIZE]

end function


integer
    exeSize,
    resSize,
    readHandle,
    writeHandle
    
sequence
    exeName,
    resName

constant
    EOF_CODE   = "abort(0)\n"  -- place on end of code

-- get the input file name and size
exeName = getInFileName()  
exeSize = getFileSize( exeName )
if exeSize = 0 then
    printf( 1, "Executable file %s not found.\n", {exeName} )
    abort(0)    
end if

-- get the res file name and size
resName = getResFileName( exeName )
resSize = getFileSize( resName )
if resSize = 0 then
    printf( 1, "Resource file %s not found.\n", {resName} )
    abort(0)    
end if

-- open resource to read
readHandle = open( resName, "rb" ) 
if readHandle = -1 then
    puts( 1, "Unable to open resource file.\n" )
    abort(0)        
end if          

-- open exe to append
writeHandle = open( exeName, "ab" )
if writeHandle = -1 then
    puts( 1, "Unable to open .EXE file.\n" )
    abort(0)        
end if

-- place an "abort(0)" at the end of the code
-- prevents Euphoria from executing data
puts( writeHandle, EOF_CODE )

-- add to code size
exeSize = exeSize + length(EOF_CODE)

-- append the data
for i = 1 to resSize do
    puts( writeHandle, getc( readHandle ) )
end for

-- add tag
printf( writeHandle, "\n%d\nRES", {exeSize} )

-- close the files
close( readHandle )
close( writeHandle )

puts( 1, "Finished!" )

