--This include file is for reading and writing game and character files

include get.e
include acLib.e

--Format for .dng (game) files
--gameName
--includeFile
--places
--startPlace
--startHealth
--startMoney
--objectTypes
--commands
--exitCommandNo
--helpCommandNo
--lookCommandNo
--examineCommandNo
--getCommandNo
--dropCommandNo
--statsCommandNo
--useCommandNo
--chatCommandNo
--addressCommandNo
--attackCommandNo
--buyCommandNo
--sellCommandNo
--buildCommandNo
--addCommandNo
--moneyCommandNo
--helpText
--endMessage
--backgroundImage

--places = repeat(place, *)
--place = {name, description, moves, objects, shopOwner, shopItems, pictureName, shopMoney}
--name = "string"
--description = "string"
--moves = repeat(move, *)
--move = {commandNo, newPlace, entryRequirement, erParam}
--values for entryRequirement:
-- 0: no entry requirement
-- 1: password (erParam is the password)
-- 2: key (erParam is the objectTypeNo of the key object)
--objects = repeat(object, *)
--object = {objectNo, quantity}
--values for shop owner:
-- 0: no shop
-- 1: built-in shop (owned by computer)
-- 2: no shop, but one can be built by a player
--"string": shop, owned by the player with this name
--shopItems = repeat(shopItem, *)
--shopItem = {objectNo, price, quantity}
--values for quantity:
-- -1: infinite
-- 0: none
-- <positive number>: that number of items available
--pictureName = "filename.bmp"

--objectTypes = repeat(objectType, *)
--objectType = {nameSingular, namePlural, description, singleUse, actionType, actionArgs}
--nameSingular = "string"
--namePlural = "string"
--description = "string"

--possible values for actionType:
-- 0: no action
-- 1: get more health (argument is how much more)
-- 2: get more money (this happens when you pick it up, not when you use it) (the argument is the amount)
-- 3: weapon (the argument is the strength)
-- 4: shield (the argument is the strength)
-- 5: book (the argument is the text)

--commands = repeat(command, *)
--command = repeat(syntax, *)
--syntax = "string"

--helpText = "string"

--backgroundImage = "filename"

--Format for .dch (character) files
--gFile
--name
--inventory
--currentPlace
--health
--money
--weapon
--shield

--gFile = "string"

--name = "string"

--inventory = repeat(object, *)
--object = {objectTypeNo, quantity}

--Game properties
global integer startPlace, exitCommandNo, helpCommandNo, lookCommandNo, examineCommandNo, getCommandNo, dropCommandNo, statsCommandNo, useCommandNo, chatCommandNo, addressCommandNo,
                attackCommandNo, buyCommandNo, sellCommandNo, buildCommandNo, addCommandNo, moneyCommandNo
global atom startHealth, startMoney
global sequence includeFile, places, objectTypes, commands, helpText, gameName, endMessage, backgroundImage

--Initialize variable
includeFile = ""

--Player stats
global integer currentPlace, weapon, shield
global atom health, money
global sequence name, inventory

global procedure loadGame(sequence filename)
          integer fn
          sequence temp

          --Open the file for reading
          fn = open(filename, "r")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error opening " & filename & "\n")
             --Abort the program
             abort(1)
          end if

          --Read the gameName from the file
          temp = gets(fn)
          --Check for newline character
          if temp[length(temp)] = '\n' then
             --Remove the newline character
             gameName = temp[1..length(temp) - 1]
          else
             gameName = temp
          end if

          --Read the includeFile from the file
          temp = gets(fn)
          --Check for newline character
          if temp[length(temp)] = '\n' then
             --Remove the newline character
             includeFile = temp[1..length(temp) - 1]
          else
             includeFile = temp
          end if

          --Read the places from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in places
          places = temp[2]

          --Read the startPlace from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in startPlace
          startPlace = temp[2]

          --Read the startHealth from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not atom(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in startHealth
          startHealth = temp[2]

          --Read the startMoney from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not atom(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in startMoney
          startMoney = temp[2]

          --Read the objectTypes from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in objectTypes
          objectTypes = temp[2]

          --Read the commands from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in commands
          commands = temp[2]

          --Read the exitCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in exitCommandNo
          exitCommandNo = temp[2]

          --Read the helpCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in helpCommandNo
          helpCommandNo = temp[2]

          --Read the lookCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in lookCommandNo
          lookCommandNo = temp[2]

          --Read the examineCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in examineCommandNo
          examineCommandNo = temp[2]

          --Read the getCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in getCommandNo
          getCommandNo = temp[2]

          --Read the dropCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in dropCommandNo
          dropCommandNo = temp[2]

          --Read the statsCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in statsCommandNo
          statsCommandNo = temp[2]

          --Read the useCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in useCommandNo
          useCommandNo = temp[2]

          --Read the chatCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in chatCommandNo
          chatCommandNo = temp[2]

          --Read the addressCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in addressCommandNo
          addressCommandNo = temp[2]

          --Read the attackCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in attackCommandNo
          attackCommandNo = temp[2]

          --Read the buyCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in buyCommandNo
          buyCommandNo = temp[2]

          --Read the sellCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in sellCommandNo
          sellCommandNo = temp[2]

          --Read the buildCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in buildCommandNo
          buildCommandNo = temp[2]

          --Read the addCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in addCommandNo
          addCommandNo = temp[2]

          --Read the moneyCommandNo from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in moneyCommandNo
          moneyCommandNo = temp[2]

          --Read the helpText from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in helpText
          helpText = temp[2]

          --Read the endMessage from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in endMessage
          endMessage = temp[2]

          --Read the backgroundImage from the file
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & filename & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in backgroundImage
          backgroundImage = temp[2]

          --Close the file
          close(fn)

          --Check for an include file
          if length(includeFile) > 0 then
             --Open temp.e for write
             fn = open("temp.e", "w")
             --Check for error
             if fn = -1 then
                --Give an error message
                puts(2, "Error opening temp.e\n")
                --Abort the program
                abort(1)
             end if

             --Write the include statement and file
             puts(fn, "include " & includeFile & "\n")

             --Close the file
             close(fn)
          end if

          --Include the file
          --include temp.e
end procedure

global procedure saveGame(sequence filename)
          integer fn

          --Open the file for writing
          fn = open(filename, "w")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error opening " & filename & "\n")
             --Abort the program
             abort(1)
          end if

          --Write gameName
          puts(fn, gameName & "\n")
          --Write includeFile
          puts(fn, includeFile & "\n")
          --Write places
          print(fn, places)
          nl(fn)
          --Write startPlace
          print(fn, startPlace)
          nl(fn)
          --Write startHealth
          print(fn, startHealth)
          nl(fn)
          --Write startMoney
          print(fn, startMoney)
          nl(fn)
          --Write objectTypes
          print(fn, objectTypes)
          nl(fn)
          --Write commands
          print(fn, commands)
          nl(fn)
          --Write exitCommandNo
          print(fn, exitCommandNo)
          nl(fn)
          --Write helpCommandNo
          print(fn, helpCommandNo)
          nl(fn)
          --Write lookCommandNo
          print(fn, lookCommandNo)
          nl(fn)
          --Write examineCommandNo
          print(fn, examineCommandNo)
          nl(fn)
          --Write getCommandNo
          print(fn, getCommandNo)
          nl(fn)
          --Write dropCommandNo
          print(fn, dropCommandNo)
          nl(fn)
          --Write statsCommandNo
          print(fn, statsCommandNo)
          nl(fn)
          --Write useCommandNo
          print(fn, useCommandNo)
          nl(fn)
          --Write chatCommandNo
          print(fn, chatCommandNo)
          nl(fn)
          --Write addressCommandNo
          print(fn, addressCommandNo)
          nl(fn)
          --Write attackCommandNo
          print(fn, attackCommandNo)
          nl(fn)
          --Write buyCommandNo
          print(fn, buyCommandNo)
          nl(fn)
          --Write sellCommandNo
          print(fn, sellCommandNo)
          nl(fn)
          --Write buildCommandNo
          print(fn, buildCommandNo)
          nl(fn)
          --Write addCommandNo
          print(fn, addCommandNo)
          nl(fn)
          --Write moneyCommandNo
          print(fn, moneyCommandNo)
          nl(fn)
          --Write helpText
          print(fn, helpText)
          nl(fn)
          --Write endMessage
          print(fn, endMessage)
          nl(fn)
          --Write backgroundImage
          print(fn, backgroundImage)
          nl(fn)

          --Close the file
          close(fn)
end procedure

global function loadCharacter(sequence cFile)
         integer fn
         sequence temp, gFile

          --Open the file for reading
          fn = open(cFile, "r")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error opening " & cFile & "\n")
             --Abort the program
             abort(1)
          end if

          --Read the filename of the game
          gFile = gets(fn)
          --Check for newline character
          if gFile[length(gFile)] = '\n' then
             --Remove the newline character
             gFile = gFile[1..length(gFile) - 1]
          end if

          --Read the character name
          name = gets(fn)
          --Check for newline character
          if name[length(name)] = '\n' then
             --Remove the newline character
             name = name[1..length(name) - 1]
          end if

          --Read the inventory
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & cFile & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in inventory
          inventory = temp[2]

          --Read the current place
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & cFile & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in currentPlace
          currentPlace = temp[2]

          --Read the health
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not atom(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & cFile & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in health
          health = temp[2]

          --Read the money
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not atom(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & cFile & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in money
          money = temp[2]

          --Read the weapon numper
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & cFile & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in weapon
          weapon = temp[2]

          --Read the shield number
          temp = get(fn)
          --Check for error
          if temp[1] != GET_SUCCESS or not integer(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " reading from " & cFile & "\n")
             --Abort the program
             abort(1)
          end if
          --Get rid of the error code, and put the value in shield
          shield = temp[2]

          --Close the file
          close(fn)

          --Return the filename of the game
          return gFile
end function

global procedure saveCharacter(sequence gameFile)
          integer fn

          --Open the file for writing
          fn = open(name & ".dch", "w")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error opening " & name & ".dch\n")
             --Abort the program
             abort(1)
          end if

          --Write the filename of the game
          puts(fn, gameFile & "\n")
          --Write the character name
          puts(fn, name & "\n")
          --Write the inventory
          print(fn, inventory)
          nl(fn)
          --Write the current place
          print(fn, currentPlace)
          nl(fn)
          --Write the amount of health
          print(fn, health)
          nl(fn)
          --Write the amount of money
          print(fn, money)
          nl(fn)
          --Write the weapon number
          print(fn, weapon)
          nl(fn)
          --Write the shield number
          print(fn, shield)
          nl(fn)

          --Close the file
          close(fn)
end procedure

--Create a new character, with all default values
global procedure newCharacter()
             --Set the inventory to empty
             inventory = {}
             --Set the weapon and shield to 0 (none)
             weapon = 0
             shield = 0
end procedure
