with trace

include get.e
include misc.e
include wildcard.e
include file.e
include acLib.e
include readwritegc.e
include engine.e

--This is used as a callback procedure for the game engine
procedure gameMessage(sequence message)
          --Show it, along with a new line
          puts(1, message & "\n")
end procedure

--Play the game
procedure playDungeon()
          integer ret
          sequence command

          --Show the first place info
          showCurrentPlace()
          --Main loop
          while 1 do
                --Get their command
                command = prompt_string(": ")
                --Do the command
                ret = doCommand(command)
                --Check for quit
                if ret then
                   --Exit the loop
                   exit
                end if
          end while
end procedure

procedure start()
          integer pos
          sequence command, loadType, gFile, cFile

          --Set the callback procedure for a game message from the game engine
          setMessageCallback(routine_id("gameMessage"))

          --Get the command line
          command = command_line()
          --Check for arguments
          if length(command) > 3 then
             --Get the first argument, the type of file to load
             loadType = command[3]
          else
             --Set loadType to empty, meaning ask for all (nothing is given on the command line)
             loadType = ""
          end if

          --Check if the filename for the character is given on the command line
          if equal(loadType, "c") then
             --Get it
             cFile = command[4]
          else
             --Ask for it
             cFile = prompt_string("Please choose a name: ")
          end if
          name = cFile

          --Check for blank
          if length(cFile) < 1 then
             --Exit the procedure
             return
          end if

          --Check for any extension
          --Look for a dot
          pos = find('.', cFile)
          --If there isn't any extension...
          if pos < 1 then
             --Add the default extension, .dch
             cFile = cFile & ".dch"
          end if

          --Check if character already exists
          if sequence(dir(cFile)) then
             --Load the character
             gFile = loadCharacter(cFile)
          else
             --Create the character
             newCharacter()
             --Set currentPlace to 0 temporarily, once the game has been loaded this will be set to startPlace
             currentPlace = 0
             --Game filename unknown
             gFile = ""
          end if

          --Check if the game filename is already known from the character file
          if length(gFile) < 1 then
             --Check if the filename for the game is given on the command line
             if equal(loadType, "g") then
                --Get it
                gFile = command[4]
             else
                --Ask for the filename of the game
                gFile = prompt_string("Please enter the filename of the game to play, or Enter to exit: ")
             end if
          end if

          --Check for blank
          if length(gFile) < 1 then
             --Exit the procedure
             return
          end if

          --Check for any extension
          --Look for a dot
          pos = find('.', gFile)
          --If there isn't any extension...
          if pos < 1 then
             --Add the default extension, .dng
             gFile = gFile & ".dng"
          end if

          --Load the game
          loadGame(gFile)

          --Check if currentPlace has been set to 0
          if currentPlace = 0 then
             --Set it to startPlace
             currentPlace = startPlace
             --Set health to startHealth
             health = startHealth
             --Set money to startMoney
             money = startMoney
          end if

          --Run it
          playDungeon()

          --Save the game
          saveGame(gFile)
          --Check that they haven't died
          if health > 0 then
             --Save the player
             saveCharacter(gFile)
          end if
end procedure

start()
