include get.e
include acLib.e
include readwritegc.e

constant maxLength = 20

function getCommands(integer commandNo)
          sequence commandText

          commandText = ""

          --Go through commands for this command number
          for i = 1 to length(commands[commandNo]) do
              --Add this command
              commandText &= commands[commandNo][i] & " / "
          end for

          commandText = ' ' & commandText[1..length(commandText) - 3]

          --Add the appropriate number of tabs
          for i = 1 to floor((maxLength - length(commandText) - 1) / 8 + .5) + 1 do
              commandText &= "\t-"
          end for

          return commandText & ' '
end function

function writeCommand(integer commandNo, sequence text)
         --Check if there is a command
         if commandNo > 0 then
            return getCommands(commandNo) & text & '\n'
         end if

         --Return nothing
         return ""
end function

procedure main()
          integer fn
          sequence inFile, help

          --Prompt for the input file
          inFile = prompt_string("Please enter the name of the game to make help text for: ")
          --Check for empty
          if length(inFile) < 1 then
             --Exit the procedure
             return
          end if
          --Load it
          loadGame(inFile)

          --Set help to a title to start with
          help = "Commands:\n"

          --Add text for all the commands
          help &= writeCommand(exitCommandNo, "Exit the game")
          help &= writeCommand(helpCommandNo, "View help")
          help &= writeCommand(lookCommandNo, "Look around the place")
          help &= writeCommand(examineCommandNo, "Examine an object")
          help &= writeCommand(getCommandNo, "Pick up an object")
          help &= writeCommand(dropCommandNo, "Drop an object")
          help &= writeCommand(statsCommandNo, "Look at your stats")
          help &= writeCommand(useCommandNo, "Use an object")
          help &= writeCommand(chatCommandNo, "Chat to other players")
          help &= writeCommand(addressCommandNo, "Add the address of another player")
          help &= writeCommand(attackCommandNo, "Attack another player")
          help &= writeCommand(buyCommandNo, "Buy an object from a shop")
          help &= writeCommand(sellCommandNo, "Sell an object to a shop")
          help &= writeCommand(buildCommandNo, "Build a shop in the current place")
          help &= writeCommand(addCommandNo, "Add an item to a shop you own")

          --Show the help text
          puts(1, help)

          --Open help.txt for writing
          fn = open("help.txt", "w")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error writing to help.txt")
             --Abort the program
             abort(1)
          end if

          --Write the help text to the file as a Euphoria string
          writeString(fn, help)

          --Close the file
          close(fn)
end procedure

main()
