with trace
include wildcard.e

integer messageCallback, chatCallback, attackCallback, loadPlayerCallback, moveCallback, peopleCallback, html
global sequence noAttack
--Initialize variables
messageCallback = -1
chatCallback = -1
attackCallback = -1
loadPlayerCallback = -1
moveCallback = -1
peopleCallback = -1
html = 0
noAttack = {}

procedure rawMessage(sequence text)
          --Check that a callback has been set
          if messageCallback >= 0 then
             --Call it with the message
             call_proc(messageCallback, {text})
          end if
end procedure

procedure gameMessage(sequence text)
          --Check if html is on
          if html then
             --Give the message, along with a <br>
             rawMessage(text & "<br>")
          else
             --Give the message
             rawMessage(text)
          end if
end procedure

procedure callChat(sequence text)
          --Check that a callback has been set
          if chatCallback >= 0 then
             --Call it with the message
             call_proc(chatCallback, {text})
          end if
end procedure

function callAttack(sequence playerName, atom healthOff)
          --Check that a callback has been set
          if attackCallback >= 0 then
             --Call it with the message, and return the value it returns
             return call_func(attackCallback, {playerName, healthOff})
          end if

          --Return 0
          return 0
end function

function loadPlayer(sequence playerName)
         --Make playerName lower case
         playerName = lower(playerName)

         --Check if it is us
         if equal(playerName, lower(name)) then
            --Return 1, meaning loaded OK
            return 1
         end if

         --Check if a callback has been set
         if loadPlayerCallback >= 0 then
            --Return whatever it returns
            return call_func(loadPlayerCallback, {playerName})
         end if

         --Return 0, meaning not loaded
         return 0
end function

procedure callMove()
          --Check that a callback has been set
          if moveCallback >= 0 then
             --Call it
             call_proc(moveCallback, {})
          end if
end procedure

procedure showPeople()
          --Check that a callback has been set
          if peopleCallback >= 0 then
             --Show a heading
             --Check if html is on
             if html then
                rawMessage("<h3>People:</h3>")
             else
                rawMessage("People:")
             end if
             --Call it
             call_proc(peopleCallback, {})
          end if
end procedure

global procedure setMessageCallback(integer callback)
       --Set messageCallback to callback
       messageCallback = callback
end procedure

global procedure setChatCallback(integer callback)
       --Set chatCallback to callback
       chatCallback = callback
end procedure

global procedure setAttackCallback(integer callback)
       --Set attackCallback to callback
       attackCallback = callback
end procedure

global procedure setLoadPlayerCallback(integer callback)
       --Set loadPlayerCallback to callback
       loadPlayerCallback = callback
end procedure

global procedure setMoveCallback(integer callback)
       --Set moveCallback to callback
       moveCallback = callback
end procedure

global procedure setPeopleCallback(integer callback)
       --Set peopleCallback to callback
       peopleCallback = callback
end procedure

--Turn on html output
global procedure htmlOn()
       --Set the flag
       html = 1
end procedure

--Show the info for the current place
global procedure showCurrentPlace()
          gameMessage(places[currentPlace][2])
end procedure

--Get the number of the given command, and the argument
function getCommandNoArg(sequence command)
         integer pos

         --Trim off extra spaces
         command = trim(command)

         --Check for no command
         if length(command) < 1 then
            --Return number 0, meaning no command
            return {0, ""}
         end if

         --Go through all the commands
         for i = 1 to length(commands) do
             --Get the position of this command in this list of commands (if it is in it)
             --Set pos to 0 to start with
             pos = 0
             --Go through all the syntaxes of this command
             for s = 1 to length(commands[i]) do
                 --Check if the given command starts with this syntax of this command
                 if match(commands[i][s] & " ", command & " ") = 1 then
                    --Set pos
                    pos = s
                    --Exit the loop
                    exit
                 end if
             end for
             --Check if that is the command
             if pos then
                --Return the number of the command, and the trimmed argument
                return {i, trim(command[length(commands[i][pos]) + 1..length(command)])}
             end if
         end for

         --Return number -1, meaning command does not exist
         return {-1, ""}
end function

--Get the number of the object by the given name
function getObjectNo(sequence objectName)
         --Go through all the objectTypes
         for i = 1 to length(objectTypes) do
             --Check if this is the right object, either singular or plural
             if equal(objectName, objectTypes[i][1]) or equal(objectName, objectTypes[i][2]) then
                --Return the index of this object
                return i
             end if
         end for

         --It hasn't found the object, so return 0
         return 0
end function

function changeQuantity(sequence data, object ID, atom amount)
         --Check for zero amount
         if amount = 0 then
            --Return data unchanged
            return data
         end if

         --Go through each item of data
         for i = 1 to length(data) do
             --Check if this one has the right ID
             if equal(data[i][1], ID) then
                --Change by the amount specified
                data[i][2] += amount
                --Check for zero
                if data[i][2] = 0 then
                   --Remove that item
                   data = aremoveItem(data, i)
                end if
                --Return the new value of data
                return data
             end if
         end for

         --It hasn't found anything with that ID, so append it
         data = append(data, {ID, amount})
         --Return the new value of data
         return data
end function

function findID(sequence data, object ID)
         --Go through each item of data
         for i = 1 to length(data) do
             --Check if this one has the right ID
             if equal(data[i][1], ID) then
                --Return the index
                return i
             end if
         end for

         --Return 0, meaning not found
         return 0
end function

--Do a command
global function doCommand(sequence command)
          integer commandNo, movedFlag, objectTypeNo, objectNo, ourPlace, weaponType, shieldType, pos, numberFlag, quantity
          atom weaponStrength, shieldStrength, healthOff
          sequence argument, temp

          --Check for no health left
          if health <= 0 then
             --Tell them
             gameMessage("You have died.")
             --Return 1 for exit
             return 1
          end if

          --Make the command all lowercase
          command = lower(command)
          --Find the number of the command and the argument
          temp = getCommandNoArg(command)
          --Get the command number from the sequence
          commandNo = temp[1]
          --Get the argument from the sequence
          argument = temp[2]

          --Check the command
          if commandNo = 0 then --No command
             --Do nothing
          elsif commandNo < 0 then --Command does not exist
             --Tell them it's an invalid command
             gameMessage("Invalid command.")
          elsif commandNo = exitCommandNo then --Exit command
             --Show the ending message
             gameMessage(endMessage)
             --Return 1 for exit
             return 1
          elsif commandNo = helpCommandNo then --Help command
             --Show the help text
             gameMessage(helpText)
          elsif commandNo = lookCommandNo then --Look around the place command
             --Show the current place info
             showCurrentPlace()
             --Show objects
             for i = 1 to length(places[currentPlace][4]) do
                 if places[currentPlace][4][i][2] = 1 then --One of that object
                    gameMessage("There is one " & objectTypes[places[currentPlace][4][i][1]][1] & ".")
                 elsif places[currentPlace][4][i][2] > 1 then --More than one of that object
                    gameMessage("There are " & sprint(places[currentPlace][4][i][2]) & " " & objectTypes[places[currentPlace][4][i][1]][2] & ".")
                 end if
             end for
             --Check if there is a shop here
             if sequence(places[currentPlace][5]) or places[currentPlace][5] = 1 then
                --Check if the shop is owned by a player
                if sequence(places[currentPlace][5]) then
                   --Display the owner
                   gameMessage("Shop owner: " & places[currentPlace][5])

                   --Check if the shop is owned by this player
                   if equal(lower(places[currentPlace][5]), lower(name)) then
                      --Show the amount of money in the shop
                      gameMessage("Balance of money in shop: " & sprint(places[currentPlace][8]))
                   else
                      --Check if there is no money left
                      if places[currentPlace][8] <= 0 then
                         --Tell the player that the shop will not buy any objects
                         gameMessage("This shop will not buy any objects at the moment.")
                      end if
                   end if
                end if
                --Check if html is on
                if html then
                   --Display a heading
                   rawMessage("<b>Items for sale:</b><br>")
                   --Start the table
                   rawMessage("<table>")
                   rawMessage("<tr><b>")
                   rawMessage("<td>Quantity</td>")
                   rawMessage("<td>Name</td>")
                   rawMessage("<td>Price</td>")
                   rawMessage("</b></tr>")
                else
                   --Display a heading
                   rawMessage("Items for sale:")
                   rawMessage("Quantity\tName\t\tPrice")
                end if
                --Go through all shop items
                for i = 1 to length(places[currentPlace][6]) do
                    --Check if there are infinite of this item
                    if places[currentPlace][6][i][3] = -1 then
                       --Give <infinite>, name and price
                       --Check if html is on
                       if html then
                          rawMessage("</tr>")
                          rawMessage("<td>(infinite)</td>")
                          rawMessage("<td>" & objectTypes[places[currentPlace][6][i][1]][1] & "</td>")
                          rawMessage("<td>" & sprint(places[currentPlace][6][i][2]) & "</td>")
                          rawMessage("</tr>")
                       else
                          rawMessage("<infinite>\t" & objectTypes[places[currentPlace][6][i][1]][1] & "\t\t" & sprint(places[currentPlace][6][i][2]))
                       end if
                    else
                       --Give the quantity, name and price
                       --Check if html is on
                       if html then
                          rawMessage("<tr>")
                          rawMessage("<td>" & sprint(places[currentPlace][6][i][3]) & "</td>")
                          rawMessage("<td>" & objectTypes[places[currentPlace][6][i][1]][1] & "</td>")
                          rawMessage("<td>" & sprint(places[currentPlace][6][i][2]) & "</td>")
                          rawMessage("<tr>")
                       else
                          rawMessage(sprint(places[currentPlace][6][i][3]) & "\t\t" & objectTypes[places[currentPlace][6][i][1]][1] & "\t\t" & sprint(places[currentPlace][6][i][2]))
                       end if
                    end if
                end for
                --Check if html is on
                if html then
                   --Finish off the table
                   rawMessage("</table>")
                end if
             elsif places[currentPlace][5] = 2 then --Shop can be built
                --Tell them
                gameMessage("A shop can be built here.")
             end if
             --Show people
             showPeople()
             --Show exits
             --Check if html is on
             if html then
                gameMessage("<b>Exits:</b>")
             else
                gameMessage("Exits:")
             end if
             for i = 1 to length(places[currentPlace][3]) do
                 gameMessage(commands[places[currentPlace][3][i][1]][1])
             end for
          elsif commandNo = examineCommandNo then --Examine command
             --Check if there is an argument
             if length(argument) < 1 then
                --Show the info for this place
                showCurrentPlace()
             else
                --Get the number of this type of object
                objectTypeNo = getObjectNo(argument)
                --Check for not found
                if objectTypeNo < 1 then
                   --Tell them
                   gameMessage("No such object as " & argument & ".")
                else
                   --Show the description for this object
                   gameMessage("You look at the " & objectTypes[objectTypeNo][1] & ". " & objectTypes[objectTypeNo][3])
                end if
             end if
          elsif commandNo = getCommandNo then --Get command (pick up an object)
             --Check for no argument
             if length(argument) < 1 then
                --Tell them
                gameMessage("You must specify what object to get.")
             else
                --Set quantity to 1 to start with
                quantity = 1
                --Get the position of the first space in the argument
                pos = find(' ', argument)
                --Check if one was found
                if pos > 1 then
                   --Set numberFlag to 1 to start with
                   numberFlag = 1
                   --Check if the bit before the space is all numeric
                   for i = 1 to pos - 1 do
                       --Check for a non-numeric character
                       if not find(argument[i], "1234567890") then
                          --Set numberFlag to 0
                          numberFlag = 0
                       end if
                   end for
                   --Check if it is a number
                   if numberFlag then
                      --Get the value
                      temp = value(argument[1..pos - 1])
                      --Check for error
                      if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                         --Give an error message
                         gameMessage("Error getting quantity.")
                      else
                         --Set quantity to the value
                         quantity = temp[2]
                         --Set argument to the (trimmed) bit after the space
                         argument = trim(argument[pos + 1..length(argument)])
                      end if
                   end if
                end if
                --Get the number of this type of object
                objectTypeNo = getObjectNo(argument)
                --Check for not found (no such object)
                if objectTypeNo < 1 then
                   --Tell them
                   gameMessage("No such object as " & argument & ".")
                else
                   --Find the position of this object type in this place
                   objectNo = findID(places[currentPlace][4], objectTypeNo)
                   --Check for none here
                   if objectNo < 1 then
                      --Tell them
                      gameMessage("There are no " & objectTypes[objectTypeNo][2] & " here.")
                   else
                      --Check if the number here is less than the quantity to be taken
                      if places[currentPlace][4][objectNo][2] < quantity then
                         --Set quantity to the number available
                         quantity = places[currentPlace][4][objectNo][2]
                      end if
                      --Take the quantity
                      --Make there be the quantity less in the place
                      places[currentPlace][4] = changeQuantity(places[currentPlace][4], objectTypeNo, -quantity)

                      --Check if it is type 2 (money)
                      if objectTypes[objectTypeNo][5] = 2 then
                         --Add the amount * the quantity to our money
                         money += objectTypes[objectTypeNo][6] * quantity
                      else
                         --Add the quantity of it to our inventory
                         inventory = changeQuantity(inventory, objectTypeNo, quantity)
                      end if

                      --Check if quantity is 1
                      if quantity = 1 then
                         --Tell them
                         gameMessage("You pick up a " & objectTypes[objectTypeNo][1] & ".")
                      else
                         --Tell them
                         gameMessage("You pick up " & sprint(quantity) & " " & objectTypes[objectTypeNo][2] & ".")
                      end if
                   end if
                end if
             end if
          elsif commandNo = dropCommandNo then --Drop object command
             --Check for no argument
             if length(argument) < 1 then
                --Tell them
                gameMessage("You must specify what object to drop.")
             else
                --Set quantity to 1 to start with
                quantity = 1
                --Get the position of the first space in the argument
                pos = find(' ', argument)
                --Check if one was found
                if pos > 1 then
                   --Set numberFlag to 1 to start with
                   numberFlag = 1
                   --Check if the bit before the space is all numeric
                   for i = 1 to pos - 1 do
                       --Check for a non-numeric character
                       if not find(argument[i], "1234567890") then
                          --Set numberFlag to 0
                          numberFlag = 0
                       end if
                   end for
                   --Check if it is a number
                   if numberFlag then
                      --Get the value
                      temp = value(argument[1..pos - 1])
                      --Check for error
                      if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                         --Give an error message
                         gameMessage("Error getting quantity.")
                      else
                         --Set quantity to the value
                         quantity = temp[2]
                         --Set argument to the (trimmed) bit after the space
                         argument = trim(argument[pos + 1..length(argument)])
                      end if
                   end if
                end if
                --Get the number of this type of object
                objectTypeNo = getObjectNo(argument)
                --Check for not found (no such object)
                if objectTypeNo < 1 then
                   --Tell them
                   gameMessage("No such object as " & argument & ".")
                else
                   --Find the position of this object type in our inventory
                   objectNo = findID(inventory, objectTypeNo)
                   --Check for none there
                   if objectNo < 1 then
                      --Tell them
                      gameMessage("You don't have any " & objectTypes[objectTypeNo][2] & ".")
                   else
                      --Check if the quantity is more the the number in our inventory
                      if quantity > inventory[objectNo][2] then
                         --Set quantity to the number in our inventory
                         quantity = inventory[objectNo][2]
                      end if

                      --Drop the quantity
                      --Take the quantity from our inventory
                      inventory = changeQuantity(inventory, objectTypeNo, -quantity)
                      --Make there be the quantity more in the place
                      places[currentPlace][4] = changeQuantity(places[currentPlace][4], objectTypeNo, quantity)

                      --Check if quantity is 1
                      if quantity = 1 then
                         --Tell them
                         gameMessage("You drop a " & objectTypes[objectTypeNo][1] & ".")
                      else
                         --Tell them
                         gameMessage("You drop " & sprint(quantity) & " " & objectTypes[objectTypeNo][2] & ".")
                      end if
                   end if
                end if
             end if
          elsif commandNo = statsCommandNo then --Player stats command
             --Save our name
             temp = name
             --Check if it means us, or it can load the person we want
             if length(argument) < 1 or loadPlayer(argument) then
                --Check if html is on
                if html then
                   --Start off with a heading
                   gameMessage("<b>Stats for " & name & "</b>")
                else
                   --Start off with a heading
                   gameMessage("Stats for " & name)
                end if
                --Show their health
                gameMessage("Health: " & sprint(health))
                --Show their money
                gameMessage("Money: " & sprint(money))

                --Check if they have a weapon
                if weapon < 1 then
                   --Say they have no weapon
                   gameMessage("Weapon: none")
                else
                   --Show their weapon
                   gameMessage("Weapon: " & objectTypes[weapon][1] & " (strength " & sprint(objectTypes[weapon][6]) & ")")
                end if

                --Check if they have a shield
                if shield < 1 then
                   --Say they have no shield
                   gameMessage("Shield: none")
                else
                   --Show their shield
                   gameMessage("Shield: " & objectTypes[shield][1] & " (strength " & sprint(objectTypes[shield][6]) & ")")
                end if
                --Show a heading for the inventory
                --Check if html is on
                if html then
                   gameMessage("<b>Inventory:</b>")
                else
                   gameMessage("Inventory:")
                end if
                --Go through all objects in the inventory
                for i = 1 to length(inventory) do
                    --Check for only one
                    if inventory[i][2] = 1 then
                       --Display this object
                       gameMessage("1 " & objectTypes[inventory[i][1]][1])
                    else
                       --Display this object
                       gameMessage(sprint(inventory[i][2]) & " " & objectTypes[inventory[i][1]][2])
                    end if
                end for
             else
                --Tell them
                --Check if html is on
                if html then
                   gameMessage("There is no such person as <i>'" & argument & "'</i> currently playing this game.")
                else
                   gameMessage("There is no such person as '" & argument & "' currently playing this game.")
                end if
             end if
             --Try to load ourselves again
             if not loadPlayer(temp) then
                --Give them an error message
                --Check if html is on
                if html then
                   gameMessage("Error loading <i>'" & temp & "'</i> after showing stats for <i>'" & name & "'</i>.")
                else
                   gameMessage("Error loading '" & temp & "' after showing stats for '" & name & "'.")
                end if
             end if
          elsif commandNo = useCommandNo then --Use item command
             --Check for no argument
             if length(argument) < 1 then
                --Tell them the problem
                gameMessage("You must specify what item to use.")
             else
                --Set quantity to 1 to start with
                quantity = 1
                --Get the position of the first space in the argument
                pos = find(' ', argument)
                --Check if one was found
                if pos > 1 then
                   --Set numberFlag to 1 to start with
                   numberFlag = 1
                   --Check if the bit before the space is all numeric
                   for i = 1 to pos - 1 do
                       --Check for a non-numeric character
                       if not find(argument[i], "1234567890") then
                          --Set numberFlag to 0
                          numberFlag = 0
                       end if
                   end for
                   --Check if it is a number
                   if numberFlag then
                      --Get the value
                      temp = value(argument[1..pos - 1])
                      --Check for error
                      if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                         --Give an error message
                         gameMessage("Error getting quantity.")
                      else
                         --Set quantity to the value
                         quantity = temp[2]
                         --Set argument to the (trimmed) bit after the space
                         argument = trim(argument[pos + 1..length(argument)])
                      end if
                   end if
                end if
                --Get the number of this type of object
                objectTypeNo = getObjectNo(argument)
                --Check for not found (no such object)
                if objectTypeNo < 1 then
                   --Tell them
                   --Check if html is on
                   if html then
                      gameMessage("No such object as <i>" & argument & "</i>.")
                   else
                      gameMessage("No such object as " & argument & ".")
                   end if
                else
                   --Find the position of this object type in their inventory
                   objectNo = findID(inventory, objectTypeNo)
                   --Check for none there
                   if objectNo < 1 then
                      --Tell them
                      gameMessage("You don't have any " & objectTypes[objectTypeNo][2] & ".")
                   else
                      --Check if the quantity is more the the number in our inventory
                      if quantity > inventory[objectNo][2] then
                         --Set quantity to the number in our inventory
                         quantity = inventory[objectNo][2]
                      end if
                      --Use the quantity
                      --Check what type of action it has
                      if objectTypes[objectTypeNo][5] = 1 then --Gives more health
                         --Increase health by the amount specified in the argument * the quantity
                         health += objectTypes[objectTypeNo][6] * quantity
                         --Check if it can only be used once
                         if objectTypes[objectTypeNo][4] then
                            --Take the quantity from our inventory
                            inventory = changeQuantity(inventory, objectTypeNo, -quantity)
                         end if
                         --Check if quantity is 1
                         if quantity = 1 then
                            --Give a message
                            gameMessage("You use a " & objectTypes[objectTypeNo][1] & ", and gain " & sprint(objectTypes[objectTypeNo][6]) & " health.")
                         else
                            --Give a message
                            gameMessage("You use " & sprint(quantity) & " " & objectTypes[objectTypeNo][2] & ", and gain " & sprint(objectTypes[objectTypeNo][6] * quantity) & " health.")
                         end if
                      elsif objectTypes[objectTypeNo][5] = 3 then --Weapon
                         --Check if we already have a weapon
                         if weapon > 0 then
                            --Add the old one to our inventory
                            inventory = changeQuantity(inventory, weapon, 1)
                         end if
                         --Wield it
                         weapon = objectTypeNo
                         --Remove it from our inventory
                         inventory = changeQuantity(inventory, objectTypeNo, -1)
                         --Give a message
                         gameMessage("You wield the " & objectTypes[objectTypeNo][1] & ".")
                      elsif objectTypes[objectTypeNo][5] = 4 then --Shield
                         --Check if we already have a shield
                         if shield > 0 then
                            --Add the old one to our inventory
                            inventory = changeQuantity(inventory, shield, 1)
                         end if
                         --Wield it
                         shield = objectTypeNo
                         --Remove it from our inventory
                         inventory = changeQuantity(inventory, objectTypeNo, -1)
                         --Give a message
                         gameMessage("You wield the " & objectTypes[objectTypeNo][1] & ".")
                      elsif objectTypes[objectTypeNo][5] = 5 then --Book
                         --Give a message
                         gameMessage("You read the book. It says:")
                         --Show the text
                         gameMessage(objectTypes[objectTypeNo][6])

                         --Check if it can only be used once
                         if objectTypes[objectTypeNo][4] then
                            --Take the quantity from our inventory
                            inventory = changeQuantity(inventory, objectTypeNo, -quantity)
                         end if
                      else --Does nothing
                         --Check if it can only be used once
                         if objectTypes[objectTypeNo][4] then
                            --Take the quantity from our inventory
                            inventory = changeQuantity(inventory, objectTypeNo, -quantity)
                         end if
                      end if
                   end if
                end if
             end if
          elsif commandNo = chatCommandNo then --Chat command
             --Call the chat callback
             callChat(argument)
          elsif commandNo = attackCommandNo then --Attack command
             --Check for no argument
             if length(argument) < 1 then
                --Tell them
                gameMessage("You must specify who to attack.")
             elsif equal(lower(argument), lower(name)) then
                --Tell them
                gameMessage("You cannot attack yourself.")
             else
                --Check if we cannot attack them
                if find(lower(argument), noAttack) then
                   --Tell them
                   gameMessage("You cannot attack " & argument & " at the moment.")
                else
                   --Save our name
                   temp = name
                   --Save our place
                   ourPlace = currentPlace
                   --Check if we don't have a weapon
                   if weapon < 1 then
                      --Set weaponStrength to 0
                      weaponStrength = 0
                   else
                      --Set weaponStrength to the strength of our weapon
                      weaponStrength = objectTypes[weapon][6]
                   end if
                   --Try to load the person who they want to attack
                   if loadPlayer(argument) then
                      --Check if they are in the same place as us
                      if currentPlace = ourPlace then
                         --Check if they don't have a shield
                         if shield < 1 then
                            --Set shieldStrength to 0
                            shieldStrength = 0
                         else
                            --Set shieldStrength to the strength of their shield
                            shieldStrength = objectTypes[shield][6]
                         end if
                         --Calculate the amount of health they lose
                         healthOff = (weaponStrength + 1) / (shieldStrength + 1) * (rand(10) / 5) + (rand(10) / 10)
                         --Save their name
                         argument = name
                         --Try to load us again, and check for error
                         if loadPlayer(temp) then
                            --Check if we have a weapon
                            if weapon > 0 then
                               --Tell them
                               gameMessage("You attack " & argument & " with your " & objectTypes[weapon][1] & ", taking " & sprint(healthOff) & " health.")
                            else
                               --Tell them
                               gameMessage("You attack " & argument & " with no weapon, taking " & sprint(healthOff) & " health.")
                            end if
                            --Tell the person who was attacked, and check if they die
                            if callAttack(argument, healthOff) then
                               --Tell them
                               gameMessage(argument & " dies.")
                               --Try to load them
                               if loadPlayer(argument) then
                                  --Save the type of their weaopn and shield
                                  weaponType = weapon
                                  shieldType = shield
                                  --Give them no weapon and shield
                                  weapon = 0
                                  shield = 0
                                  --Try to load the attacking player again
                                  if loadPlayer(temp) then
                                     --Check if they had a weapon
                                     if weaponType > 0 then
                                        --Add it to our inventory
                                        inventory = changeQuantity(inventory, weaponType, 1)
                                        --Tell them
                                        gameMessage("You take " & argument & "'s " & objectTypes[weaponType][1] & ".")
                                     end if
                                     --Check if they had a shield
                                     if shieldType > 0 then
                                        --Add it to our inventory
                                        inventory = changeQuantity(inventory, shieldType, 1)
                                        --Tell them
                                        gameMessage("You take " & argument & "'s " & objectTypes[shieldType][1] & ".")
                                     end if
                                  else
                                     --Give an error message
                                     gameMessage("Error loading '" & temp & "' after attacking '" & name & "'.")
                                  end if
                               else
                                  --Give an error message
                                  gameMessage("Error loading '" & argument & "' to take weapons and shields.")
                               end if
                            end if
                         else
                            --Give an error message
                            gameMessage("Error loading '" & temp & "' after attacking '" & name & "'.")
                         end if
                         --Add them to our list of people we can't attack at the moment
                         noAttack = append(noAttack, lower(argument))
                      else
                         --Tell them
                         gameMessage(name & " is not in the same place as you.")
                         --Try to load us again, and check for error
                         if not loadPlayer(temp) then
                            --Give an error message
                            gameMessage("Error loading '" & temp & "' after trying to attack '" & name & "'.")
                         end if
                      end if
                   else
                      --Tell them
                      gameMessage("There is no such person as '" & argument & "' currently playing this game.")
                   end if
                end if
             end if
          elsif commandNo = buyCommandNo then --Buy command
             --Check if it is not a shop
             if integer(places[currentPlace][5]) and places[currentPlace][5] != 1 then
                --Tell them
                gameMessage("This is not a shop.")
             else
                --Check for no argument
                if length(argument) < 1 then
                   --Tell them
                   gameMessage("You must specify which item you wish to buy")
                else
                   --Set quantity to 1 to start with
                   quantity = 1
                   --Get the position of the first space in the argument
                   pos = find(' ', argument)
                   --Check if one was found
                   if pos > 1 then
                      --Set numberFlag to 1 to start with
                      numberFlag = 1
                      --Check if the bit before the space is all numeric
                      for i = 1 to pos - 1 do
                          --Check for a non-numeric character
                          if not find(argument[i], "1234567890") then
                             --Set numberFlag to 0
                             numberFlag = 0
                          end if
                      end for
                      --Check if it is a number
                      if numberFlag then
                         --Get the value
                         temp = value(argument[1..pos - 1])
                         --Check for error
                         if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                            --Give an error message
                            gameMessage("Error getting quantity.")
                         else
                            --Set quantity to the value
                            quantity = temp[2]
                            --Set argument to the (trimmed) bit after the space
                            argument = trim(argument[pos + 1..length(argument)])
                         end if
                      end if
                   end if
                   --Get the number of this type of object
                   objectTypeNo = getObjectNo(argument)
                   --Check for not found (no such object)
                   if objectTypeNo < 1 then
                      --Tell them
                      gameMessage("No such object as " & argument & ".")
                   else
                      --Find the position of this object type in the shop at this place
                      objectNo = findID(places[currentPlace][6], objectTypeNo)
                      --Check for none here
                      if objectNo < 1 then
                         --Tell them
                         gameMessage("This shop does not sell " & objectTypes[objectTypeNo][2] & ".")
                      else
                         --Check if there are none left
                         if places[currentPlace][6][objectNo][3] = 0 then
                            --Tell them
                            gameMessage("There are no " & objectTypes[objectTypeNo][2] & " left here.")
                         else
                            --Check if there are a finite number for sale and quantity is more than there are left
                            if places[currentPlace][6][objectNo][3] > -1 and quantity > places[currentPlace][6][objectNo][3] then
                               --Set quantity to the number left
                               quantity = places[currentPlace][6][objectNo][3]
                            end if

                            --Check if we can't afford it
                            if places[currentPlace][6][objectNo][2] * quantity > money then
                               --Check if quantity is 1
                               if quantity = 1 then
                                  --Tell them
                                  gameMessage("You don't have enough money to buy a " & objectTypes[objectTypeNo][1] & ".")
                               else
                                  --Tell them
                                  gameMessage("You don't have enough money to buy " & sprint(quantity) & " " & objectTypes[objectTypeNo][2] & ".")
                               end if
                            else
                               --Check that the shop is not owned by this player
                               if not equal(lower(name), lower(places[currentPlace][5])) then
                                  --Pay for it
                                  --Take the money from the player
                                  money -= places[currentPlace][6][objectNo][2] * quantity
                                  --Check if the shop is owned by a player
                                  if sequence(places[currentPlace][5]) then
                                     --Add the money to the shop
                                     places[currentPlace][8] += places[currentPlace][6][objectNo][2] * quantity
                                  end if
                               end if

                               --Check if there are a finite number of them
                               if places[currentPlace][6][objectNo][3] != -1 then
                                  --Make there be the quantity less in the shop
                                  places[currentPlace][6][objectNo][3] -= quantity
                               end if

                               --Check if quantity is 1
                               if quantity = 1 then
                                  --Tell them they have bought it
                                  gameMessage("You buy a " & objectTypes[objectTypeNo][1] & ".")
                               else
                                  --Tell them they have bought a number of them
                                  gameMessage("You buy " & sprint(quantity) & " " & objectTypes[objectTypeNo][2] & ".")
                               end if

                               --Check if it is type 2 (money)
                               if objectTypes[objectTypeNo][5] = 2 then
                                  --Add the amount to our money
                                  money += objectTypes[objectTypeNo][6] * quantity
                               else
                                  --Add the quantity of it to our inventory
                                  inventory = changeQuantity(inventory, objectTypeNo, quantity)
                               end if
                            end if
                         end if
                      end if
                   end if
                end if
             end if
          elsif commandNo = sellCommandNo then --Sell command
             --Check if it is not a shop
             if integer(places[currentPlace][5]) and places[currentPlace][5] != 1 then
                --Tell them
                gameMessage("This is not a shop.")
             else
                --Check for no argument
                if length(argument) < 1 then
                   --Tell them
                   gameMessage("You must specify which item you wish to sell.")
                else
                   --Set quantity to 1 to start with
                   quantity = 1
                   --Get the position of the first space in the argument
                   pos = find(' ', argument)
                   --Check if one was found
                   if pos > 1 then
                      --Set numberFlag to 1 to start with
                      numberFlag = 1
                      --Check if the bit before the space is all numeric
                      for i = 1 to pos - 1 do
                          --Check for a non-numeric character
                          if not find(argument[i], "1234567890") then
                             --Set numberFlag to 0
                             numberFlag = 0
                          end if
                      end for
                      --Check if it is a number
                      if numberFlag then
                         --Get the value
                         temp = value(argument[1..pos - 1])
                         --Check for error
                         if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                            --Give an error message
                            gameMessage("Error getting quantity.")
                         else
                            --Set quantity to the value
                            quantity = temp[2]
                            --Set argument to the (trimmed) bit after the space
                            argument = trim(argument[pos + 1..length(argument)])
                         end if
                      end if
                   end if
                   --Get the number of this type of object
                   objectTypeNo = getObjectNo(argument)
                   --Check for not found (no such object)
                   if objectTypeNo < 1 then
                      --Tell them
                      gameMessage("No such object as " & argument & ".")
                   else
                      --Find the position of this object type in our inventory
                      pos = findID(inventory, objectTypeNo)
                      --Check for none there
                      if pos < 1 then
                         --Tell them
                         gameMessage("You don't have any " & objectTypes[objectTypeNo][2] & ".")
                      else
                         --Find the position of this object type in the shop at this place
                         objectNo = findID(places[currentPlace][6], objectTypeNo)
                         --Check for none here
                         if objectNo < 1 then
                            --Tell them
                            gameMessage("This shop does not buy " & objectTypes[objectTypeNo][2] & ".")
                         else
                            --Check if the shop is owned by a player and can't afford any
                            if sequence(places[currentPlace][5])
                             and (places[currentPlace][6][objectNo][2] / 2) > places[currentPlace][8] and not equal(lower(name), lower(places[currentPlace][5])) then
                               --Tell them
                               gameMessage("This shop is not buying any " & objectTypes[objectTypeNo][2] & " at the moment.")
                            else
                               --Check if the quantity is more the the number in our inventory
                               if quantity > inventory[pos][2] then
                                  --Set quantity to the number in our inventory
                                  quantity = inventory[pos][2]
                               end if

                               --Check if the shop is owned by a player, the quantity is more than the number the shop can afford and the shop is not owned by us
                               if sequence(places[currentPlace][5])
                                and quantity * (places[currentPlace][6][objectNo][2] / 2) > places[currentPlace][8]
                                and not equal(lower(name), lower(places[currentPlace][5])) then
                                  --Set it to the most the shop can afford
                                  quantity = floor(places[currentPlace][8] / (places[currentPlace][6][objectNo][2] / 2))
                               end if

                               --Take the quantity from our inventory
                               inventory = changeQuantity(inventory, objectTypeNo, -quantity)

                               --Check that we don't own the shop
                               if not equal(lower(name), lower(places[currentPlace][5])) then
                                  --Pay us for them
                                  --Add the money to us
                                  money += (places[currentPlace][6][objectNo][2] / 2) * quantity
                                  --Check if the shop is owned by a player
                                  if sequence(places[currentPlace][5]) then
                                     --Take the money from the shop
                                     places[currentPlace][8] -= (places[currentPlace][6][objectNo][2] / 2) * quantity
                                  end if
                               end if

                               --Check if there are a finite number of them
                               if places[currentPlace][6][objectNo][3] != -1 then
                                  --Make there be the quantity more in the shop at this place
                                  places[currentPlace][6][objectNo][3] += quantity
                               end if

                               --Check if quantity is 1
                               if quantity = 1 then
                                  --Tell them they have bought it
                                  gameMessage("You sell a " & objectTypes[objectTypeNo][1] & " to the shop.")
                               else
                                  --Tell them they have bought a number of them
                                  gameMessage("You sell " & sprint(quantity) & " " & objectTypes[objectTypeNo][2] & " to the shop.")
                               end if
                            end if
                         end if
                      end if
                   end if
                end if
             end if
          elsif commandNo = buildCommandNo then --Build shop
             if equal(places[currentPlace][5], 2) then --Check if a shop can be built here
                --Make the shop
                places[currentPlace][5] = name
                --Tell them
                gameMessage("You build a shop.")
             elsif sequence(places[currentPlace][5]) and equal(lower(places[currentPlace][5]), lower(name)) then --Check if they own a shop here
                --Tell them
                gameMessage("You already own a shop here.")
             elsif equal(places[currentPlace][5], 0) then --Check if no shop can be built here
                --Tell them
                gameMessage("You cannot build a shop here.")
             else --There must already be a shop here
                --Tell them
                gameMessage("There is already a shop here.")
             end if
          elsif commandNo = addCommandNo then --Add item to shop
             if sequence(places[currentPlace][5]) and equal(lower(places[currentPlace][5]), lower(name)) then --Check if there is a shop here and it is owned by this person
                --Check for no argument
                if length(argument) < 1 then
                   --Tell them
                   gameMessage("You must specify which object to add.")
                else
                   --Find the position of the last space
                   pos = find(' ', reverse(argument))
                   --Check for none
                   if pos < 1 then
                      --Tell them
                      gameMessage("You must specify a price.")
                   else
                      --Fix up pos
                      pos = length(argument) - pos + 1
                      --Get the value of the price
                      temp = value(argument[pos + 1..length(argument)])
                      --Check for error
                      if temp[1] != GET_SUCCESS or not atom(temp[2]) then
                         --Tell them
                         gameMessage("'" & argument[pos + 1..length(argument)] & "' is not a valid price.")
                      else
                         --Trim the price off
                         argument = trim(argument[1..pos - 1])
                         --Get the number of this type of object
                         objectTypeNo = getObjectNo(argument)
                         --Check for not found (no such object)
                         if objectTypeNo < 1 then
                            --Tell them
                            gameMessage("No such object as " & argument & ".")
                         else
                            --Check if this shop already sells this type of object
                            if findID(places[currentPlace][6], objectTypeNo) then
                               --Tell them
                               gameMessage("This shop already sells " & objectTypes[objectTypeNo][2] & ".")
                            else
                               --Add the object and its price to the shop with a quantity of 0
                               places[currentPlace][6] = append(places[currentPlace][6], {objectTypeNo, temp[2], 0})
                            end if
                         end if
                      end if
                   end if
                end if
             elsif integer(places[currentPlace][5]) and places[currentPlace][5] != 1 then --There is no shop here
                --Tell them
                gameMessage("There is no shop here.")
             else --The shop is not owned by this player
                --Tell them
                gameMessage("You don't own this shop.")
             end if
          elsif commandNo = moneyCommandNo then --Add money to shop
             if sequence(places[currentPlace][5]) and equal(lower(places[currentPlace][5]), lower(name)) then --Check if there is a shop here and it is owned by this person
                --Check for no argument
                if length(argument) < 1 then
                   --Tell them
                   gameMessage("You must specify how much money to add.")
                else
                   --Get the value of the argument
                   temp = value(argument)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not atom(temp[2]) then
                      --Tell them
                      gameMessage("Invalid number '" & argument & "'")
                   else
                      --Check if it is more than they have
                      if temp[2] > money then
                         --Set it to the amount of money they have got
                         temp[2] = money
                      end if

                      --Check if it is more than the shop has
                      if -temp[2] > places[currentPlace][8] then
                         --Set it to the amount the shop has
                         temp[2] = -places[currentPlace][8]
                      end if

                      --Give the money to the shop
                      places[currentPlace][8] += temp[2]

                      --Take the money from the player
                      money -= temp[2]
                   end if
                end if
             elsif integer(places[currentPlace][5]) and places[currentPlace][5] != 1 then --There is no shop here
                --Tell them
                gameMessage("There is no shop here.")
             else --The shop is not owned by this player
                --Tell them
                gameMessage("You don't own this shop.")
             end if
          else --Other
             --Set movedFlag to zero
             movedFlag = 0
             --Go through movement commands for this place
             for i = 1 to length(places[currentPlace][3]) do
                 --Check if the command matches
                 if commandNo = places[currentPlace][3][i][1] then
                    --Check if there is any entry requirement for this move
                    if places[currentPlace][3][i][3] = 1 then --Password
                       --Check if the argument
                       if length(argument) < 1 then --No argument
                          --Tell them
                          gameMessage("You need a password to go this way.")
                          --Set the flag to say that we've done something
                          movedFlag = 1
                          --Exit the loop
                          exit
                       elsif not equal(lower(argument), lower(places[currentPlace][3][i][4])) then --Incorrect password
                          --Tell them
                          gameMessage("Incorrect password.")
                          --Set the flag to say that we've done something
                          movedFlag = 1
                          --Exit the loop
                          exit
                       end if
                    elsif places[currentPlace][3][i][3] = 2 then --Key
                       --Get the position of the key in their inventory
                       pos = findID(inventory, places[currentPlace][3][i][4])
                       --Check if they have the key
                       if pos then
                          --Tell them
                          gameMessage("You use your " & objectTypes[places[currentPlace][3][i][4]][1] & " to get into the " & places[places[currentPlace][3][i][2]][1] & ".")
                          --Check if it is single use
                          if objectTypes[places[currentPlace][3][i][4]][4] then
                             --Make them have one less of it
                             inventory[pos][2] -= 1
                             if inventory[pos][2] <= 0 then
                                inventory = aremoveItem(inventory, pos)
                             end if
                          end if
                       else
                          --Tell them they need a key
                          gameMessage("You need a key to go this way.")
                          --Set the flag to say that we've done something
                          movedFlag = 1
                          --Exit the loop
                          exit
                       end if
                    end if
                    --Tell the program we've moved
                    callMove()
                    --Move to the place specified for that command
                    currentPlace = places[currentPlace][3][i][2]
                    --Show the new place info
                    showCurrentPlace()
                    --Set the flag to say that we've moved
                    movedFlag = 1
                    --Exit the loop
                    exit
                 end if
             end for
             --Check the flag that tells if we've moved
             if not movedFlag then
                --Tell them it's an invalid command for this place
                gameMessage("Invalid command for this place.")
             end if
          end if

          --Check for no health left
          if health <= 0 then
             --Tell them
             gameMessage("You have died.")
             --Return 1 for exit
             return 1
          end if

          --Return 0 for normal
          return 0
end function

global function checkHealth()
         --Check for no health left
         if health <= 0 then
            --Tell them
            gameMessage("You have died.")
            --Return 1
            return 1
         end if

         --Return 0
         return 0
end function
