include acLib.e
include readwritegc.e

procedure writeCommand(sequence commandName, integer commandNo, integer fn)
          --Check for no command
          if commandNo < 1 then
             --Exit the procedure
             return
          end if

          --Write the command name, '=' sign and opening '{'
          puts(fn, commandName & " = {")

          --Go through that command
          for i = 1 to length(commands[commandNo]) do
              --Write the command
              puts(fn, "\"" & commands[commandNo][i] & "\"")
              --Check that it is not the last one
              if i != length(commands[commandNo]) then
                 --Write a comma and space ', '
                 puts(fn, ", ")
              end if
          end for

          --Write the closing '}', and a new line
          puts(fn, "}\n")
end procedure

procedure decompile(sequence outFile)
          integer fn

          --Open the output (game source) file
          fn = open(outFile, "w")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error opening '" & outFile & "'\n")
             --Abort the program
             abort(1)
          end if

          --Write the objects section start
          puts(fn, "<objects>\n\n")
          --Go through all the objects
          for i = 1 to length(objectTypes) do
              --Write the object header (objectSingular)
              puts(fn, "[" & objectTypes[i][1] & "]\n")
              --Write the plural
              puts(fn, "plural = \"" & objectTypes[i][2] & "\"\n")
              --Write the description
              puts(fn, "desc = \"" & objectTypes[i][3] & "\"\n")
              --Write singleUse
              puts(fn, "singleUse = " & sprint(objectTypes[i][4]) & "\n")
              --Write actionType
              puts(fn, "action = " & sprint(objectTypes[i][5]) & "\n")
              --Write actionArgs
              puts(fn, "param = " & sprint(objectTypes[i][6]) & "\n")
              --Write a blank line
              puts(fn, "\n")
          end for

          --Write commands section start
          puts(fn, "<commands>\n\n")

          --Write exitCommandNo
          writeCommand("exit", exitCommandNo, fn)
          --Write helpCommandNo
          writeCommand("help", helpCommandNo, fn)
          --Write lookCommandNo
          writeCommand("look", lookCommandNo, fn)
          --Write examineCommandNo
          writeCommand("examine", examineCommandNo, fn)
          --Write getCommandNo
          writeCommand("get", getCommandNo, fn)
          --Write dropCommandNo
          writeCommand("drop", dropCommandNo, fn)
          --Write statsCommandNo
          writeCommand("stats", statsCommandNo, fn)
          --Write useCommandNo
          writeCommand("use", useCommandNo, fn)
          --Write chatCommandNo
          writeCommand("chat", chatCommandNo, fn)
          --Write addressCommandNo
          writeCommand("address", addressCommandNo, fn)
          --Write attackCommandNo
          writeCommand("attack", attackCommandNo, fn)
          --Write buyCommandNo
          writeCommand("buy", buyCommandNo, fn)
          --Write sellCommandNo
          writeCommand("sell", sellCommandNo, fn)
          --Write buildCommandNo
          writeCommand("build", buildCommandNo, fn)
          --Write addCommandNo
          writeCommand("add", addCommandNo, fn)
          --Write moneyCommandNo
          writeCommand("money", moneyCommandNo, fn)

          --Write a blank line
          puts(fn, "\n")

          --Go through all the commands
          for i = 1 to length(commands) do
              --Check that this command has not already been written
              if not find(i, {exitCommandNo, helpCommandNo, lookCommandNo, examineCommandNo, getCommandNo, dropCommandNo, statsCommandNo, useCommandNo, chatCommandNo, addressCommandNo,
                               attackCommandNo, buyCommandNo, sellCommandNo, buildCommandNo, addCommandNo, moneyCommandNo}) then
                 --Write it, as a move
                 writeCommand("move", i, fn)
              end if
          end for

          --Write a blank line
          puts(fn, "\n")

          --Write places section header
          puts(fn, "<places>\n\n")
          --Go through all the places
          for i = 1 to length(places) do
              --Write the place header (name)
              puts(fn, "[" & places[i][1] & "]\n")
              --Write the place description
              puts(fn, "desc = ")
              writeString(fn, places[i][2])
              puts(fn, "\n")
              --Check if there is a picture
              if length(places[i][7]) > 0 then
                 --Write it
                 puts(fn, "picture = ")
                 writeString(fn, places[i][7])
                 puts(fn, "\n")
              end if
              --Check if there are some moves
              if length(places[i][3]) > 0 then
                 --Write start of moves part of place
                 puts(fn, "moves:\n")
                 --Go through all the moves
                 for m = 1 to length(places[i][3]) do
                     --Write this move
                     puts(fn, "\"" & commands[places[i][3][m][1]][1] & "\" - \"" & places[places[i][3][m][2]][1] & "\"")
                     --Check if there is a password or key
                     if places[i][3][m][3] = 1 then --Password
                        --Write the password
                        puts(fn, " - ")
                        writeString(fn, places[i][3][m][4])
                     elsif places[i][3][m][3] = 2 then --Key
                        --Write the name of the key object
                        puts(fn, " - key ")
                        writeString(fn, objectTypes[places[i][3][m][4]][1])
                     end if
                     --Write a new line
                     nl(fn)
                 end for
              end if
              --Check if there are some objects
              if length(places[i][4]) > 0 then
                 --Write start of objects part of place
                 puts(fn, "objects:\n")
                 --Go through all the objects
                 for o = 1 to length(places[i][4]) do
                     --Write this object
                     puts(fn, "\"" & objectTypes[places[i][4][o][1]][1] & "\" - " & sprint(places[i][4][o][2]) & "\n")
                 end for
              end if
              if sequence(places[i][5]) then --Check if it is a player-owned shop
                 --Write the owner
                 puts(fn, "shopOwner = \"" & places[i][5] & "\"\n")
                 --Write the money
                 puts(fn, "shopMoney = " & sprint(places[i][8]) & "\n")
              elsif places[i][5] = 2 then --Check if it is an empty shop
                 --Write this
                 puts(fn, "emptyShop\n")
              end if
              if length(places[i][6]) > 0 then --Check if it has any items
                 --Write start of shop items part of place
                 puts(fn, "shopItems:\n")
                 --Go through all the shop items
                 for s = 1 to length(places[i][6]) do
                     --Write the start of this item
                     puts(fn, "\"" & objectTypes[places[i][6][s][1]][1] & "\" - " & sprint(places[i][6][s][2]) & " - ")
                     --Check if there are infinite of this item
                     if places[i][6][s][3] = -1 then
                        --Write the special symbol used for infinite items
                        puts(fn, "!\n")
                     else
                        --Write the number of items
                        puts(fn, sprint(places[i][6][s][3]) & "\n")
                     end if
                 end for
              end if
              --Write a blank line
              puts(fn, "\n")
          end for

          --Write the general section header
          puts(fn, "<general>\n\n")
          --Write the gameName
          puts(fn, "gameName = ")
          writeString(fn, gameName)
          puts(fn, "\n")
          --Write the startPlace
          puts(fn, "startPlace = \"" & places[startPlace][1] & "\"\n")
          --Write startHealth
          puts(fn, "startHealth = " & sprint(startHealth) & "\n")
          --Write startMoney
          puts(fn, "startMoney = " & sprint(startMoney) & "\n")
          --Check if there is a helpText
          if length(helpText) > 0 then
             --Write helpText
             puts(fn, "helpText = ")
             writeString(fn, helpText)
             puts(fn, "\n")
          end if
          --Check if there is an endMessage
          if length(endMessage) > 0 then
             --Write endMessage
             puts(fn, "endMessage = ")
             writeString(fn, endMessage)
             puts(fn, "\n")
          end if

          --Close the file
          close(fn)
end procedure

procedure start()
          integer pos
          sequence inFile, outFile

          --Prompt for the input (compiled) file
          inFile = prompt_string("Please enter the filename of the compiled game file to decompile: ")

          --Check for empty
          if length(inFile) < 1 then
             --Exit the procedure
             return
          end if

          --Load it
          loadGame(inFile)

          --Work out the output (game source) filename
          pos = find('.', inFile)
          if pos > 0 then
             outFile = inFile[1..pos] & "gsc"
          else
             outFile = inFile & ".gsc"
          end if

          --Decompile it
          decompile(outFile)
end procedure

start()
