with trace

include get.e
include wildcard.e
include acLib.e
include readwritegc.e

procedure addCommand(sequence line, sequence cName)
          integer pos
          sequence temp

          --Find the position of the '=' sign
          pos = find('=', line)
          --Remove it and everything before it
          line = line[pos + 1..length(line)]
          --Trim the line
          line = trim(line)
          --Get the value of the rest
          temp = value(line)
          --Check for error
          if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
             --Give an error message
             puts(2, "Error " & sprint(temp[1]) & " getting value of " & cName & " command\n")
             --Abort the program
             abort(1)
          end if

          --Append the value to commands
          commands = append(commands, temp[2])
end procedure

--Get the number of the object by the given name
function getObjectNo(sequence objectName)
         --Go through all the objectTypes
         for i = 1 to length(objectTypes) do
             --Check if this is the right object, either singular or plural
             if equal(objectName, objectTypes[i][1]) or equal(objectName, objectTypes[i][2]) then
                --Return the index of this object
                return i
             end if
         end for

         --It hasn't found the object, so return 0
         return 0
end function

procedure compile(sequence sourceFile)
          integer fn, objectSingleUse, objectAction, pos, placeMovesFlag, placeObjectsFlag, placeShopItemsFlag, placeMoveCommand, placeMovePlaceNumber, placeMoveEntryRequirement,
                   placeObjectType
          atom placeShopMoney
          sequence objectSingular, objectPlural, objectDesc, placeName, placeDesc, placeMoves, placeObjects, placeShopItems, temp, placeMovePlaceName, placePictureName
          object objectParam, line, placeMoveERparam, placeShopOwner

          --Open the source file
          fn = open(sourceFile, "r")
          --Check for error
          if fn = -1 then
             --Give an error message
             puts(2, "Error opening '" & sourceFile & "'\n")
             --Abort the program
             abort(1)
          end if

          --Get the start of objects section
          while 1 do
                --Get the next line
                line = gets(fn)
                --Check for end of file
                if not sequence(line) then
                   --Give an error message
                   puts(2, "End-of-file reached prematurely\n")
                   --Abort the program
                   abort(1)
                end if
                --Check for newline character
                if line[length(line)] = '\n' then
                   --Remove it
                   line = line[1..length(line) - 1]
                end if
                --Trim the line
                line = trim(line)
                --Check the line
                if length(line) = 0 then --Blank line
                   --Do nothing
                elsif equal(lower(line), "<objects>") then --Start of objects section
                   --Exit the loop
                   exit
                else --Unexpected
                   --Give an error message
                   puts(2, "Unexpected line:\n\t" & line & "\n")
                end if
          end while

          --Set objectTypes to empty to start with
          objectTypes = {}
          --Set object parts to default values
          objectSingular = ""
          objectPlural = ""
          objectDesc = ""
          objectSingleUse = 0
          objectAction = 0
          objectParam = 0
          --Get the objects
          while 1 do
                --Get the next line
                line = gets(fn)
                --Check for end of file
                if not sequence(line) then
                   --Give an error message
                   puts(2, "End-of-file reached prematurely\n")
                   --Abort the program
                   abort(1)
                end if
                --Check for newline character
                if line[length(line)] = '\n' then
                   --Remove it
                   line = line[1..length(line) - 1]
                end if
                --Trim the line
                line = trim(line)
                --Check the line
                if length(line) = 0 then --Blank line
                   --Do nothing
                elsif length(line) > 2 and line[1] = '[' and line[length(line)] = ']' then --Object header
                   --Check if objectSingular has a value
                   if length(objectSingular) > 0 then
                      --Add the last object to the list
                      objectTypes = append(objectTypes, {objectSingular, objectPlural, objectDesc, objectSingleUse, objectAction, objectParam})
                   end if
                   --Set object singular to the line without the "[]" symbols
                   objectSingular = line[2..length(line) - 1]
                   --Reset other object parts to default values
                   objectPlural = objectSingular
                   objectDesc = ""
                   objectSingleUse = 0
                   objectAction = 0
                   objectParam = 0
                elsif matchStart(lower(line), "plural") then --Plural of object
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of plural for object " & objectSingular & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in objectPlural
                   objectPlural = temp[2]
                elsif matchStart(lower(line), "desc") then --Description of object
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of desc for object " & objectSingular & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in objectDesc
                   objectDesc = temp[2]
                elsif matchStart(lower(line), "singleuse") then --Whether the object can have only a single use
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of singleUse for object " & objectSingular & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in objectSingleUse
                   objectSingleUse = temp[2]
                elsif matchStart(lower(line), "action") then --Action for the object
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of action for object " & objectSingular & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in objectAction
                   objectAction = temp[2]
                elsif matchStart(lower(line), "param") then --Parameter for the action of the object
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of param for object " & objectSingular & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in objectParam
                   objectParam = temp[2]
                elsif equal(lower(line), "<commands>") then --Start of commands section
                   --Check if objectSingular has a value
                   if length(objectSingular) > 0 then
                      --Add the last object to the list
                      objectTypes = append(objectTypes, {objectSingular, objectPlural, objectDesc, objectSingleUse, objectAction, objectParam})
                   end if
                   --Exit the loop
                   exit
                else --Unexpected
                   --Give an error message
                   puts(2, "Unexpected line:\n\t" & line & "\n")
                end if
          end while

          --Set commands to empty to start with
          commands = {}
          --Set commandNumbers to 0 to start with
          exitCommandNo = 0
          helpCommandNo = 0
          lookCommandNo = 0
          examineCommandNo = 0
          getCommandNo = 0
          dropCommandNo = 0
          statsCommandNo = 0
          useCommandNo = 0
          chatCommandNo = 0
          addressCommandNo = 0
          attackCommandNo = 0
          buyCommandNo = 0
          sellCommandNo = 0
          buildCommandNo = 0
          addCommandNo = 0
          moneyCommandNo = 0
          --Get the commands
          while 1 do
                --Get the next line
                line = gets(fn)
                --Check for end of file
                if not sequence(line) then
                   --Give an error message
                   puts(2, "End-of-file reached prematurely\n")
                   --Abort the program
                   abort(1)
                end if
                --Check for newline character
                if line[length(line)] = '\n' then
                   --Remove it
                   line = line[1..length(line) - 1]
                end if
                --Trim the line
                line = trim(line)
                --Check the line
                if length(line) = 0 then --Blank line
                   --Do nothing
                elsif matchStart(lower(line), "exit") then --Exit command
                   --Add the command to the command sequence
                   addCommand(line, "exit")
                   --Set exitCommandNo
                   exitCommandNo = length(commands)
                elsif matchStart(lower(line), "help") then --Help command
                   --Add the command to the command sequence
                   addCommand(line, "help")
                   --Set helpCommandNo
                   helpCommandNo = length(commands)
                elsif matchStart(lower(line), "look") then --Look command
                   --Add the command to the command sequence
                   addCommand(line, "look")
                   --Set lookCommandNo
                   lookCommandNo = length(commands)
                elsif matchStart(lower(line), "examine") then --Examine command
                   --Add the command to the command sequence
                   addCommand(line, "examine")
                   --Set examineCommandNo
                   examineCommandNo = length(commands)
                elsif matchStart(lower(line), "get") then --Get command
                   --Add the command to the command sequence
                   addCommand(line, "get")
                   --Set getCommandNo
                   getCommandNo = length(commands)
                elsif matchStart(lower(line), "drop") then --Drop command
                   --Add the command to the command sequence
                   addCommand(line, "drop")
                   --Set dropCommandNo
                   dropCommandNo = length(commands)
                elsif matchStart(lower(line), "stats") then --Stats command
                   --Add the command to the command sequence
                   addCommand(line, "stats")
                   --Set statstCommandNo
                   statsCommandNo = length(commands)
                elsif matchStart(lower(line), "use") then --Use command
                   --Add the command to the command sequence
                   addCommand(line, "use")
                   --Set useCommandNo
                   useCommandNo = length(commands)
                elsif matchStart(lower(line), "chat") then --Chat command
                   --Add the command to the command sequence
                   addCommand(line, "chat")
                   --Set chatCommandNo
                   chatCommandNo = length(commands)
                elsif matchStart(lower(line), "address") then --Add address command
                   --Add the command to the command sequence
                   addCommand(line, "add address")
                   --Set addressCommandNo
                   addressCommandNo = length(commands)
                elsif matchStart(lower(line), "attack") then --Attack command
                   --Add the command to the command sequence
                   addCommand(line, "attack")
                   --Set attackCommandNo
                   attackCommandNo = length(commands)
                elsif matchStart(lower(line), "buy") then --Attack command
                   --Add the command to the command sequence
                   addCommand(line, "buy")
                   --Set buyCommandNo
                   buyCommandNo = length(commands)
                elsif matchStart(lower(line), "sell") then --Attack command
                   --Add the command to the command sequence
                   addCommand(line, "sell")
                   --Set sellCommandNo
                   sellCommandNo = length(commands)
                elsif matchStart(lower(line), "build") then --Build shop command
                   --Add the command to the command sequence
                   addCommand(line, "build")
                   --Set buildCommandNo
                   buildCommandNo = length(commands)
                elsif matchStart(lower(line), "add") then --Add item to shop command
                   --Add the command to the command sequence
                   addCommand(line, "add")
                   --Set addCommandNo
                   addCommandNo = length(commands)
                elsif matchStart(lower(line), "money") then --Add money to shop command
                   --Add the command to the command sequence
                   addCommand(line, "money")
                   --Set moneyCommandNo
                   moneyCommandNo = length(commands)
                elsif matchStart(lower(line), "move") then --Movement command
                   --Add the command to the command sequence
                   addCommand(line, "movement")
                elsif equal(lower(line), "<places>") then --Start of places section
                   --Exit the loop
                   exit
                else --Unexpected
                   --Give an error message
                   puts(2, "Unexpected line:\n\t" & line & "\n")
                end if
          end while

          --Set places to empty to start with
          places = {}
          --Set place parts to default values
          placeName = ""
          placeDesc = ""
          placeMoves = {}
          placeObjects = {}
          placeShopOwner = 0
          placeShopItems = {}
          placeShopMoney = 0
          placePictureName = ""
          --Set all flags off
          placeMovesFlag = 0
          placeObjectsFlag = 0
          placeShopItemsFlag = 0
          --Get the places
          while 1 do
                --Get the next line
                line = gets(fn)
                --Check for end of file
                if not sequence(line) then
                   --Give an error message
                   puts(2, "End-of-file reached prematurely\n")
                   --Abort the program
                   abort(1)
                end if
                --Check for newline character
                if line[length(line)] = '\n' then
                   --Remove it
                   line = line[1..length(line) - 1]
                end if
                --Trim the line
                line = trim(line)
                --Check the line
                if length(line) = 0 then --Blank line
                   --Do nothing
                elsif length(line) > 2 and line[1] = '[' and line[length(line)] = ']' then --Place header
                   --Check if placeName has a value
                   if length(placeName) > 0 then
                      --Add the last place to the list
                      places = append(places, {placeName, placeDesc, placeMoves, placeObjects, placeShopOwner, placeShopItems, placePictureName, placeShopMoney})
                   end if
                   --Set place name to the line without the "[]" symbols
                   placeName = line[2..length(line) - 1]
                   --Reset other place parts to default values
                   placeDesc = ""
                   placeMoves = {}
                   placeObjects = {}
                   placeShopOwner = 0
                   placeShopItems = {}
                   placeShopMoney = 0
                   placePictureName = ""
                   --Reset place flags to 0
                   placeMovesFlag = 0
                   placeObjectsFlag = 0
                   placeShopItemsFlag = 0
                elsif matchStart(lower(line), "desc") then --Description of place
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Check for not found
                   if pos < 1 then
                      --Give an error message
                      puts(2, "Error getting desc for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of desc for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in placeDesc
                   placeDesc = temp[2]
                elsif matchStart(lower(line), "picture") then --Filename of picture for place
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Check for not found
                   if pos < 1 then
                      --Give an error message
                      puts(2, "Error getting picture for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of picture for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in placePictureName
                   placePictureName = temp[2]
                elsif equal(lower(line), "emptyshop") then --This place can be made into a shop
                   --Check if it is already a computer-owned shop
                   if placeShopOwner != 0 then
                      --Give an error message
                      puts(2, "Error in place " & placeName & " - place cannot be both a built-in shop and an available shop.\n")
                      --Abort the program
                      abort(1)
                   end if
                   placeShopOwner = 2 --This means someone can build a shop here
                elsif matchStart(lower(line), "shopowner") then --Shop owner
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Check for not found
                   if pos < 1 then
                      --Give an error message
                      puts(2, "Error getting shopOwner for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of shopOwner for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in placeShopOwner
                   placeShopOwner = temp[2]
                elsif matchStart(lower(line), "shopmoney") then --Shop money
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Check for not found
                   if pos < 1 then
                      --Give an error message
                      puts(2, "Error getting shopMoney for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not atom(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of shopMoney for place " & placeName & "\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in placeShopMoney
                   placeShopMoney = temp[2]
                elsif equal(lower(line), "moves:") then --Moves part of place
                   --Set moves flag on
                   placeMovesFlag = 1
                   --Set objects flag off
                   placeObjectsFlag = 0
                   --Set shop items flag off
                   placeShopItemsFlag = 0
                elsif equal(lower(line), "objects:") then --Objects part of place
                   --Set objects flag on
                   placeObjectsFlag = 1
                   --Set moves flag off
                   placeMovesFlag = 0
                   --Set shop items flag off
                   placeShopItemsFlag = 0
                elsif equal(lower(line), "shopitems:") then --Shop items part of place
                   --Set shop items flag on
                   placeShopItemsFlag = 1
                   --Set moves flag off
                   placeMovesFlag = 0
                   --Set objects flag off
                   placeObjectsFlag = 0

                   --Check if it is already a non-player-owned shop
                   if integer(placeShopOwner) and placeShopOwner != 0 then
                      --Give an error message
                      puts(2, "Error in place " & placeName & " - place cannot be both a built-in shop and an available shop.\n")
                      --Abort the program
                      abort(1)
                   end if

                   --Check if it is not a player-owned shop
                   if not sequence(placeShopOwner) then
                      --Set placeShopOwner to 1 (shop owned by computer)
                      placeShopOwner = 1
                   end if
                elsif placeMovesFlag = 1 and find('-', line) then --Move
                   --Get the position of the '-' sign
                   pos = find('-', line)
                   --Set temp to the value of the part of the line before the '-' sign, trimmed and made lower case
                   temp = value(lower(trim(line[1..pos - 1])))
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error mesage
                      puts(2, "Error " & sprint(temp[1]) & " getting value of command in place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Set temp to just the value
                   temp = temp[2]
                   --Set placeMoveCommand to 0 to start with
                   placeMoveCommand = 0
                   --Go through commands
                   for i = 1 to length(commands) do
                       --Check if this is the right command
                       if find(temp, commands[i]) then
                          --Set placeMoveCommand
                          placeMoveCommand = i
                          --Exit the loop
                          exit
                       end if
                   end for
                   --Check if the command has not been found
                   if placeMoveCommand = 0 then
                      --Add the command
                      commands = append(commands, temp)
                      --Set placeMoveCommand
                      placeMoveCommand = length(commands)
                   end if

                   --Set temp to the part of the line after the '-' sign, trimmed
                   temp = trim(line[pos + 1..length(line)])
                   --Attempt to find another '-' sign
                   pos = find('-', temp)
                   --Check for none found
                   if pos < 1 then
                      --Set placeMoveEntryRequirement and placeMoveERparam to 0 (none)
                      placeMoveEntryRequirement = 0
                      placeMoveERparam = 0
                   else
                      --Set temp to the two separated parts, trimmed
                      temp = {trim(temp[1..pos - 1]), trim(temp[pos + 1..length(temp)])}
                      --Check if it is a password or a key
                      if matchStart("key", temp[2] & "    ") then --It's a key
                         --Get rid of the 'key' bit, trim again, then get the value
                         temp[2] = value(trim(temp[2][4..length(temp[2])]))
                         --Check for error getting value
                         if temp[2][1] != GET_SUCCESS or not sequence(temp[2][2]) then
                            --Give an error message
                            puts(2, "Error getting value of key object name for move '" & commands[placeMoveCommand][1] & "' in place '" & placeName & "'.\n")
                            --Abort
                            abort(1)
                         else
                            --Get just the value
                            temp[2] = temp[2][2]
                            --Set placeMoveEntryRequirement to 2 (key)
                            placeMoveEntryRequirement = 2
                            --Get the object type number for this key object
                            placeMoveERparam = getObjectNo(temp[2])
                            --Check for not found
                            if placeMoveERparam < 1 then
                               --Give an error message
                               puts(2, "Error: no such object as '" & temp[2] & "' (used as key for move '" & commands[placeMoveCommand][1] & "' in place '" & placeName & "'.\n")
                               --Abort the program
                               abort(1)
                            end if
                         end if
                      else --It's a password
                         --Get the value
                         temp[2] = value(temp[2])
                         --Check for error getting value
                         if temp[2][1] != GET_SUCCESS or not sequence(temp[2][2]) then
                            --Give an error message
                            puts(2, "Error getting value of password string for move '" & placeMovePlaceName & "' in place '" & placeName & "'.\n")
                            --Abort
                            abort(1)
                         else
                            --Get just the value
                            temp[2] = temp[2][2]
                            --Set placeMoveEntryRequirement to 1 (password)
                            placeMoveEntryRequirement = 1
                            --Set placeMoveERparam to the password
                            placeMoveERparam = temp[2]
                         end if
                      end if
                      --Set temp to just the first part
                      temp = temp[1]
                   end if

                   --Set temp to the value of itself, trimmed and made lower case
                   temp = value(lower(trim(temp)))
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error mesage
                      puts(2, "Error " & sprint(temp[1]) & " getting value of place name in commands of place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Set placeMovePlacename to the value
                   placeMovePlaceName = temp[2]

                   --Add this move to the list
                   placeMoves = append(placeMoves, {placeMoveCommand, placeMovePlaceName, placeMoveEntryRequirement, placeMoveERparam})
                elsif placeObjectsFlag = 1 and find('-', line) then --Object
                   --Get the position of the '-' sign
                   pos = find('-', line)
                   --Set temp to the value of the part of the line before the '-' sign, trimmed and made lower case
                   temp = value(lower(trim(line[1..pos - 1])))
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error mesage
                      puts(2, "Error " & sprint(temp[1]) & " getting value of object name in place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Set temp to just the value
                   temp = temp[2]
                   --Set placeObjectType to 0 to start with
                   placeObjectType = 0
                   --Go through all the objects
                   for i = 1 to length(objectTypes) do
                       --Check if this is the right object, either singular or plural
                       if equal(lower(objectTypes[i][1]), temp) or equal(lower(objectTypes[i][2]), temp) then
                          --Set placeObjectType
                          placeObjectType = i
                          --Exit the loop
                          exit
                       end if
                   end for
                   --Check if the object name has not been found
                   if placeObjectType = 0 then
                      --Give an error message
                      puts(2, "Error: no such object as '" & temp & "' in place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Set temp to the part of the line after the '-' sign, trimmed and made lower case
                   temp = lower(trim(line[pos + 1..length(line)]))
                   --Get the value
                   temp = value(temp)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not integer(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of number of objects in place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if

                   --Add the object to the list
                   placeObjects = append(placeObjects, {placeObjectType, temp[2]})
                elsif placeShopItemsFlag = 1 and find('-', line) then --Shop item
                   --Get the position of the '-' sign
                   pos = find('-', line)
                   --Set temp to the value of the part of the line before the '-' sign, trimmed and made lower case
                   temp = value(lower(trim(line[1..pos - 1])))
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error mesage
                      puts(2, "Error " & sprint(temp[1]) & " getting value of object name in shop of place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Set temp to just the value
                   temp = temp[2]
                   --Set placeObjectType to 0 to start with
                   placeObjectType = 0
                   --Go through all the objects
                   for i = 1 to length(objectTypes) do
                       --Check if this is the right object, either singular or plural
                       if equal(lower(objectTypes[i][1]), temp) or equal(lower(objectTypes[i][2]), temp) then
                          --Set placeObjectType
                          placeObjectType = i
                          --Exit the loop
                          exit
                       end if
                   end for
                   --Check if the object name has not been found
                   if placeObjectType = 0 then
                      --Give an error message
                      puts(2, "Error: no such object as '" & temp & "' in shop of place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Set temp to the part of the line after the '-' sign, trimmed and made lower case
                   temp = lower(trim(line[pos + 1..length(line)]))
                   --Get the position of the next '-' sign
                   pos = find('-', temp)
                   --Check for not found
                   if pos < 1 then
                      --Give an error message
                      puts(2, "Error getting position of second '-' in shop of place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Get the parts before and after it
                   temp = {trim(temp[1..pos - 1]), trim(temp[pos + 1..length(temp)])}
                   --Get the value of the price
                   temp[1] = value(temp[1])
                   --Check for error
                   if temp[1][1] != GET_SUCCESS or not atom(temp[1][2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1][1]) & " getting value of price of item in shop of place '" & placeName & "'\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Get just the value
                   temp[1] = temp[1][2]
                   --Check if the quantity is infinite (! sign)
                   if equal(temp[2], "!") then
                      --Set the quantity to -1
                      temp[2] = -1
                   else
                      --Get the value of the quantity
                      temp[2] = value(temp[2])
                      --Check for error
                      if temp[2][1] != GET_SUCCESS or not integer(temp[2][2]) then
                         --Give an error message
                         puts(2, "Error " & sprint(temp[2][1]) & " getting value of quantity of item in shop of place '" & placeName & "'\n")
                         --Abort the program
                         abort(1)
                      end if
                      --Get just the value
                      temp[2] = temp[2][2]
                   end if

                   --Add the object to the list
                   placeShopItems = append(placeShopItems, {placeObjectType, temp[1], temp[2]})
                elsif equal(lower(line), "<general>") then --Start of general section
                   --Check if placeName has a value
                   if length(placeName) > 0 then
                      --Add the last place to the list (0 for shopMoney)
                      places = append(places, {placeName, placeDesc, placeMoves, placeObjects, placeShopOwner, placeShopItems, placePictureName, placeShopMoney})
                   end if
                   --Exit the loop
                   exit
                else --Unexpected
                   --Give an error message
                   puts(2, "Unexpected line:\n\t" & line & "\n")
                end if
          end while
          --Go through all the places
          for p = 1 to length(places) do
              --Go through all moves in this place
              for m = 1 to length(places[p][3]) do
                  --Get the name of the place for this move
                  placeMovePlaceName = places[p][3][m][2]
                  --Set placeMovePlaceNumber to 0 to start with
                  placeMovePlaceNumber = 0
                  --Go through all places
                  for i = 1 to length(places) do
                      --Check if this is the right one
                      if equal(lower(placeMovePlaceName), lower(places[i][1])) then
                         --Set the place number
                         placeMovePlaceNumber = i
                         --Exit the loop
                         exit
                      end if
                  end for
                  --Check if the place name has not been found
                  if placeMovePlaceNumber = 0 then
                     --Give an error message
                     puts(2, "Error in moves in place '" & places[p][1] & "' - '" & placeMovePlaceName & "' does not exist.\n")
                     --Abort the program
                     abort(1)
                  end if
                  --Set the place to move to to the number
                  places[p][3][m][2] = placeMovePlaceNumber
              end for
          end for

          --Set gamename to empty to start with
          gameName = ""
          --Set startPlace to 0 to start with
          startPlace = 0
          --Set startHealth to 10 to start with
          startHealth = 10
          --Set startMoney to 0 to start with
          startMoney = 0
          --Set helpText to "" to start with
          helpText = ""
          --Set endMessage to "" to start with
          endMessage = ""
          --Set backgroundImage to "" to start with
          backgroundImage = ""
          --Get general stuff
          while 1 do
                --Get the next line
                line = gets(fn)
                --Check for end of file
                if not sequence(line) then
                   --Exit the loop
                   exit
                end if
                --Check for newline character
                if line[length(line)] = '\n' then
                   --Remove it
                   line = line[1..length(line) - 1]
                end if
                --Trim the line
                line = trim(line)
                --Check the line
                if length(line) = 0 then --Blank line
                   --Do nothing
                elsif matchStart(lower(line), "gamename") then --Game name
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of gameName\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in gameName
                   gameName = temp[2]
                elsif matchStart(lower(line), "startplace") then --Start place
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of startPlace\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Get just the value in temp
                   temp = temp[2]
                   --Go through places
                   for i = 1 to length(places) do
                       --Check if this is the place
                       if equal(lower(places[i][1]), lower(temp)) then
                          --Set startPlace
                          startPlace = i
                       end if
                   end for
                   --Check if startPlace has not been found
                   if startPlace < 1 then
                      --Give an error message
                      puts(2, "Error: startPlace is not an existing place, using place 1\n")
                   end if
                elsif matchStart(lower(line), "starthealth") then --Start health
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not atom(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of startHealth\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in startHealth
                   startHealth = temp[2]
                elsif matchStart(lower(line), "startmoney") then --Start money
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not atom(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of startMoney\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in startMoney
                   startMoney = temp[2]
                elsif matchStart(lower(line), "helptext") then --Help text
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of helpText\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in helpText
                   helpText = temp[2]
                elsif matchStart(lower(line), "endmessage") then --Ending message
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of endMessage\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in endMessage
                   endMessage = temp[2]
                elsif matchStart(lower(line), "backgroundimage") then --Background image
                   --Find the position of the '=' sign
                   pos = find('=', line)
                   --Remove it and everything before it
                   line = line[pos + 1..length(line)]
                   --Trim the line
                   line = trim(line)
                   --Get the value of the rest
                   temp = value(line)
                   --Check for error
                   if temp[1] != GET_SUCCESS or not sequence(temp[2]) then
                      --Give an error message
                      puts(2, "Error " & sprint(temp[1]) & " getting value of backgroundImage\n")
                      --Abort the program
                      abort(1)
                   end if
                   --Put the value in backgroundImage
                   backgroundImage = temp[2]
                else --Unexpected
                   --Give an error message
                   puts(2, "Unexpected line:\n\t" & line & "\n")
                end if
          end while
          --Check if startPlace has not been set
          if startPlace < 1 then
             --Set it to 1
             startPlace = 1
          end if
          --Check for gameName not defined
          if length(gameName) < 1 then
             --Give an error message
             puts(2, "Error: gameName not defined\n")
             --Abort the program
             abort(1)
          end if

          --Close the source file
          close(fn)
end procedure

procedure start()
          integer pos
          sequence inFile, outFile, commandLine

          --Get the command line arguments
          commandLine = command_line()
          --Check for an argument
          if length(commandLine) > 2 then
             --Get the filename from the command line
             inFile = commandLine[3]
          else
             --Prompt for the input (source) file
             inFile = prompt_string("Please enter the filename of the source file to compile: ")
          end if

          --Check for empty
          if length(inFile) < 1 then
             --Exit the procedure
             return
          end if

          --Compile it
          compile(inFile)

          --Work out the output (compiled game) filename
          pos = find('.', inFile)
          if pos > 0 then
             outFile = inFile[1..pos] & "dng"
          else
             outFile = inFile & ".dng"
          end if

          --Save it
          saveGame(outFile)

          --Tell the user we're done
          puts(1, "Done. Game saved as '" & outFile & "'.\n")
end procedure

start()
