with trace

include libcgi_mod.e
include readwritegc.e
include engine.e

sequence gameMessageString

gameMessageString = ""

procedure sendCharNameForm()
          --Write the page
          puts(1, "<html>\n") --HTML start
          puts(1, "<head>\n<title>CGI MUD - choose a name</title>\n</head>\n") --Header
          puts(1, "<body>\n") --Body start
          puts(1, "<h1>CGI MUD</h1>\n") --Heading
          puts(1, "Type your name then press play.\n") --Text
          puts(1, "<form name = \"gameForm\" method = \"GET\" action = \"cgisud\">\n") --Form start
          puts(1, "Player name: <input type = \"text\" name = \"charName\"<br>\n") --Text input for game name
          puts(1, "<input type = \"submit\" value = \"Play\">\n") --Submit button
          puts(1, "</form>\n</body>\n</html>\n") --Form, body & HTML end
end procedure

procedure sendGameNameForm(sequence charName)
          --Write the page
          puts(1, "<html>\n") --HTML start
          puts(1, "<head>\n<title>CGI MUD - choose a game</title>\n</head>\n") --Header
          puts(1, "<body>\n") --Body start
          puts(1, "<h1>CGI MUD</h1>\n") --Heading
          puts(1, "Please type the name of the game you wish to play, then press play.\n") --Text
          puts(1, "<form name = \"gameForm\" method = \"GET\" action = \"cgisud\">\n") --Form start
          puts(1, "Game name: <input type = \"text\" name = \"gameName\"<br>\n") --Text input for game name
          puts(1, "<input type = \"hidden\" name = \"charName\" value = \"" & charName & "\">\n") --Hidden input for character name
          puts(1, "<input type = \"submit\" value = \"Play\">\n") --Submit button
          puts(1, "</form>\n</body>\n</html>\n") --Form, body & HTML end
end procedure

--This is used as a callback procedure for the game engine
procedure gameMessage(sequence text)
          --Append the text to gameMessageString, with a new line afterwards
          gameMessageString &= text & "\n"
end procedure

procedure main()
          integer showCommandForm
          sequence data, cFile, gFile
          object temp

          --Get the raw data
          temp = get_data()
          --Check for error
          if not sequence(temp) then
             --Send them the appropriate form
             sendCharNameForm()
             --Exit this procedure
             return
          end if
          --Process the data
          data = process_form(temp)

          --Get the charName
          temp = field("charName")
          --Check for not found
          if not sequence(temp) then
             --Send them the appropriate form
             sendCharNameForm()
             --Exit this procedure
             return
          end if
          --Put the value into name
          name = temp

          --Check for an extension
          if find('.', name) then
             cFile = name
          else
             --Add the default extension
             cFile = name & ".dch"
          end if

          --Check if they exist
          if sequence(dir(cFile)) then
             --Load this character
             gFile = loadCharacter(cFile)
             --Load their game
             loadGame(gFile)
          else
             --Get the gameName
             temp = field("gameName")
             --Check if it was found
             if sequence(temp) then
                --Set gFile
                gFile = temp

                --Check for no extension
                if not find('.', gFile) then
                   --Add the default extension
                   gFile &= ".dng"
                end if

                --Load the game
                loadGame(gFile)

                --Create a new character
                newCharacter()
                --Set currentPlace to startPlace
                currentPlace = startPlace
                --Set health to startHealth
                health = startHealth
                --Set money to startMoney
                money = startMoney
             else
                --Send back a form asking for the gameName
                sendGameNameForm(name)
                --Exit the procedure
                return
             end if
          end if

          --Get the command
          temp = field("command")
          --Check if there is a command
          if sequence(temp) then
             --Do the command, and check for exit
             if doCommand(temp) then
             end if
          else
             showCurrentPlace()
          end if

          --Get showForm
          temp = field("showForm")
          --Check if it exists and it is 'no'
          if sequence(temp) and equal(lower(temp), "no") then
             --Set showCommandForm to false (0)
             showCommandForm = 0
          else
             --Set showCommandForm to true (1)
             showCommandForm = 1
          end if

          --Write the page
          puts(1, "<html>\n") --HTML start
          puts(1, "<head>\n<title>CGI MUD - " & name & " - " & places[currentPlace][1] & "</title>\n</head>\n") --Header
          --Check if a background image has been set
          if length(backgroundImage) > 0 then
             puts(1, "<body background = \"" & backgroundImage & "\">\n") --Body start
          else
             puts(1, "<body>\n") --Body start
          end if
          puts(1, "<h1>CGI MUD - " & name & " - " & places[currentPlace][1] & "</h1>\n") --Heading
          --Check if there is am image for this place
          if length(places[currentPlace][7]) > 0 then
             --Show the image
             puts(1, "<img src = \"" & places[currentPlace][7] & "\"><br>\n")
          end if
          puts(1, gameMessageString) --Game message, from game engine
          --Check if we should show the form
          if showCommandForm then
             puts(1, "<form name = \"gameForm\" method = \"GET\" action = \"cgisud\">\n") --Form start
             puts(1, "Type your command here:<br>\n") --Text
             puts(1, "<input type = \"text\" name = \"command\"><br>\n") --Text input for command
             puts(1, "<input type = \"hidden\" name = \"charName\" value = \"" & name & "\">\n") --Hidden input for character name
             puts(1, "<input type = \"hidden\" name = \"gameName\" value = \"" & gFile & "\">\n") --Hidden input for game filename
             puts(1, "<input type = \"submit\" value = \"Do\">\n") --Submit button
             puts(1, "</form>\n")
          end if
          puts(1, "</body>\n</html>") --Body and HTML end

          --Save the game
          saveGame(gFile)
          --Save the character
          saveCharacter(gFile)
end procedure

--Set the callback for a game message
setMessageCallback(routine_id("gameMessage"))
--Tell the game engine to use HTML
htmlOn()
main()
