include tk_maths.e --From win32lib
include misc.e

global procedure nl(integer fn)
          puts(fn, "\n")
end procedure

global function sum(sequence seq)
         atom total

         total = 0
         for i = 1 to length(seq) do
            total += seq[i]
         end for
         return total
end function

global function allTrue(object tf)
       if atom(tf) then
          return tf
       end if
       for i = 1 to length(tf) do
           if tf[i] = 0 then
              return 0
           end if
       end for
       return 1
end function

global function aOr(sequence teo)

       for i = 1 to length(teo) do
           if teo[i] = 1 then
              return 1
           end if
       end for
       return 0
end function

global function aremoveItem(sequence seq, integer item)
       if item = 1 then
          if length(seq) = 1 then
             return {}
          elsif length(seq) = 2 then
             return {seq[2]}
          else
             return seq[2..length(seq)]
          end if
       elsif item = length(seq) then
          if length(seq) = 2 then
             return {seq[1]}
          else
             return seq[1..length(seq) - 1]
          end if
       else
          return seq[1..item - 1] & seq[item + 1..length(seq)]
       end if
end function

global function readFile(integer fn)
       integer char
       sequence tempData

       tempData = ""
       char = 0
       while char != -1 do
          char = getc(fn)
          tempData &= char
       end while

       --Check if the last character is a newline
       if tempData[length(tempData)] = '\n' then
          --Remove the last character
          tempData = tempData[1..length(tempData) - 1]
       end if

       return tempData
end function

global function findNo(object item, sequence seq)
       integer number

       number = 0
       for i = 1 to length(seq) do
           if equal(item, seq[i]) then
              number += 1
           end if
       end for

       return number
end function

global function multiPrompt(sequence prompt)
       sequence string

       puts(1, prompt & "\n")
       string = readFile(0)
       for i = 1 to findNo('\n', string) + 1 do
           puts(1, '\n')
       end for

       return string
end function

global function trim(sequence string)
       if length(string) = 0 then
          return ""
       end if
       while length(string) > 0 and string[1] = ' ' do
             string = string[2..length(string)]
       end while
       while length(string) > 0 and string[length(string)] = ' ' do
             string = string[1..length(string) - 1]
       end while

       return string
end function

global function split(sequence seq, integer char)
          integer pos, e
          sequence ret

          if length(seq) = 0 then
             return {}
          end if
          ret = {}
          pos = 1
          while 1 do
                if pos > length(seq) then
                   exit
                end if
                if seq[pos] = char then
                   ret = append(ret, char)
                   pos += 1
                else
                   e = find(char, seq[pos..length(seq)])
                   if e = 0 then
                      ret = append(ret, seq[pos..length(seq)])
                      pos = length(seq) + 1
                   else
                      e -= 1
                      ret = append(ret, seq[pos..pos + e - 1])
                      pos += e
                   end if
                end if
          end while

          return ret
end function

global function radians(atom deg)
       return deg * (PI / 180)
end function

global function degrees(atom rad)
       return rad / PI * 180
end function

global function aabs(atom x)
       return abs(x)
end function

global procedure delay(atom delT)
          atom startTime

          startTime = time()
          while startTime + delT > time() do
          end while
end procedure

global function distance(sequence a, sequence b)
         sequence diff

         diff = a - b
         if diff[1] < 0 then
            diff[1] = 0 - diff[1]
         end if
         if diff[2] < 0 then
            diff[2] = 0 - diff[2]
         end if

         return sqrt(power(diff[1], 2) + power(diff[2], 2))
end function

global function splitNC(sequence seq, integer char)
          integer pos, lPos
          sequence ret

          if length(seq) = 0 then
             return {}
          end if
          ret = {}
          lPos = 0
          while 1 do
                pos = lPos + find(char, seq[lPos + 1..length(seq)])
                if pos <= lPos then
                   ret = append(ret, seq[lPos + 1..length(seq)])
                   exit
                end if
                ret = append(ret, seq[lPos + 1..pos - 1])
                lPos = pos
          end while

          return ret
end function

--Search some data for a key
global function keySearch(sequence data, object key)
       --Go through the data looking for the key
       for i = 1 to length(data) do
           --Check for the key
           if equal(data[i][1], key) then
              --Return the data for that index
              return data[i][2]
           end if
       end for

       --Return -1 if the key cannot be found
       return -1
end function

--Search some data for a key, and return the index
global function keySearchi(sequence data, object key)
       --Go through the data looking for the key
       for i = 1 to length(data) do
           --Check for the key
           if equal(data[i][1], key) then
              --Return the index
              return i
           end if
       end for

       --Return -1 if the key cannot be found
       return -1
end function

--Check if the ending of one string is equal to the other
global function matchEnding(sequence seq1, sequence seq2)
         if
          (length(seq1) >= length(seq2) and equal(seq1[length(seq1) - length(seq2) + 1..length(seq1)], seq2))
          or
          (length(seq2) >= length(seq1) and equal(seq2[length(seq2) - length(seq1) + 1..length(seq2)], seq1))
          then

            return 1
         end if

         return 0
end function

--Check if the beginning of one string is equal to the other
global function matchStart(sequence seq1, sequence seq2)
         if
          (length(seq1) >= length(seq2) and equal(seq1[1..length(seq2)], seq2))
          or
          (length(seq2) >= length(seq1) and equal(seq2[1..length(seq1)], seq1))
          then

            return 1
         end if

         return 0
end function

--Find which, if any, ending the specified string has
global function findEnding(sequence string, sequence endings)
       --Go through all the endings
       for i = 1 to length(endings) do
           --Check if it has this ending
           if matchEnding(string, endings[i]) then
              --Return the index of this ending
              return i
           end if
       end for

       --Not found, so return 0
       return 0
end function

global procedure writeString(integer fn, sequence string)
          --Write the starting '"'
          puts(fn, '\"')

          --Go through all the characters in the string
          for i = 1 to length(string) do
              --Check if it is a special character
              if string[i] = '\\' then --Backslash
                 puts(fn, "\\\\")
              elsif string[i] = '\n' then --Newline
                 puts(fn, "\\n")
              elsif string[i] = '\r' then --Carriage return
                 puts(fn, "\\c")
              elsif string[i] = '\t' then --Tab
                 puts(fn, "\\t")
              elsif string[i] = '\"' then --Double quote
                 puts(fn, "\\\"")
              elsif string[i] = '\'' then --Single quote
                 puts(fn, "\\\'")
              else
                 --Just write it
                 puts(fn, string[i])
              end if
          end for

          --Write the ending '"'
          puts(fn, '\"')
end procedure
