---------------------------------------------------------------
--  Created by Lucius L. Hilley III
--  5/15/2002  All rights ignored. 8*)
--  http://www.hilleyonline.com
---------------------------------------------------------------
--  Thanks to:
--    Chris Bensler - bensler@mail.com
--      Addition ideas:
--        push_range(), pop_range(), pull_range(), set_stack()
--        clear_stack(), delete_stack(), delete_all_stacks()
--    Kat
--      Addition ideas:
--        fifo(), lifo(), stack_dir()
---------------------------------------------------------------

--  future: set_stack_range(),

--
--  *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING ***
--    In version 2.0 and newer
--    stack_name() has been renamed to stack_exist()
--  AND
--    Following routines no longer accept stack_name:
--    push(), pop(), pull(), stack_size()

--  Version 2.4:
--      Revisions that effect:
--    copy_stack(), copy_stack_range(), delete_stack(),
--    delete_stack_range(), rename_stack()
--      Added:
--    delete_range() -- this is same as delete_stack_range()

--  Version 2.3 added the follwing:
--    copy_stack(), copy_stack_range(), rename_stack()

--  Version 2.2 added the follwing:
--    clear_stack(), delete_stack(), delete_stack_range(),
--    delete_all_stacks()

--  Version 2.2 added the follwing:
--    clear_stack(), delete_stack(), delete_stack_range(),
--    delete_all_stacks()

--  Version 2.11:
--    corrected pull_range() bug that caused it to actually pop_range() 8*)

--  Version 2.1 added the following:
--    features:   range pushing, popping and pulling.
--    functions:  pop_range(), pull_range()
--    procedures: push_range()

--  Version 2.0 added the following:
--    features:   stack direction
--    functions:  stack_dir()
--    procedures: fifo(), lifo(), set_stack()

--  procedures:
--
--    set_stack(stack_name) --> sets current stack, creates new stack
--    delete_all_stacks() --> deletes all stacks
--    delete
--    push(value) --> push value onto stack
--    push_range(values) --> push sequence of values onto stack
--    fifo()  --> set stack direction to (F)irst (I)n (F)irst (O)ut
--    lifo()  --> set stack direction to (L)ast  (I)n (F)irst (O)ut

--  functions:
--    pop() --> get value from stack based on direction and remove it from stack
--    pop_range(a) --> a is an atom specifing the number of values to get from
--                   the stack based on direction and remove them from stack
--    pull() --> get value from stack based on direction
--    pull_range(a) --> a is an atom specifing the number of values to get from
--                   the stack based on direction
--    stack_size() --> return the current stacks size
--    stack_exist(stack_name) --> returns 0 if stack_name hasn't been created
--    stack_names() --> return list of stack_names
--    stack_dir() --> returns current direction, FIFO or LIFO

global constant
  VERSION = "2.4",
  FIFO = 0,
  LIFO = 1

--Cs, Sn, Sv, Si, Sd, Sh
--current, name, value, index, direction, history

integer
  Cs --> current stack
sequence
  Sn,   --> stack names
  Sv,   --> stack values
  Si,   --> stack indices
  Sd,   --> stack direction
  Sh    --> stach history

global procedure delete_all_stacks()
  Cs = 0
  Sv = {}
  Sh = {0}
  Sn = {}
  Si = {}
  Sd = {}
end procedure

global procedure delete_stack()
  integer ls, f

  ls = length(Sn)
  Sn = Sn[1..Cs - 1] & Sn[Cs + 1..ls]
  Sv = Sv[1..Cs - 1] & Sv[Cs + 1..ls]
  Si = Si[1..Cs - 1] & Si[Cs + 1..ls]
  Sd = Sd[1..Cs - 1] & Sd[Cs + 1..ls]

  f = find(Cs, Sh)
  Sh = Sh[1..f - 1] & Sh[f + 1..length(Sh)]
  ls = length(Sh)
  if Sh[ls] then
    Cs = Sh[ls]
  else
    Cs = Sh[1]
    Sh = Sh[2..ls] & Sh[1]
  end if
end procedure

global procedure clear_stack()
  Sv[Cs] = {}
  Si[Cs] = 0
end procedure

global procedure set_stack(object Name)
  integer f

  Cs = find(Name, Sn)
  Sh &= Cs
  if (Cs = 0) then  -- create missing stack
    Sn &= {Name}
    Sv &= {{}}
    Si &= 0
    Sd &= LIFO
    Cs = length(Sn)
  else
    f = find(Cs, Sh)
    Sh = Sh[1..f-1] & Sh[f+1..length(Sh)]
  end if
end procedure

global procedure delete_stack_range(sequence s)
  -- NOTE: dirty method of deleting a range
  for A = 1 to length(s) do
    set_stack(s[A])
    delete_stack()
  end for
end procedure

global procedure delete_range(sequence s)
  -- NOTE: dirty method of deleting a range
  for A = 1 to length(s) do
    set_stack(s[A])
    delete_stack()
  end for
end procedure

global procedure rename_stack(object Name)
  Sn[Cs] = Name
end procedure

global procedure copy_stack(object Name)
  integer f

--Cs, Sn, Sv, Si, Sd, Sh
  f = find(Name, Sn)
  if (f) then -- exist copy over
    Sn[f] = Sn[Cs]
    Sv[f] = Sv[Cs]
    Si[f] = Si[Cs]
    Sd[f] = Sd[Cs]
    --Already in history
  else -- not there create new copy
    Sn &= {Sn[Cs]}
    Sv &= {Sv[Cs]}
    Si &=  Si[Cs]
    Sd &=  Sd[Cs]
    --never set so push to front of history.
    Sh = f & Sh
  end if
end procedure

global procedure copy_stack_range(sequence Names)

--Cs, Sn, Sv, Si, Sd, Sh
  for A = length(Names) to 1 by -1 do
    copy_stack(Names[A])
  end for
end procedure

global procedure push(object x)
  Si[Cs] += 1
  Sv[Cs] &= {x}
end procedure

global procedure push_range(object x)
  Si[Cs] += length(x)
  Sv[Cs] &= x
end procedure

global function pop()
  object Popped

  if FIFO = Sd[Cs] then
    Popped = Sv[Cs][1]
    Sv[Cs] = Sv[Cs][2..Si[Cs]]
    Si[Cs] -= 1
  else
    Popped = Sv[Cs][Si[Cs]]
    Si[Cs] -= 1
    Sv[Cs] = Sv[Cs][1..Si[Cs]]
  end if

  return Popped
end function

global function pop_range(atom a)
  sequence Popped

  if (a = -1) or (a >= Si[Cs]) then -- pop() entire stack

    if FIFO = Sd[Cs] then
      Popped = Sv[Cs]
      Sv[Cs] = {}
      Si[Cs] = 0
    else
      -- NOTE: LLH: Optimize this later using inline of reverse()
      Popped = repeat(0, Si[Cs])
      for A = 1 to Si[Cs] do
        Popped[A] = pop()
      end for
    end if

  elsif (a > 0) then  -- pop() portion of stack

    if FIFO = Sd[Cs] then
      Popped = Sv[Cs][1..a]
      Sv[Cs] = Sv[a + 1..Si[Cs]]
      Si[Cs] -= a
    else
      -- NOTE: LLH: Optimize this later using inline of reverse()
      Popped = repeat(0, a)
      for A = 1 to a do
        Popped[A] = pop()
      end for
    end if

  end if

  return Popped
end function

global function pull()
  if FIFO = Sd[Cs] then
    return Sv[Cs][1]
  else
    return Sv[Cs][Si[Cs]]
  end if
end function

global function pull_range(atom a)
  sequence Popped, State

  State = {Si[Cs], Sv[Cs]}
  if (a = -1) or (a >= Si[Cs]) then -- pull() entire stack

    if FIFO = Sd[Cs] then
      Popped = Sv[Cs]
    else
      -- NOTE: LLH: Optimize this later using inline of reverse()
      Popped = repeat(0, Si[Cs])
      for A = 1 to Si[Cs] do
        Popped[A] = pop()
      end for
      --NOTE: popped it off.  must push it back on. :( -- Clever way.
      Si[Cs] = State[1]
      Sv[Cs] = State[2]
    end if

  elsif (a > 0) then  -- pop() portion of stack

    if FIFO = Sd[Cs] then
      Popped = Sv[Cs][1..a]
    else
      -- NOTE: LLH: Optimize this later using inline of reverse()
      Popped = repeat(0, a)
      for A = 1 to a do
        Popped[A] = pop()
      end for
      --NOTE: popped it off.  must push it back on. :( -- Clever way.
      Si[Cs] = State[1]
      Sv[Cs] = State[2]
    end if

  end if

  return Popped
end function

global procedure fifo()
  Sd[Cs] = FIFO
end procedure

global procedure lifo()
  Sd[Cs] = LIFO
end procedure

global function stack_size()
  return Si[Cs]
end function

global function stack_exist(object Name)
  return find(Name, Sn)
end function

global function stack_names()
  return Sn
end function

global function stack_dir()
  return Sd[Cs]
end function

delete_all_stacks() --> this doubles as initialize stacks

