--
--	Euphoria 2.4 QuickSort Algoritm
--
--	Implemented, but not written, by Greg Haberek <ghaberek@gmail.com>
--
--	Much faster than the typical shell sorting method used in sort.e,
--	the QuickSort algoritm may be found almost anywhere on the Internet
--	just by searching for the term 'QuickSort'. I put this algorithm
--	together from several examples I found, including a Python script,
--	a C library, and a PowerPoint presentation, amongst others...
--
--	QuickSort works best on large arrays of very random values. For small
--	arrays, or very similar values, use the standard shell sort, because
--	it may be faster in some cases. Its best to test both algorithms on
--	some test data to determine the fastest algorithm. This version of
--	QuickSort uses compare() so it is safe for all objects.
--
--	Usage:
--		include qsort.e
--		s2 = qsort( s1 )
--

sequence a  -- the array of values

function partition( integer b, integer t )  -- bottom, top
object p
integer i, j, done

    p = a[t]    -- the pivot object
    i = b-1     -- 'up' value
    j = t       -- 'down' value

    done = 0
    while not done do

        while not done do
            -- work up the list
            -- until we find a value
            -- greater than p
            i = i+1

            if i =  j then
                done = 1
                exit
            end if

            if compare( a[i], p ) = 1 then  -- a[i] > p
                -- swap the values
                a[j] = a[i]
                exit
            end if

        end while

        while not done do
            -- work down the list
            -- until we find a value
            -- less than p
            j = j-1

            if j = i then
                done = 1
                exit
            end if

            if compare( a[j], p ) = -1 then -- a[j] < p
                -- swap the values
                a[i] = a[j]
                exit
            end if
            
        end while

    end while

    -- put the pivot back
    -- in its correct spot
    a[j] = p
    
    return j
end function

procedure quicksort( integer b, integer t ) -- bottom, top
integer s   -- split

    if b < t then
        -- find the pivot point
        s = partition(b, t)
        
        -- sort each half of the data
        quicksort(b, s-1)
        quicksort(s+1, t)
    end if

end procedure

global function qsort( sequence x )

    a = x
    quicksort( 1, length(a) )

    return a
end function