-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! Texture Library                               !--
--! Version 0.5.1                                 !--
--!-----------------------------------------------!--
--! Working Beta                                  !--
--! Date: 25th August 2003                        !--
--! Daniel McGrath                                !--
--!-----------------------------------------------!--

procedure Clear_Mem(atom Addr)
    atom Len

    Len = Read_x() * Read_y()
    for i = 1 to Len do
        poke(Addr, {0, 0, 0})
        Addr += 3
    end for
end procedure

function Perlin_Colour_2D(integer x, integer y)
    if Read_NSO() then
        return NS_Perlin_Noise_2D(x, y) * 127 + 127
    else
        return Perlin_Noise_2D(x, y) * 127 + 127
    end if
end function

function Perlin_Texture_Layer()
    sequence Tmp
    atom Current_Mem_Loc, mem_loc, Len, x, y, CCID

    x = Read_x()
    y = Read_y()
    CCID = Read_CCID()
    Len = x * y

    mem_loc = allocate(Len * 3)
    if mem_loc = -1 then
        return -1
    end if
    Clear_Mem(mem_loc)

    Current_Mem_Loc = mem_loc
    for i = 1 to y do
        for j = 1 to x do
            Tmp = call_func(CCID, {floor(Perlin_Colour_2D(i, j))})
            poke(Current_Mem_Loc, Tmp)
            Current_Mem_Loc += 3
        end for
    end for

    return mem_loc
end function

function Combine_Perlin_Texture_Layers(sequence mem_locs)
    sequence total, Amp
    atom cbmp, Len, Current_Mem_Loc, ColourAddr, x, y, SIZE, PSAID

    x = Read_x()
    y = Read_y()
    PSAID = Read_SAID()

    SIZE = x * y

    cbmp = allocate(SIZE * 3)
    if cbmp = -1 then
        return -1
    end if
    Clear_Mem(cbmp)

    Len  = length(mem_locs)
    Amp  = call_func(PSAID, {Len})

    ColourAddr = 0
    Current_Mem_Loc = cbmp

    for i = 1 to SIZE do
        total = {0, 0, 0}

        for k = 1 to Len do
            total[1] += peek(mem_locs[k] + ColourAddr) * Amp[k]
            total[2] += peek(mem_locs[k] + ColourAddr + 1) * Amp[k]
            total[3] += peek(mem_locs[k] + ColourAddr + 2) * Amp[k]
        end for

        poke(Current_Mem_Loc, total)
        ColourAddr += 3
        Current_Mem_Loc += 3
     end for

     return cbmp
end function

global function Create_Image(sequence Sizes, sequence Amp_ID)
    sequence hbmp
    atom Len, cbmp
    integer PSAID

    PSAID = Read_SAID()

    Len = length(Sizes)
    Sizes -= 1

    -- Safety check
    for i = 1 to Len do
        if Sizes[i] < 0 then
            Sizes[i] = 0
        end if
    end for

    if length(Amp_ID) != 0 then
        if Set_SAID(Amp_ID) then end if
    end if

    -- Setup memory for all layers
    hbmp = repeat(0, Len)

    -- Produce Perlin layers
    for i = 1 to Len do
        PNL_RandList = Noise_Layer_2D(Sizes[i])
        hbmp[i] = Perlin_Texture_Layer()
    end for

    -- Produce combined Perlin image
    cbmp = Combine_Perlin_Texture_Layers(hbmp)

    -- Clean up
    if length(Amp_ID) != 0 then
        if Set_SAID(PSAID) then end if
    end if
    for i = 1 to Len do
        free(hbmp[i])
    end for
    
    return cbmp
end function