-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! Support Library                               !--
--! Version 0.5.1                                 !--
--!-----------------------------------------------!--
--! Working Beta                                  !--
--! Date: 26th August 2003                        !--
--! Daniel McGrath                                !--
--!-----------------------------------------------!--
--! Provides general support functions that are   !--
--! used by the function vars such as             !--
--! PNL_CCID(Colour Function) and PNL_SAID.       !--
--! A Large variety of Colour effects have been   !--
--! Provided so you can see what images can be    !--
--! produced with the PNL Library.                !--
-----------------------------------------------------

------------------------------------------------------------------------------------------
---------------------------------- AMP FUNCTIONS (SAID) ----------------------------------
------------------------------------------------------------------------------------------

-- Scaled Halving Layers
global function PNL_S_AMP(atom Layers)
    sequence Amp
    atom Tmp

    Amp = {}
    Tmp = 0
    for i = 1 to Layers do
        Amp &= power(0.5, i)
        Tmp += Amp[i]
    end for

    Tmp = 1/Tmp

    return Amp*Tmp
end function

-- Scaled 4/5th'ing Layers
global function PNL_F_AMP(atom Layers)
    sequence Amp
    atom Tmp

    Amp = {}
    Tmp = 0
    for i = 1 to Layers do
        Amp &= power(0.8, i)
        Tmp += Amp[i]
    end for

    Tmp = 1/Tmp

    return Amp*Tmp

end function

-- Scaled Equal Layers
global function PNL_A_AMP(atom Layers)
    return repeat(1 / Layers, Layers)
end function

-- Reverse Amp'ed Layer({1}, {1/3, 2/3}, {1/6, 2/6, 3/6}, etc)
global function PNL_R_AMP(atom Layers)
    sequence Amp
    atom Tmp

    Amp = {}
    Tmp = 0
    for i = 1 to Layers do
        Amp &= i
        Tmp += Amp[i]
    end for

    Tmp = 1/Tmp

    return Amp*Tmp
end function

------------------------------------------------------------------------------------------
------------------------------ end of AMP FUNCTIONS (SAID) -------------------------------
------------------------------------------------------------------------------------------

------------------------------------------------------------------------------------------
-------------------------------- COLOUR FUNCTIONS (CCID) ---------------------------------
------------------------------------------------------------------------------------------

-- Grey Scale
global function PNL_Color_Grey(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {PN_Value, PN_Value, PN_Value}
end function

-- Grey Scale > 128
global function PNL_Color_LGrey(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    PN_Value = floor(PN_Value * .5 + 128)

    return {PN_Value, PN_Value, PN_Value}
end function


-- Only Red
global function PNL_Color_Red(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {PN_Value, 0, 0}
end function

-- Only Green
global function PNL_Color_Green(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {0, PN_Value, 0}
end function

-- Only Blue
global function PNL_Color_Blue(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {0, 0, PN_Value}
end function

-- Only Red > 63
global function PNL_Color_HLRed(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {floor(PN_Value * .75 + 64), 0, 0}
end function

-- Only Green > 63
global function PNL_Color_HLGreen(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {0, floor(PN_Value * .75 + 64), 0}
end function

-- Only Blue > 63
global function PNL_Color_HLBlue(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {0, 0, floor(PN_Value * .75 + 64)}
end function


-- Only Red > 128
global function PNL_Color_LRed(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {floor(PN_Value * .5 + 128), 0, 0}
end function

-- Only Green > 128
global function PNL_Color_LGreen(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {0, floor(PN_Value * .5 + 128), 0}
end function

-- Only Blue > 128
global function PNL_Color_LBlue(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    return {0, 0, floor(PN_Value * .5 + 128)}
end function

-- Red <=> White. All > 63
global function PNL_Color_RedClouds(atom PN_Value)
    atom Second

    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    Second = floor(PN_Value * .75)
    PN_Value = Second + 64
    Second = 255-Second

    if PN_Value < Second then
        PN_Value = Second
    end if

    return {PN_Value, Second, Second}
end function

-- Green <=> White. All > 63
global function PNL_Color_GreenClouds(atom PN_Value)
    atom Second

    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    Second = floor(PN_Value * .75)
    PN_Value = Second + 64
    Second = 255-Second

    if PN_Value < Second then
        PN_Value = Second
    end if

    return {Second, PN_Value, Second}
end function

-- Blue <=> White. All > 63
global function PNL_Color_BlueClouds(atom PN_Value)
    atom Second

    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    Second = floor(PN_Value * .75)
    PN_Value = Second + 64
    Second = 255-Second

    if PN_Value < Second then
        PN_Value = Second
    end if

    return {Second, Second, PN_Value}
end function

-- White <=> Red |=| White <=> Blue. Non blended joined, best not used with PostPerlinColour
global function PNL_Color_Multi(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_RedClouds(PN_Value * 2)
    else
        return PNL_Color_BlueClouds((PN_Value - 128) * 2)
    end if
end function

-----------
----------- Colour functions after this point are 'smoothest' if used on 
----------- Greyscale textures with PostPerlinColour()
-----------

-- Red <=> White <=> White <=> Blue. All > 63
global function PNL_Color_Multi2(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_RedClouds((128 - PN_Value) * 2)
    else
        return PNL_Color_BlueClouds((PN_Value - 128) * 2)
    end if
end function


-- Green <=> Green <=> White. All > 63
global function PNL_Color_Multi3(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_HLGreen(PN_Value * 2)
    else
        return PNL_Color_GreenClouds((255 - PN_Value) * 2)
    end if
end function

-- Blue <=> Blue <=> White. All > 63
global function PNL_Color_Multi4(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_HLBlue(PN_Value * 2)
    else
        return PNL_Color_BlueClouds((255 - PN_Value) * 2)
    end if
end function


-- Blue <=> Blue <=> White <=> White <=> Green <=> Green. All > 63
global function PNL_Color_Lots(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 64 then
        return PNL_Color_HLBlue(PN_Value * 4)
    elsif PN_Value > 63 and PN_Value < 128 then
        return PNL_Color_BlueClouds((128 - PN_Value) * 4)
    elsif PN_Value > 127 and PN_Value < 191 then
        return PNL_Color_GreenClouds((PN_Value - 128) * 4)
    else
        return PNL_Color_HLGreen((255 - PN_Value) * 4)
    end if
end function


-- Green <=> Blue <=> Black. Green > 63
global function PNL_Color_Land(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_HLGreen(PN_Value * 2)
    else
        return PNL_Color_Blue((255 - PN_Value) * 2)
    end if
end function

--------------------------------------
--------**********************--------
--------** Electric Effects **--------
--------**********************--------
--------------------------------------

-- Tight Grey Scale
function PNL_Color_TGrey(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value > 191 then
        PN_Value -= 192
        PN_Value *= 4
    else
        PN_Value = 0
    end if    

    return {PN_Value, PN_Value, PN_Value}
end function

-- Tight Red
function PNL_Color_TRed(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value > 191 then
        PN_Value -= 192
        PN_Value *= 4
    else
        PN_Value = 0
    end if    

    return {PN_Value, 0, 0}
end function

-- Tight Green
function PNL_Color_TGreen(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value > 191 then
        PN_Value -= 192
        PN_Value *= 4
    else
        PN_Value = 0
    end if    

    return {0, PN_Value, 0}
end function

-- Tight Blue
function PNL_Color_TBlue(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value > 191 then
        PN_Value -= 192
        PN_Value *= 4
    else
        PN_Value = 0
    end if    

    return {0, 0, PN_Value}
end function

global function PNL_Color_WhiteElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_TGrey(PN_Value * 2)
    else
        return PNL_Color_TGrey((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_RedElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_TRed(PN_Value * 2)
    else
        return PNL_Color_TRed((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_GreenElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_TGreen(PN_Value * 2)
    else
        return PNL_Color_TGreen((255 - PN_Value) * 2)
    end if
end function


global function PNL_Color_BlueElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_TBlue(PN_Value * 2)
    else
        return PNL_Color_TBlue((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_MidWhiteElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_WhiteElectric(PN_Value * 2)
    else
        return PNL_Color_WhiteElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_MidRedElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_RedElectric(PN_Value * 2)
    else
        return PNL_Color_RedElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_MidGreenElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_GreenElectric(PN_Value * 2)
    else
        return PNL_Color_GreenElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_MidBlueElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_BlueElectric(PN_Value * 2)
    else
        return PNL_Color_BlueElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_WhiteRedElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_MidWhiteElectric(PN_Value * 2)
    else
        return PNL_Color_MidRedElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_WhiteGreenElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_MidWhiteElectric(PN_Value * 2)
    else
        return PNL_Color_MidGreenElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_WhiteBlueElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_MidWhiteElectric(PN_Value * 2)
    else
        return PNL_Color_MidBlueElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_RedGreenElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_MidRedElectric(PN_Value * 2)
    else
        return PNL_Color_MidGreenElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_RedBlueElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_MidRedElectric(PN_Value * 2)
    else
        return PNL_Color_MidBlueElectric((255 - PN_Value) * 2)
    end if
end function

global function PNL_Color_GreenBlueElectric(atom PN_Value)
    if PN_Value > 255 then
        PN_Value = 255
    elsif PN_Value < 0 then
        PN_Value = 0
    end if

    if PN_Value < 128 then
        return PNL_Color_MidGreenElectric(PN_Value * 2)
    else
        return PNL_Color_MidBlueElectric((255 - PN_Value) * 2)
    end if
end function

------------------------------------------------------------------------------------------
----------------------------- end of COLOUR FUNCTIONS (CCID) -----------------------------
------------------------------------------------------------------------------------------