-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! Sound Library                                 !--
--! Version 0.5.1                                 !--
--!-----------------------------------------------!--
--! Working Beta                                  !--
--! Date: 27th August 2003                        !--
--! Daniel McGrath                                !--
-----------------------------------------------------

function Make_Perlin_Wave_Layer()
    sequence WaveForm

    WaveForm = repeat(0, Read_x())

    if Read_NSO() then
        for i = 1 to Read_x() do
            WaveForm[i] = Ns_Perlin_Noise_1D(i)
        end for
    else
        for i = 1 to Read_x() do
            WaveForm[i] = Perlin_Noise_1D(i)
        end for
    end if

    return WaveForm
end function

function Combine_Perlin_Sound_Layers(sequence Layers)
    sequence WaveForm, Amp
    integer Len

    Len = length(Layers)
    Amp = call_func(Read_SAID(), {Len})

    WaveForm = repeat(0, Read_x())

    for i = 1 to Read_X() do
        for j = 1 to Len do
            WaveForm[i] += Layers[j][i] * Amp[j]
        end for
    end for

    return WaveForm
end function

-- Use this function to produce the wave form.
global function Create_Perlin_Wave(sequence Gaps)
    sequence Layers
    atom Len

    Len = length(Gaps)
    Layers = repeat(0, Len)
    Gaps -= 1

    -- Safety check
    for i = 1 to Len do
        if Gaps[i] < 0 then
            Gaps[i] = 0
        end if
    end for

    for i = 1 to Len do
        PNL_RandList = Alt_Noise_Layer_1D(Gaps[i])
        Layers[i] = Make_Perlin_Wave_Layer()
    end for

    return Combine_Perlin_Sound_Layers(Layers)
end function