-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! Line Library                                  !--
--! Version 0.5.2                                 !--
--!-----------------------------------------------!--
--! Working Beta                                  !--
--! Date: 26th August 2003                        !--
--! Daniel McGrath                                !--
--!-----------------------------------------------!--
--! This library is for use when creating 1D      !--
--! lines with Perlin Noise. Uses include         !--
--! 'Sketchy' Interfaces('Hand-drawn' appearance) !--
-----------------------------------------------------

function Combine_Perlin_Line_Layers(sequence Layers)
    sequence Line, Amp
    integer Len, x

    Len = length(Layers)
    Amp = call_func(Read_SAID() , {Len})
    x = Read_x()

    Line = repeat(0, x)

    for i = 1 to x do
        for j = 1 to Len do
            Line[i] += Layers[j][i] * Amp[j]
        end for
    end for

    return Line
end function

function Perlin_Line_Layer()
    sequence Line
    atom x

    x = Read_x()
    Line = repeat(0, x)

    if Read_NSO() then
        for i = 1 to x do
            Line[i] = NS_Perlin_Noise_1D(i)
        end for
    else
        for i = 1 to x do
            Line[i] = Perlin_Noise_1D(i)
        end for
    end if

    return Line
end function

-- Use this function to produce the Line.
global function Create_Perlin_Line(sequence Gaps)
    sequence Layers
    atom Len

    Len = length(Gaps)
    Layers = repeat(0, Len)
    Gaps -= 1
    -- Safety check
    for i = 1 to Len do
        if Gaps[i] < 0 then
            Gaps[i] = 0
        end if
    end for


    for i = 1 to Len do
        PNL_RandList = Noise_Layer_1D(Gaps[i])
        Layers[i] = Perlin_Line_Layer()
    end for

    return Combine_Perlin_Line_Layers(Layers)
end function