-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! 3D Texture Library                            !--
--! Version 0.5.1                                 !--
--!-----------------------------------------------!--
--! Working Beta                                  !--
--! Date: 25th August 2003                        !--
--! Daniel McGrath                                !--
--!-----------------------------------------------!--
--! Contains code so you can produce 3D textures  !--
--! These can be used as animated 2D textures or  !--
--! to seamlessly texture a 3D object of any      !--
--! shape.                                        !--
-----------------------------------------------------

function Perlin_Colour_3D(integer x, integer y, integer z)
    if Read_NSO() then
        return NS_Perlin_Noise_3D(x, y, z) * 127 + 127
    else
        return Perlin_Noise_3D(x, y, z) * 127 + 127
    end if
end function

function Make_Perlin_3DTexture_Layer()
    atom mem_loc
    integer x, y, z, Len, Current_Mem_Loc, CCID

    CCID = Read_CCID()
    x = Read_x()
    y = Read_y()
    z = Read_z()
    Len = x * y * z

    mem_loc = allocate(Len * 3)
    if mem_loc = -1 then
        return -1
    end if
    Current_Mem_Loc = mem_loc

    for m = 1 to z do
        for i = 1 to y do
            for j = 1 to x do
                poke(Current_Mem_Loc, call_func(CCID, {floor(Perlin_Colour_3D(i, j, m))}))
                Current_Mem_Loc += 3
            end for
        end for
    end for

    return mem_loc
end function

function Combine_Perlin_3DTexture_Layers(sequence hbmp)
    sequence total, Amp
    atom Len, x, y, z, SIZE, Current_Mem_Loc, cbmp

    Len = length(hbmp)
    Amp = call_func(Read_SAID(), {Len})

    x = Read_x()
    y = Read_y()
    z = Read_z()
    SIZE = x * y * z
    cbmp = allocate(SIZE * 3)
    if cbmp = -1 then
        return -1
    end if	

    Current_Mem_Loc = cbmp
    for m = 0 to SIZE - 1 by 3 do
        total = {0,0,0}
        for k = 1 to Len do
            total[1] += peek(hbmp[k] + m) * Amp[k]
            total[2] += peek(hbmp[k] + m + 1) * Amp[k]
            total[3] += peek(hbmp[k] + m + 2) * Amp[k]
        end for
        poke(Current_Mem_Loc, floor(total/3))
        Current_Mem_Loc += 3
    end for

    return cbmp
end function

global function Create_3DImage(sequence Sizes, sequence Amp_ID)
    sequence hbmp
    atom Len, cbmp
    integer SAID

    Len = length(Sizes)
    Sizes -= 1

    -- Safety check
    for i = 1 to Len do
        if Sizes[i] < 1 then
            Sizes[i] = 1
        end if
    end for

    if length(Amp_ID) != 0 then
        SAID = Read_SAID()
        if Set_SAID(Amp_ID) then end if
    end if

    hbmp = repeat(0, Len)

    -- Produce Perlin layers
    for i = 1 to Len do
        PNL_RandList = Noise_Layer_3D(Sizes[i])
        hbmp[i] = Make_Perlin_3DTexture_Layer()
        if hbmp[i] = -1 then
            return -1
        end if
    end for

    -- Produce combined Perlin image
    cbmp = Combine_Perlin_3DTexture_Layers(hbmp)

    -- Clean up
    if length(Amp_ID) != 0 then
        if Set_SAID(SAID) then end if
    end if
    for i = 1 to length(hbmp) do
        free(hbmp[i])
    end for
    
    return cbmp
end function