-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! Graphic Tools Library                         !--
--! Version 0.5.1                                 !--
--!-----------------------------------------------!--
--! Date: 26th August 2003                        !--
--! Daniel McGrath                                !--
--!-----------------------------------------------!--
--! A collection of some basic functions you can  !--
--! use to manipulate the textures produced.      !--
--! If you think there is a key function that     !--
--! useful, tell me and I'll see what I can do.   !--
-----------------------------------------------------

function modulo(atom a, atom b)
    atom c, d

    c = a/b
    d = floor(c)
    c = c-d

    return c * b
end function


-- Combines the 3 seperate RGB channels into one bmp
global function Combine_RGB(atom rbmp, atom gbmp, atom bbmp)
    sequence Colour
    atom cbmp, x, y, Len

    x = Read_x()
    y = Read_y()

    Len = x * y * 3

    Colour = {0, 0, 0}
    cbmp = allocate(Len)

    for i = 0 to Len -1 by 3 do
        poke(cbmp + i, peek(rbmp + i))
        poke(cbmp + i + 1, peek(gbmp + i + 1))
        poke(cbmp + i + 2, peek(bbmp + i + 2))
    end for

    return cbmp
end function

-- Merges 2 images depending on a mask bmp
global function MergeImages(atom mem1, atom mem2, atom mem3)
    atom a, b, x, y, Len, mem_bmp

    b = 1 / 255
    x = Read_x()
    y = Read_y()
    Len = x * y * 3
    mem_bmp = allocate(Len)
    if mem_bmp < 1 then
        return -1
    end if
    
    for i = 0 to Len - 1 do
        a = peek(mem2 + i)
        poke(mem_bmp + i, floor(peek(mem1 + i) * (a * b) + peek(mem3 + i) * ((255-a) * b)))
    end for

    return mem_bmp
end function

-- Maximises a colour channels range
global procedure MaxColourChannel(atom mem_loc, integer a)
    atom Min, Max, x, y, Len, Temp

    x = Read_x()
    y = Read_y()
    Len = x * y * 3
    Min = 255
    Max = 0

    for i = 0 to Len - 1 by 3 do
        Temp = peek(mem_loc + i + a)
        if Temp > Max then
            Max = Temp
        elsif Temp < Min then
            Min = Temp
        end if
    end for

    if Min < Max then
        Max = Max - Min
        Max = 255/Max
        for i = 0 to Len - 1 by 3 do
            poke(mem_loc + i + a, floor((peek(mem_loc + i + a) - Min) * Max))
        end for
    end if
end procedure

-- Maximises all channels as if they were one
global procedure MaxColourRange(atom mem_loc)
    atom Min, Max, x, y, Len, Temp

    x = Read_x()
    y = Read_y()
    Len = x * y * 3
    Min = 255
    Max = 0

    for i = 0 to Len - 1 do
        Temp = peek(mem_loc + i)
        if Temp > Max then
            Max = Temp
        elsif Temp < Min then
            Min = Temp
        end if
    end for

    if Min < Max then
        Max = Max - Min
        Max = 255/Max
        for i = 0 to Len - 1 do
            poke(mem_loc + i, floor((peek(mem_loc + i) - Min) * Max))
        end for
    end if
end procedure

global procedure Convert2GreyScale(atom mem_loc)
    atom total, Len

    Len = Read_x() * Read_y()

    for i = 1 to Len do
        total = floor((peek(mem_loc) + peek(mem_loc + 1) + peek(mem_loc + 2)) / 3)
        poke(mem_loc, {total, total, total})
        mem_loc += 3
    end for
end procedure

-- a is the source channel, b is destination channel
-- NOTE: All other channels are cleared
global procedure ChangeColourChannel(atom mem_loc, integer a, integer b)
    sequence Colour
    atom Len

    Len = Read_x() * Read_y()

    for i = 1 to Len do
        Colour = {0, 0, 0}
        Colour[b+1] = peek(mem_loc + a)

        poke(mem_loc, Colour)
        mem_loc += 3
    end for
end procedure

global procedure ReverseColourChannel(atom mem_loc, integer a)
    atom Len

    Len = Read_x() * Read_y()

    for i = 1 to Len do
        if a = 0 then
            poke(mem_loc, 255 - peek(mem_loc))
        elsif a = 1 then
            poke(mem_loc + 1, 255 - peek(mem_loc + 1))
        else
            poke(mem_loc + 2, 255 - peek(mem_loc + 2))
        end if
        mem_loc += 3
    end for
end procedure

global procedure PostPerlinColour(atom mem_loc)
    atom Len, CCID

    Len = Read_x() * Read_y()
    CCID = Read_CCID()

    for i = 1 to Len do
        poke(mem_loc, call_func(CCID, {peek(mem_loc)}))
        mem_loc += 3
    end for
end procedure