-----------------------------------------------------
--! Perlin Noise Lib                              !--
--! Version 0.5.1                                 !--
--! 3DT File Format Library                       !--
--! Version 0.2.1                                 !--
--!-----------------------------------------------!--
--! Format Version 1.0 supported                  !--
--! Date: 26th August 2003                        !--
--! Daniel McGrath                                !--
--!-----------------------------------------------!--
--! Provides some basic functions to allow you to !--
--! Use my 3DT format to store 3D Perlin Textures !--
--! May at a later date support optional          !--
--! compression.                                  !--
-----------------------------------------------------


include Lib\GrapTools.e

global constant NoA_3DT  = 0,
                GenA_3DT = 1,
                ChanA_3DT = 2

global function GetFile(sequence FileName)
    atom Handle
    integer Byte, Flag
    sequence Data

    Data = {}
    Flag = 1

    Handle = open(FileName, "rb")
    if Handle = -1 then return {-1} end if

    while Flag do
        Byte = getc(Handle)
        if Byte = -1 then
            Flag = 0
        else
            Data &= Byte
        end if
    end while

    close(Handle)

    return Data
end function

global function SaveFile(sequence FileName, sequence Data)
    atom Handle

    Handle = open(FileName, "wb")
    if Handle = -1 then return -1 end if

    puts(Handle, Data)
    close(Handle)

    return 0
end function

function Header3DT(atom Selector, atom height, atom width, atom depth, sequence RGB)
    sequence Header, Temp
    atom Tmp

    -- Format and revision format
    Header = "3DT" & 1

    -- Texture height
    Tmp = height/256
    Header &= floor(Tmp)
    Tmp = (Tmp - floor(Tmp)) * 256
    Header &= Tmp

    -- Texture width
    Tmp = width/256
    Header &= floor(Tmp)
    Tmp = (Tmp - floor(Tmp)) * 256
    Header &= Tmp

    -- Texture Depth
    Tmp = depth/256
    Header &= floor(Tmp)
    Tmp = (Tmp - floor(Tmp)) * 256
    Header &= Tmp
 
    -- Channel Selectors
    Temp = RGB * {1,2,4}
    Tmp = Temp[1] + Temp[2] + Temp[3]
    if Selector = GenA_3DT then
        Tmp += 8
    elsif Selector = ChanA_3DT then
        Tmp += 24
    end if
    Header &= Tmp
    return Header
end function

function ReadHeader(sequence Header)
    sequence ChanFlags
    atom x, y, z, toggle, Version
    if compare(Header[1..3], "3DT") then
        return {0}
    end if
    
    ChanFlags = {}
    Version = Header[4]
    x = Header[5] * 256 + Header[6]
    y = Header[7] * 256 + Header[8]
    z = Header[9] * 256 + Header[10]
    toggle = Header[11]

    if toggle > 127 then
        ChanFlags &= 1
        toggle -= 128
    else
        ChanFlags &= 0
    end if
    if toggle > 63 then
        ChanFlags &= 1
        toggle -= 63
    else
        ChanFlags &= 0
    end if
    if toggle > 31 then
        ChanFlags &= 1
        toggle -= 32
    else
        ChanFlags &= 0
    end if
    if toggle > 15 then
        ChanFlags &= 1
        toggle -= 16
    else
        ChanFlags &= 0
    end if
    if toggle > 7 then
        ChanFlags &= 1
        toggle -= 8
    else
        ChanFlags &= 0
    end if
    if toggle > 3 then
        ChanFlags &= 1
        toggle -= 4
    else
        ChanFlags &= 0
    end if
    if toggle > 1 then
        ChanFlags &= 1
        toggle -= 2
    else
        ChanFlags &= 0
    end if
    if toggle = 1 then
        ChanFlags &= 1
    else
        ChanFlags &= 0
    end if

    return {Version, x, y, z, ChanFlags}
end function

global function Save3DT(atom Selector, sequence BMPs, sequence RGB)
    sequence Header, Data
    atom x, y, z, Len

    x = Read_x()
    y = Read_y()
    z = Read_z()
    Len = x * y * z * 3

    Header = Header3DT(Selector, x, y, z, RGB)
    Data = {}

    for m = 0 to Len - 1 by 3 do
        if RGB[1] = 1 then
            Data &= peek(BMPs[1] + m)
        end if
        if RGB[2] = 1 then
            Data &= peek(BMPs[1] + m + 1)
        end if
        if RGB[3] = 1 then
            Data &= peek(BMPs[1] + m + 2)
        end if
        if Selector = GenA_3DT then
            Data &= peek(BMPs[2] + m/3)
        elsif Selector = ChanA_3DT then
            if RGB[1] = 1 then
                Data &= peek(BMPs[2] + m)
            end if
            if RGB[2] = 1 then
                Data &= peek(BMPs[2] + m + 1)
            end if
            if RGB[3] = 1 then
                Data &= peek(BMPs[2] + m + 2)
            end if
        end if
    end for

    return Header & Data
end function


global function Read3DT(sequence Data)
    sequence Header, Current1, Current2
    atom Posi, abmp, bbmp

    Header = ReadHeader(Data[1..11])

    if Header[1] != 1 then
        return {0}
    end if

    Posi = 12
    Current1 = 0
    Current2 = 0

        abmp = allocate(Header[2] * Header[3] * Header[4] * 3)
        if abmp = -1 then
            return {-1}
        end if
        if Header[5][5] = 1 then
            bbmp = allocate(Header[2] * Header[3] * Header[4])
            if bbmp = -1 then
                free(abmp)
                return {-1}
            end if
        else
            bbmp = allocate(Header[2] * Header[3] * Header[4] * 3)
            if bbmp = -1 then
                free(abmp)
                return {-1}
            end if
        end if
        for y = 0 to Header[2] * Header[3] * Header[4] do
            if Header[5][8] = 1 then
                poke(abmp + Current1, Data[Posi])
                Posi += 1
            else
                poke(abmp + Current1, 0)
            end if
            if Header[5][7] = 1 then
                poke(abmp + Current1 + 1, Data[Posi])
                Posi += 1
            else
                poke(abmp + Current1 + 1, 0)
            end if
            if Header[5][6] = 1 then
                poke(abmp + Current1 + 2, Data[Posi])
                Posi += 1
            else
                poke(abmp + Current1 + 2, 0)
            end if
            Current1 += 3
            if Header[5][5] = 1 then
                if Data[5][4] = 1 then
                    poke(bbmp + Current2, Data[Posi])
                    Current2 += 1
                else
                    if Header[5][8] = 1 then
                        poke(bbmp + Current2, Data[Posi])
                        Posi += 1
                    else
                       poke(bbmp + Current2, 0)
                    end if
                    if Header[5][7] = 1 then
                        poke(bbmp + Current2 + 1, Data[Posi])
                        Posi += 1
                    else
                       poke(bbmp + Current2 + 1, 0)
                    end if
                    if Header[5][6] = 1 then
                        poke(bbmp + Current2 + 2, Data[Posi])
                        Posi += 1
                    else
                        poke(bbmp + Current2 + 2, 0)
                    end if
                    Current2 += 3
                end if
            end if
        end for

    if Header[5][5] != 0 then
        return {Header[1], {abmp, bbmp}}
    else
        return {Header[1], {abmp}}
    end if
end function