-----------------------------------------------------------------------------
-- [Windows 95] File Handling - based on SPLIT.E                           --
-----------------------------------------------------------------------------
include dir95.e
include misc.e

global function exist(sequence filename)
    integer status

    status = open(filename, "rb")
    if status != -1 then
	close(status)
	return 1
    end if

    return 0
end function

--constant LINUX = 3
global constant inLinux = (platform() = LINUX)

integer temp
temp = '\\'
if inLinux then
    temp = '/'
end if

global constant Slash = temp

global function last_extension(sequence filename)
    integer pos
    pos = find('.', filename)
    if not pos then
	return ""
    end if
    while pos do
	filename = filename[pos+1..length(filename)]
	pos = find('.', filename)
    end while
    return '.' & filename
end function

global function is_long_filename(sequence filename)
    sequence ext
    integer pos

    if inLinux then return 1 end if
    if find(' ', filename) then return 1 end if

    -- could use last_extension, but this is faster
    ext = ""
    pos = find('.',filename)
    if pos then
	ext = filename[pos+1..length(filename)]
	filename = filename[1..pos-1]
    end if

    return
	pos = 1
	or find('.', ext)
	or length(filename) > 8
	or length(ext) > 3
    --end return

end function

global function is_long_pathname(sequence pathname)
    -- includes filename if present at end of pathname
    integer pos

    if inLinux then return 1 end if
    if find(' ', pathname) then return 1 end if

    pos = find(Slash, pathname)
    if not pos then
	return is_long_filename(pathname)
    end if
    pathname &= Slash

    while pos do
	pathname = pathname[pos+1..length(pathname)]
	pos = find(Slash, pathname)
	if pos and is_long_filename(pathname[1..pos-1]) then
	    return 1
	end if
    end while

    return 0
end function

global function lfndir(sequence pattern)
    if inLinux then
	return dir(pattern)
    end if
    return Dir95(pattern)
end function

global function lfnopen(sequence filename, sequence mode)
    integer handle
    if not length(mode) or not length(filename) then
	return -1
    end if

    if  not inLinux                 -- If we're in DOS/Windows,
    and mode[1] != 'r'              -- we're writing out (a, ab, w, wb),
    and not exist(filename)         -- the file doesn't exist,
    and is_long_filename(filename)  -- and it's a long filename
    then

	system("rem > \"" & filename & "\"", 2) -- force creation

    end if

    handle = open(filename, mode)
    return handle
end function

global function lfn_current_dir()
    object temp
    sequence short, long, split
    integer pos

    short = current_dir()
    if short[length(short)] != Slash then
	short &= Slash
    end if
    split = {}

    pos = find(Slash, short)
    while pos do
	split = append(split, short[1..pos-1]) -- remove the backslash
	short = short[pos+1..length(short)]
	pos = find(Slash, short)
    end while

    short = split[1]
    long = short & Slash

    if length(split) = 1 then
	return long
    end if

    if chdir(long) then end if
    long = short -- chop the Slash again

    for i = 2 to length(split) do

	temp = lfndir("*")
	for j = 1 to length(temp) do
	    if equal(temp[j][D_NAME], split[i]) then
		temp = temp[j][D_LONGNAME]
		exit
	    end if
	end for

	short &= Slash & split[i]
	long  &= Slash & temp

	if chdir(short) then end if

    end for

    return long
end function

global function lfnchdir(sequence directory)
    object temp
    temp = lfndir(directory)
    if integer(temp) then
	return 0
    end if
    return chdir(temp[1][D_NAME])
end function

global function lfnquote(sequence pathname)
    if is_long_pathname( pathname ) then
	return "\"" & pathname & "\""
    end if
    return pathname
end function

