--------------------------------------------------------------------------------
-- strtok.e v1.2
-- 8/26/2000
--
-- was aka: mirctok.e  v1.1.1
-- 
-- (c) 1999 Gabriel Boehme (gboehme@musicland.com)
--
-- Euphoria implementation of mIRC Token functions 
-- plus getxml() by Kat
-- plus find_all() by Hawke'

--------------------------------------------------------------------------------

-- include files
include wildcard.e
include get.e
-- object res

-- constants

constant TRUE = 1, FALSE = 0
integer LoChar, HiChar

global function getxml(sequence record, sequence starttag, sequence endtag, integer tagnum)
-- Kat
integer tagcount
sequence record2
  if tagnum = 0 then
    if equal(record,"") then return 0 end if
    if equal(starttag,"") then return 0 end if
    if equal(endtag,"") then return 0 end if
 end if
  if tagnum != 0 then
    if equal(record,"") then return {} end if
    if equal(starttag,"") then return {} end if
    if equal(endtag,"") then return {} end if
 end if

  if equal(endtag,"/") then endtag = "/" & starttag end if
  starttag = "<" & starttag & ">"
  endtag = "<" & endtag & ">"

  if
   equal(tagnum,0) then
	   if (match(starttag,record) = 0) or (match(endtag,record) = 0) then return 0 end if
	   tagcount = 0
	   record2 = record
	   while match(starttag,record2) do
	       tagcount += 1
	       record2 = record2[match(starttag,record2)+3..length(record2)]
	   end while -- match(starttag,record2) do
	   -- now we have the tag count
	   return tagcount
  else
   if (match(starttag,record) = 0) or (match(endtag,record) = 0) then return {} end if
   tagcount = 1
   record2 = record
   while match(starttag,record2) do
	if ( tagnum = tagcount ) then
	 if ( not equal(record2[match(starttag,record2)+length(starttag)..match(endtag,record2)-1],32) )
	   then return record2[match(starttag,record2)+length(starttag)..match(endtag,record2)-1]
	   else return {}
	 end if
	end if
	record2 = record2[match(endtag,record2)+length(endtag)..length(record2)]
	tagcount += 1
    end while -- match(starttag,record2) do
  return ""
 end if
end function

----------------------------------------------------------


global procedure set_strtok_char_range(integer lo, integer hi)
-- Gabriel Boehme
   if lo < 0 then
      LoChar = 0
   else
      LoChar = lo
   end if

   if hi > #FF then
      HiChar = #FF
   else
      HiChar = hi
   end if
end procedure

set_strtok_char_range(' ', 'z') -- default settings


-- types

type char(integer x)
   if x < LoChar then
      return FALSE

   elsif x > HiChar then
      return FALSE

   end if

   return TRUE
end type

type string(sequence s)
object x
   for i = 1 to length(s) do
      x = s[i]
      if integer(x) then
	 if x < LoChar then
	    return FALSE

	 elsif x > HiChar then
	    return FALSE

	 end if
      else
	 return FALSE

      end if
   end for

   return TRUE
end type

type index(integer x)
   return x >= 1
end type

type index_or_zero(integer x)
   return x >= 0
end type

type index_or_range(object x)
   if integer(x) then
      return x >= 1

   elsif sequence(x) then
      if length(x) = 1 then
	 return x[1] >= 1

      elsif length(x) = 2 then
	 return x[1] >= 1 and x[2] > x[1]

      end if
   end if

   return FALSE
end type


-- generic sequence-handling routines

function find_all(object value, sequence s)
-- Gabriel Boehme
-- return a list of all indexes where value is found in s
sequence list
   list = {}
   for i = 1 to length(s) do
      if equal(value, s[i]) then
	 list = append(list, i)
      end if
   end for
   return list
end function

function match_all(sequence value, sequence s)
-- Gabriel Boehme
-- return a list of all indexes where value matches an element of s
sequence list
   list = {}
   for i = 1 to length(s) do
      if match(value, s[i]) then
	 list = append(list, i)
      end if
   end for
   return list
end function

function wildcard_match_all(sequence value, sequence s)
-- Gabriel Boehme
-- return a list of all indexes where the wildcard value matches an element of s
sequence list
   list = {}
   for i = 1 to length(s) do
      if wildcard_match(value, s[i]) then
	 list = append(list, i)
      end if
   end for
   return list
end function

------------------------------------------------------

global function parse(sequence s, integer c)
-- Gabriel Boehme
-- parse string s based on delimiter c into a sequence of values
sequence list, doublec
integer prev, curr

   while length(s) and ( s[1] = c ) do 
      s = s[2..length(s)] 
   end while
   while length(s) and ( s[length(s)] = c ) do 
     s = s[1..length(s)-1] 
   end while
   doublec = c & c
   while match(doublec,s) do
     s = s[1..match(doublec,s)] & s[match(doublec,s)+2..length(s)]
   end while

   if length(s) then
      list = find_all(c, s & c) -- list of delimiter positions
      prev = 0
      for i = 1 to length(list) do
	 curr = list[i]
	 list[i] = s[prev+1..curr-1]
	 prev = curr
      end for

      return list -- now, a list of the delimited values
   end if

   return {}
end function

------------------------------------------------------

function deparse(sequence list, integer c)
-- Gabriel Boehme
-- convert parsed list back into a string with c delimiters
sequence s
integer len
   len = length(list)

   if len then
      s = list[1]
      for i = 2 to len do
	 s = s & c & list[i]
      end for

      return s
   end if

   return ""
end function

-----------------------------------------------------

function insert(sequence s, integer i, object x)
-- Gabriel Boehme
-- insert x into s at position i
-- (to insert to the end of a sequence, use length(s)+1 for i)
integer len
   s = append(s, 0)
   len = length(s)
   s[i+1..len] = s[i..len-1] -- shift existing data over
   s[i] = x
   return s
end function

-----------------------------------------------------

function delete(sequence s, integer i)
-- Gabriel Boehme
-- delete data at position i from s
integer len
   len = length(s)
   s[i..len-1] = s[i+1..len] -- shift existing data back
   return s[1..len-1]
end function


--------------------------------------------------------------------------------
-- BEGIN STRING TOKEN FUNCTIONS
-- Gabriel Boehme

--------------------------------------------------------------------------------
-- text = addtok(text, token, c)
-- Adds a token to the end of text but only if it's not already in text.
--
-- text = addtok("a.b.c",   "d", '.')   -- text = "a.b.c.d"
-- text = addtok("a.b.c.d", "c", '.')   -- text = "a.b.c.d"

-- global function addtok(string text, string token, char c)
global function addtok(sequence text, sequence token, integer c)
   if not find(token, parse(text, c)) then
      return text & c & token
   end if
   return text
end function

--------------------------------------------------------------------------------

-- global function deltok(string text, index n, char c)
global function deltok(sequence text, index n, integer c)
sequence list
   list = parse(text, c)

   if n <= length(list) then
      list = delete(list, n)
   end if

   return deparse(list, c)
end function

--------------------------------------------------------------------------------

-- global function findtok(string text, string token, index_or_zero n, char c)
global function findtok(sequence text, sequence token, index_or_zero n, integer c)
sequence find_list
   find_list = find_all(token, parse(text, c))
   if n = 0 then
      return length(find_list)
   elsif n <= length(find_list) then
      return find_list[n]
   end if

   return 0
end function

--------------------------------------------------------------------------------


-- global function gettok(string text, index_or_range n, char c)
global function gettok(sequence text, index_or_range n, integer c)
integer len, start, stop
sequence list
   list = parse(text, c)

   if integer(n) then
      if n <= length(list) then
	 return list[n]
      end if
      return ""
   else
      len = length(list)

      start = n[1]
      if start > len then
	 return ""
      end if

      if length(n) = 1 then
	 stop = len
      else
	 stop = n[2]
	 if stop > len then
	    stop = len
	 end if
      end if

      return deparse(list[start..stop], c)
   end if
end function

--------------------------------------------------------------------------------

-- global function instok(string text, string token, index n, char c)
global function instok(sequence text, sequence token, index n, integer c)
sequence list
   list = parse(text, c)

   if n <= length(list) then
      list = insert(list, n, token)
   else
      list = append(list, token)
   end if

   return deparse(list, c)
end function

--------------------------------------------------------------------------------

-- global function istok(string text, string token, char c)
global function istok(sequence text, sequence token, integer c)
   return find(token, parse(text, c)) != 0
end function

--------------------------------------------------------------------------------

-- global function matchtok(string text, string value, index_or_zero n, char c)
global function matchtok(sequence text, sequence value, index_or_zero n, integer c)
sequence list, match_list
   list = parse(text, c)

   match_list = match_all(value, list)
   if n = 0 then
      return length(match_list)
   elsif n <= length(match_list) then
      return list[match_list[n]]
   end if

   return ""
end function

--------------------------------------------------------------------------------

global function numtok(sequence text, integer c)
   return length(parse(text, c))
end function
--global function toknum(sequence text, integer c)
--   return length(parse(text, c))
--end function

--------------------------------------------------------------------------------

-- global function puttok(string text, string token, index n, char c)
global function puttok(sequence text, sequence token, index n, integer c)
-- Overwrites the nth token in text with a new token.
sequence list
   list = parse(text, c)

   if n <= length(list) then
      list[n] = token
   end if

   return deparse(list, c)
end function

--------------------------------------------------------------------------------

-- global function remtok(string text, string token, index n, char c)
global function remtok(sequence text, sequence token, index n, integer c)
sequence list, find_list
   list = parse(text, c)

   find_list = find_all(token, list)
   if n <= length(find_list) then
      list = delete(list, find_list[n])
   end if

   return deparse(list, c)
end function

--------------------------------------------------------------------------------

-- global function reptok(string text, string token, string new, index n, char c)
global function reptok(sequence text, sequence token, sequence new, index n, integer c)
sequence list, find_list
   list = parse(text, c)

   find_list = find_all(token, list)
   if n <= length(find_list) then
      list[find_list[n]] = new
   end if

   return deparse(list, c)
end function

--------------------------------------------------------------------------------

-- global function wildtok(string text, string value, index_or_zero n, char c)
global function wildtok(sequence text, sequence value, index_or_zero n, integer c)
sequence list, match_list

   if length(text) = 0 then return {} end if
   list = parse(text, c)
-- print(1,list)
-- puts(1,"\n")
   match_list = wildcard_match_all(value, list)
-- print(1,match_list)
-- puts(1,"\n")
   if n = 0 then
      return length(match_list)
   elsif n < 0 then
      n = - n
      if length(match_list) < n then return 0 end if
      if length(list) >= n
       then return match_list[n]
       else return 0
      end if
   elsif n <= length(match_list) then
      return list[match_list[n]]
   end if

   return ""
end function


--------------------------------------------------------------------------------
-- Revision history:
--
-- v1.2  (by Kat (gertie@pell.net))
--   8/26/2000
--   did some bug fixes 
--   corrected a few errors in documentation
--   Wrote the readme.txt
--
-- v1.1.1 (by Kat) removed most references to mIRC/mirc to avoid any
--        problems with mIRC copyrights. Added getxml(), made all strtoks
--        accept unlimited sequences rather than limited strings.
--        No nested sequences have been tested !
--        Made all functions accept integer rather than typed char token separators.
--         ( you can still pass a char by using single ' around it. )
--        Changed the name of this file to strtoks.e to avoid copyright.
--
-- v1.1  added set_strtok_char_range()
--       cleaned up the code
--       converted Kat's mIRC code examples to Euphoria
--
-- v1.0  created
--------------------------------------------------------------------------------
-- Thanks to:
--
--    Kat for supplying the original idea,
--       with *excellent* function descriptions and demonstration examples
--
--    Hawke' for the find_all() routine
--
-- Did I forget you? Send me an e-mail and let me know!
--------------------------------------------------------------------------------
-- END STRING TOKEN FUNCTIONS
--------------------------------------------------------------------------------
