-- FIXERR.EX  Bob Elia  begun: 10/5/01 7:00 am
-- last modification: Fri, Feb 15 2002 12:19:52 am
-- process EX.ERR in current directory to make it more readable.
-- produces file EXFIXED.ERR
-- Handling of commas and numerics needs some work.

--  A few people on the list have asked for a more readable form of sequences
-- in EX.ERR.  This program attempts to do that.  However, since a string
-- in Euphoria ("a string") may not contain unprintable characters or other
-- sequences, a self-consistent notation is needed to allow that.
--  In this notation, double quotes are NOT used to denote strings.
--  Rather, string segments (that is, a printable run of atoms) are bound
-- on the left by a backquote(`) and on the right by a single quote(').
--  This allows the following example:
--
--      from EX.ERR: s = {65'A',32' ',83'S',84'T',{},82'R',73'I',78'N',71'G'}
--          which would result from the legal {65,32,83,84,{},82,73,78,71}
--  is translated to:
--      from EXFIXED.ERR: FIXD->s = {`A ST',{},`RING'}
--
--  Only curly braces ( '{' '}' ) are used to denote sequence boundaries.
--
--  Command-line option '/c' will cause original and fixed lines to be
-- output for comparison.  Option '/clobber' will quietly overwrite
-- the output file EXFIXED.ERR.


without warning     -- some unused stuff which may be used later
include strtok.e
include file.e
include print.e
include formdate.e
include win95fh.e

constant DEBUG = 0

integer fin, fout, eqPos, filePos, i, lenOut, COMPARE_FLAG, CLOBBER_FLAG
integer opt
object line
sequence workline, unch, fixd, cmd, optionFlags, optionStrings

--------- command_line options added Fri, Feb 15 2002 12:18:37 am --------
-- initialize flags
COMPARE_FLAG = 0  CLOBBER_FLAG = 0

-- possible options
optionStrings = {"/c", "/clobber"}

-- set to number of possible options; this allows them to be in any order
optionFlags = repeat(0, length(optionStrings))

unch = ""  fixd = ""    -- labels for compare option

-- check for options; perhaps overkill for 2 but could be useful for several
cmd = command_line()
if length(cmd) > 2 then
    for c = 3 to length(cmd) do
	opt = find(lower(cmd[c]), optionStrings)
	if opt then
	    optionFlags[opt] = 1
	else
	    printf(2, "unknown option %s\n", {cmd[c]})
	    -- abort(0)     -- if wanted
	end if
    end for
end if

-- set flags
if optionFlags[1] then
    COMPARE_FLAG = 1
    unch = "UNCH->"
    fixd = "FIXD->"
end if
if optionFlags[2] then CLOBBER_FLAG = 1 end if

procedure usage()
    puts(2, "Use option /CLOBBER to suppress this warning.\n")
    puts(2, "Use option /c to show original lines from EX.ERR in output.\n")
end procedure

--? optionFlags
--------------------------------------------------------------------------

if sequence( dir("EXFIXED.ERR") ) and CLOBBER_FLAG = 0 then
    printf(2, "Do you want to overwrite EXFIXED.ERR ? [y or n]", {})
    if lower(wait_key()) = 'y' then
	puts(2, "\n\nEXFIXED.ERR will be overwritten.\n")
	usage()
    else
	puts(2, "\n...user aborted.\n")
	usage()
	abort(0)
    end if
end if

procedure do_rest()
    while 1 do
	puts(fout, line)
	line = gets(fin)
	if atom(line) then
	    exit
	end if
    end while
end procedure

procedure putout(sequence out)
    --puts(fout, "FIXD->")
    sequence temp
    temp = ""
    out = fixd & out
    while length(out) > 78 do
	temp &= out[1..78] & '\n'
	out = out[79..length(out)]
    end while
    temp &= out
    puts(fout, temp) puts(fout, '\n')
end procedure

procedure do_seq()
    sequence seq, line, tok, out, temp
    integer ret, lenTok, sqPos, lenSeq, firstComma, stringFlag, s, sizeSeq
    integer commaFound, lastCharPos

    firstComma = 1  --
    stringFlag = 0
    lastCharPos = 0

    out = workline[1..eqPos + 2]  -- write out up to '= {'
    seq = workline[eqPos + 3..length(workline)]
    while 1 do
	filePos = where(fin)    -- record position of line to be read.
	line = gets(fin)
	line = line[1..length(line) - 1]    -- drop '\n'
	if match("    ", line) = 1 or equal(line, "") then     -- end of 'seq'
	    ret = seek(fin, filePos)        -- reset file position to last line.
	    exit
	else
	    seq &= line
	end if
    end while
    if COMPARE_FLAG then
    puts(fout, "EUPH->" & out & seq & '\n')
    end if
    seq = parse(seq, ',')   --separate into tokens by commas
    i = 1  lenSeq = length(seq)
    -- parse() separates 44',' into {44'} followed by {'}
    -- go through tokens rejoining {44'} followed by {'...} into {44','...}
    if lenSeq > 1 then
	temp = {}  s = 1  sizeSeq = lenSeq
	if DEBUG then
	print(1, seq) puts(1,'\n')
	end if
	while s <= sizeSeq - 1 do
	    if equal(seq[1], "44'") and find(39, seq[2]) = 1 then
		temp &= {seq[1] & ',' & seq[2]}     --seq[1..s] & seq[s + 1] & seq[s + 2..lenSeq]
		s += 1
		seq = seq[3..length(seq)]
		--puts(2, "comma start\n")
	    else
		temp &= {seq[1]}
		seq = seq[2..length(seq)]
	    end if
	    s += 1
	end while
	if length(seq) then
	    temp &= seq
	end if
	seq = temp  lenSeq = length(seq)
	if DEBUG then
	print(1, seq) puts(1,'\n')
	end if
    end if
    -- At this point we've collected entire sequence and reset the file pointer.
    while i <= lenSeq do

    tok = seq[i]
    lenTok = length(tok)
    if equal(tok, "...") then
	out &= " ...(REMAINDER TRUNCATED)"
    else    -- check to see if token contains single quoted character
	sqPos = find(39, tok)       -- position of first single quote, if any
	if sqPos and lenTok >= sqPos + 2 and tok[sqPos + 2] = 39 then -- single quotes
	    for j = 1 to sqPos - 1 do      -- up to but not including first '
		--if find(tok[j], "{}.") then -- '{' or '}' or '.'
		if not find(tok[j], "0123456789") then
		    out &= tok[j]
		end if
	    end for
	    --out &= tok[1..sqPos - 1]    -- up to but not including first '
	    if not stringFlag then
		out &= '`'
		stringFlag = 1
	    end if
	    out &= tok[sqPos + 1]       -- single quoted character
	    lastCharPos = length(out)   -- record position of last sq'd char
	    if lenTok > sqPos + 2 then  -- more after
		out &= 39               -- this must be the end of a string
		out &= tok[sqPos + 3..lenTok] & ','  -- the rest
		lastCharPos = 0         -- used as a flag below
		stringFlag = 0
		--puts(2, "lenTok > sqPos + 2\n")
	    end if
	    firstComma = 1  -- set flag for ?
	    --stringFlag = 1
	else
	-- not a printable character (e.g. ... ,80'P', ...)
---------------------------------------------------------------
	if lastCharPos then --
	    --printf(fout, "\nif lastCharPos then -- out[lastCharPos + 1..length(out)] =\n%s\n", {out[lastCharPos + 1..length(out)]})
	    out = out[1..lastCharPos] & 39 & out[lastCharPos + 1..length(out)]
	    lastCharPos = 0
	    --printf(fout, "\nif lastCharPos then -- out =\n%s\n", {out})
	end if
	if firstComma and stringFlag then
	    out &= ','
	    --out &= "',"
	    firstComma = 0
	    stringFlag = 0
	end if

	out &= tok & ','    -- doesn't contain single quoted character
	--out &= '' & tok & ''    -- doesn't contain single quoted character
	end if
    end if
    i += 1
    end while
    lenOut = length(out)
    if out[lenOut] = ',' then
	out = out[1..lenOut - 1]
    end if
    putout(out)
end procedure

fin = open("EX.ERR", "r")
if fin = -1 then
    puts(2, "couldn't open EX.ERR")
    abort(0)
end if
fout = open("EXFIXED.ERR", "w")
if fout = -1 then
    puts(2, "couldn't open EXFIXED.ERR")
    abort(0)
end if

printf(fout, "%s\n", {"THIS FILE WAS GENERATED BY FIXERR.EX FROM:"})
printf(fout, "%s\n", { lfn_current_dir() & "\\EX.ERR on "
			& formatDateAndTime() })

puts(fout, "BE AWARE THAT THE NOTATION USED IS *NOT* TRUE EUPHORIA NOTATION.\n"
	&  "Please see FIXERR.EX for details.\n\n")

while 1 do
    line = gets(fin)
    if atom(line) then
	exit
    end if

    if equal(line, "Traced lines leading up to the failure:\n") then
	do_rest()
	exit
    end if

    workline = line[1..length(line) - 1]    -- drop '\n'
    eqPos = match("= {", workline)
    if eqPos then
	do_seq()

    else
	puts(fout, unch)
	puts(fout, line)
    end if

end while

