-- Copyright 1997 - Francis Bussiere - email: claire@cyberglobe.net
-- Not responsible for any use or misuse - Use at your own risk

-- with trace

include file.e
include machine.e

--              D_NAME       =  1
--              D_ATTRIBUTES =  2
--              D_SIZE       =  3
--              D_YEAR       =  4
--              D_MONTH      =  5
--              D_DAY        =  6
--              D_HOUR       =  7
--              D_MINUTE     =  8
--              D_SECOND     =  9
global constant D_LONGNAME   = 10
global constant D_CREATED    = 11
global constant D_ACCESSED   = 12

-- LOCAL ROUTINES

function FindFirst95( sequence FileSpec, atom FindData )
  atom Buffer
  sequence Regs

  Buffer = allocate_low( length( FileSpec ) + 1 )
  if not Buffer then return 0 end if
  poke( Buffer, FileSpec & 0 )
  Regs = repeat( 0, REG_LIST_SIZE )
  Regs[ REG_AX ] = #714E
  Regs[ REG_CX ] = #00FF
  Regs[ REG_SI ] = #0001
  Regs[ REG_DS ] = floor( Buffer / 16 )
  Regs[ REG_DX ] = remainder( Buffer, 16 )
  Regs[ REG_ES ] = floor( FindData / 16 )
  Regs[ REG_DI ] = remainder( FindData, 16 )
  Regs = dos_interrupt( #21, Regs )
  free_low( Buffer )
  if and_bits( Regs[ REG_FLAGS ], 1 ) and Regs[ REG_AX ] != #7100 then
    Regs[ REG_AX ] = 0
  end if
  return Regs[ REG_AX ]
end function

function FindNext95( integer Handle, atom FindData )
  sequence Regs

  Regs = repeat( 0, REG_LIST_SIZE )
  Regs[ REG_AX ] = #714F
  Regs[ REG_BX ] = Handle
  Regs[ REG_SI ] = #0001
  Regs[ REG_ES ] = floor( FindData / 16 )
  Regs[ REG_DI ] = remainder( FindData, 16 )
  Regs = dos_interrupt( #21, Regs )
  if and_bits( Regs[ REG_FLAGS ], 1 ) then return 0 end if
  return 1
end function

function FindClose95( integer Handle )
  sequence Regs

  Regs = repeat( 0, REG_LIST_SIZE )
  Regs[ REG_AX ] = #714F
  Regs[ REG_BX ] = Handle
  Regs = dos_interrupt( #21, Regs )
  if and_bits( Regs[ REG_FLAGS ], 1 ) then return 0 end if
  return 1
end function

function ReadData( atom FindData )
  atom a
  sequence File

  File = repeat( 0, 12 )
  a = bytes_to_int( peek( { FindData, 4 } ) )
  File[ D_ATTRIBUTES ] = ""
  if and_bits( a, 1 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 'r'
  end if
  if and_bits( a, 2 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 'h'
  end if
  if and_bits( a, 4 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 's'
  end if
  if and_bits( a, 8 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 'v'
  end if
  if and_bits( a, 16 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 'd'
  end if
  if and_bits( a, 32 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 'a'
  end if
  if and_bits( a, 256 ) then
    File[ D_ATTRIBUTES ] = File[ D_ATTRIBUTES ] & 't'
  end if
  a = bytes_to_int( peek( { FindData + #04, 4 } ) )
  File[ D_CREATED ] = repeat( 0, D_SECOND )
  File[ D_CREATED ][ D_YEAR   ] = remainder( and_bits( a, #FE000000 ), #1FFFFFF ) + 1980
  File[ D_CREATED ][ D_MONTH  ] = remainder( and_bits( a, #01E00000 ),  #1FFFFF )
  File[ D_CREATED ][ D_DAY    ] = remainder( and_bits( a, #001F0000 ),    #FFFF )
  File[ D_CREATED ][ D_HOUR   ] = remainder( and_bits( a,     #F800 ),     #7FF )
  File[ D_CREATED ][ D_MINUTE ] = remainder( and_bits( a,     #07E0 ),      #1F )
  File[ D_CREATED ][ D_SECOND ] =            and_bits( a,     #001F ) * 2
  a = bytes_to_int( peek( { FindData + #0C, 4 } ) )
  File[ D_ACCESSED ] = repeat( 0, D_SECOND )
  File[ D_ACCESSED ][ D_YEAR   ] = remainder( and_bits( a, #FE000000 ), #1FFFFFF ) + 1980
  File[ D_ACCESSED ][ D_MONTH  ] = remainder( and_bits( a, #01E00000 ),  #1FFFFF )
  File[ D_ACCESSED ][ D_DAY    ] = remainder( and_bits( a, #001F0000 ),    #FFFF )
  File[ D_ACCESSED ][ D_HOUR   ] = remainder( and_bits( a,     #F800 ),     #7FF )
  File[ D_ACCESSED ][ D_MINUTE ] = remainder( and_bits( a,     #07E0 ),      #1F )
  File[ D_ACCESSED ][ D_SECOND ] =            and_bits( a,     #001F ) * 2
  a = bytes_to_int( peek( { FindData + #14, 4 } ) )
  File[ D_YEAR   ] = remainder( and_bits( a, #FE000000 ), #1FFFFFF ) + 1980
  File[ D_MONTH  ] = remainder( and_bits( a, #01E00000 ),  #1FFFFF )
  File[ D_DAY    ] = remainder( and_bits( a, #001F0000 ),    #FFFF )
  File[ D_HOUR   ] = remainder( and_bits( a,     #F800 ),     #7FF )
  File[ D_MINUTE ] = remainder( and_bits( a,     #07E0 ),      #1F )
  File[ D_SECOND ] =            and_bits( a,     #001F ) * 2
  File[ D_SIZE   ] = bytes_to_int( peek( { FindData + #20, 4 } ) )
  File[ D_SIZE   ] = File[ D_SIZE ] + bytes_to_int( peek( { FindData + #1C, 4 } ) ) * #100000000
  a = #2C  File[ D_LONGNAME ] = ""
  while peek( FindData + a ) do
    File[ D_LONGNAME ] = File[ D_LONGNAME ] & peek( FindData + a )
    a = a + 1
  end while
  a = #130  File[ D_NAME ] = ""
  while peek( FindData + a ) do
    File[ D_NAME ] = File[ D_NAME ] & peek( FindData + a )
    a = a + 1
  end while
  if not length( File[ D_NAME ] ) then File[ D_NAME ] = File[ D_LONGNAME ] end if
  return File
end function

-- GLOBAL ROUTINES

constant DATE_SPACE = repeat(0, D_SECOND)

global function Dir95( sequence FileSpec )
  atom FindData
  integer i, Handle
  object Files -- changed from 'sequence' by Cyrek

  i = length( FileSpec )
  if not i then
      i = 1
      FileSpec = "*"
  end if

  if FileSpec[ i ] = '\\' then
    FileSpec &= '*'
    i += 1
  end if

  FindData = allocate_low( #13F )

  if not FindData then return -1 end if

  Handle = FindFirst95( FileSpec, FindData )
  if not Handle then
    return -1

  elsif Handle = #7100 then
    Files = dir( FileSpec )
    if integer(Files) then
	return Files
    end if

    for j = 1 to length( Files ) do
      Files[ j ] &= {
	Files[ j ][ D_NAME ],
	DATE_SPACE,
	DATE_SPACE
      }
    end for

  else
      Files = { ReadData( FindData ) }

      if  not find( '*', FileSpec )
      and find( 'd', Files[ 1 ][ D_ATTRIBUTES ] )
      then -- directory but not wildcard

	if FindClose95( Handle ) then end if

	FileSpec &= "\\*"

	Handle = FindFirst95( FileSpec, FindData )

	if not Handle then return -1 end if

	Files = { ReadData( FindData ) }

      end if

      while FindNext95( Handle, FindData ) do
	Files &= { ReadData( FindData ) }
      end while

      if FindClose95( Handle ) then end if

  end if
  free_low( FindData )
  return Files
end function

