		-----------------------------------
		--  Program to Install Euphoria  --
		--  (see install.doc)            --
		-----------------------------------

-- install.bat runs this install.ex program, then it runs Junko Miura's 
-- documentation generator to create both the HTML and DOC files from a
-- common source (HTX). You can download the generator and HTX files
-- from the RDS Web site.

without warning
constant KEYBOARD = 0, SCREEN = 1
constant SUCCESS = 1, FAILURE = 0, NO_EDIT = 2
constant TRUE = 1, FALSE = 0
constant CLEAR = 0, NO_CLEAR = 2

	-------------------------------------------------
	-- Subdirectory structure for Euphoria files.  --
	--     (before documentation generator)        --
	-------------------------------------------------

constant file_list = {
  {"INCLUDE", 
   "GRAPHICS.E", "SORT.E", "GET.E", "MOUSE.E", "FILE.E", "MACHINE.E",
   "WILDCARD.E", "IMAGE.E", "SAFE.E", "DLL.E", "MISC.E", "MSGBOX.E"},

  {"BIN", 
   "BIN.DOC", "SYNCOLOR.E", "LINES.BAT", "LINES.EX", "EPRINT.EX", "GURU.BAT",
   "GURU.EX", "EPRINT.BAT", "ED.BAT", "ED.EX", "KEYWORDS.E", "CDGURU.BAT", 
   "SEARCH.EX", "SEARCH.BAT", "EXW.EXE", "ASCII.EX", "ASCII.BAT", 
   "WHERE.EX", "WHERE.BAT", "KEY.BAT", "KEY.EX"},
  
  {"DEMO",
   "DEMO.DOC", "ANIMAL.EX", "ALLSORTS.EX", "SANITY.EX", "QUEENS.EX", 
   "BUZZ.EX", "MYDATA.EX", "CSORT.EX", "TREE.EX", "HASH.EX"},
  
  {"DEMO\\DOS32",
   "DOS32.DOC", "BITMAP.EX", "PLOT3D.EX", "SB.EX", "SELECT.E", "TTT.EX", 
   "WIRE.EX", "MOUSE.EX", "MSET.EX", "POLYGON.EX", "CALLMACH.EX", "STEREO.EX", 
   "PICTURE", "DOSINT.EX", "HARDINT.EX"},
  
  {"DEMO\\WIN32",
   "WIN32.DOC" , "EMAIL.EXW", "WINDOW.EXW", "WINWIRE.EXW", "DSEARCH.EXW"},

  {"DEMO\\LANGWAR", 
   "LW.DOC", "LW.SUM", "WEAPONS.E", "SCREEN.E", "COMMANDS.E", "DAMAGE.E",  
   "DISPLAY.E", "EMOVE.E", "ENEMY.E", "SCHED.E", "VARS.E", "SOUNDEFF.E",  
   "PUTSXY.E", "PICTURES.E", "LW.EX"},   

  {"DEMO\\BENCH", 
   "BENCH.DOC", "SHELL.EX", "SHELL.BAS", "DATABASE.EX", "DATABASE.BAS", 
   "SIEVE.EX", "SIEVE.BAS", "SEQUENCE.EX", "SEQUENCE.BAS", "FILESORT.EX",
   "SIEVE1.PRO", "SIEVE2.PRO"},   
  
  {"TUTORIAL",
   "TUTORIAL.DOC", "CALC.EX", "GETC.EX", "GETS.EX", "HELLO.EX", "SEQCALC.EX",
   "CELCIUS.EX", "APPEND.EX", "LEARN.EX", "SIMPLE.EX", "EXAMPLE.EX"},
  
  {"REGISTER",
   "REGISTER.DOC", "HOW2REG.EX"},
  
  {"HTML"
  },  -- docall.bat does the rest
  
  {"DOC"
  }   -- docall.bat does the rest
}

-- Some imported routines, so we don't need any include files
-- to be available during the install

-- from file.e:

constant M_DIR   = 22,
	 M_CURRENT_DIR = 23

function dir(sequence name)
    return machine_func(M_DIR, name)
end function

function current_dir()
    return machine_func(M_CURRENT_DIR, 0)
end function

-- from graphics.e:

constant M_GRAPHICS_MODE = 5,
	 M_SET_T_COLOR = 9,
	 M_VIDEO_CONFIG = 13,
	 M_GET_POSITION = 25

constant VC_COLOR = 1

global function graphics_mode(integer m)
   return machine_func(M_GRAPHICS_MODE, m)
end function

if graphics_mode(3) then  -- make it a full-screen DOS window
end if

function video_config()
    return machine_func(M_VIDEO_CONFIG, 0)
end function

global procedure text_color(integer c)
    machine_proc(M_SET_T_COLOR, c)
end procedure

function get_position()
    return machine_func(M_GET_POSITION, 0)
end function

-- from wildcard.e:

constant TO_LOWER = 'a' - 'A' 

function upper(object x)
    return x - (x >= 'a' and x <= 'z') * TO_LOWER
end function

function exist(sequence path)
-- check if file or directory exists
    return sequence(dir(path))
end function

procedure eu_copy(sequence source, sequence dest)
-- copy a file from source to dest using Euphoria getc()/puts()
    integer s, d, c
     
    s = open(source, "rb")
    if s = -1 then
	return
    end if
    d = open(dest, "wb")
    if d = -1 then
	close(s)
	return
    end if
    while 1 do
	c = getc(s)
	if c = -1 then
	    exit
	end if
	puts(d, c)
    end while  
    close(s)
    close(d)
end procedure

object move_command
move_command = "C:\\DOS\\MOVE.EXE " -- DOS 6
if not exist(move_command) then
    move_command = "C:\\WINDOWS\\COMMAND\\MOVE.EXE " -- DOS 7
    if not exist(move_command) then
	move_command = -1 -- assume no move command
    end if
end if

sequence vc
vc = video_config()

integer color_monitor
color_monitor = vc[VC_COLOR]

procedure the_end(integer status)
-- exit install
    puts(SCREEN, '\n')
    abort(status)
end procedure

procedure fore_color(integer c)
-- change foreground color
    if color_monitor then
	text_color(c)
    end if
end procedure

procedure move(sequence source, sequence dest)
-- move one file into a directory
    sequence p
    
    -- MOVE (DOS 6,7)
    if sequence(move_command) then
	system(move_command & source & ' ' & dest & " > NUL", NO_CLEAR)
	if exist(dest & "\\" & source) then
	    return
	else
	    puts(SCREEN, "OK - no MOVE command - use COPY instead...\n")
	    move_command = -1 -- doesn't work
	end if
    end if

    -- use Euphoria copy routine
    eu_copy(source, dest & "\\" & source)
    if exist(dest & "\\" & source) then
	system("del " & source, NO_CLEAR)
    else
	-- copy failed
	puts(SCREEN, "Unable to copy " & source & 
		     " to " & dest & " subdirectory\n")
	if exist(source) and exist("EUPHOR22.ZIP") then
	    puts(SCREEN, "Perhaps you can delete euphor22.zip to get extra space\n")
	end if
    end if
end procedure

procedure moveall()
-- move all files into the correct subdirectories
    sequence command

    puts(SCREEN, "creating Euphoria subdirectories\n")
    for i = 1 to length(file_list) do
	puts(SCREEN, file_list[i][1] & "            \r")
	command = "mkdir " & file_list[i][1]
	system(command, NO_CLEAR) 
	for j = 2 to length(file_list[i]) do
	    move(file_list[i][j], file_list[i][1])
	end for
    end for
    puts(SCREEN, "        \r")
end procedure

function unbundle()
-- unbundle files stored in 0.dat
    integer bundle, newfile, size
    object line

    puts(SCREEN, "unbundling files\n")

    bundle = open("0.dat", "rb")
    if bundle = -1 then
	puts(SCREEN, "Couldn't find 0.dat\n")
	return FAILURE
    end if

    -- skip first 3 lines
    line = gets(bundle)
    line = gets(bundle)
    line = gets(bundle)
    
    while TRUE do
	line = gets(bundle) -- file name
	if atom(line) then
	    exit -- EOF
	end if
	
	line = line[1..length(line)-1]
	
	if length(line) > 12 then
	    puts(SCREEN, "0.dat has been corrupted\n")
	    return FAILURE
	end if
	
	newfile = open(line, "wb")
	if newfile = -1 then
	    puts(SCREEN, "Couldn't open " & line & " for write\n")
	    return FAILURE
	end if
	
	printf(SCREEN, "%s\t\t\t\r", {line})
	
	line = gets(bundle)  -- size of file
	if atom(line) then
	    puts(SCREEN, "0.dat has been corrupted\n")
	    return FAILURE
	end if
	
	-- compute size of file
	size = 0
	for i = 1 to length(line) do
	    if line[i] < '0' then
		exit
	    end if
	    size = size * 10 + line[i] - '0'
	end for
	
	if size < 20 or size > 200000 then
	    puts(SCREEN, "0.dat has been corrupted\n")
	    return FAILURE
	end if
	
	-- copy to file
	for i = 1 to size do
	    puts(newfile, getc(bundle))
	end for
	close(newfile)
    end while
    close(bundle)
    system("DEL 0.DAT", NO_CLEAR)
    return SUCCESS
end function

function setupdir()
-- set up subdirectories 

    if unbundle() = FAILURE then
	return FAILURE
    end if
    moveall()
    if not exist("BIN\\EXW.EXE") then
	puts(SCREEN, "Subdirectory set up failed - see INSTALL.DOC\n")
	return FAILURE
    end if
    return SUCCESS
end function

procedure rename_it()
    puts(SCREEN, 
	 "Please remove it or rename it before installing a new version.\n")
end procedure

function copy_to_hard_disk(integer drive)
-- copy Euphoria files to EUPHORIA directory 
    sequence eu_dir, rename_dir
    integer rename_letter

    eu_dir = drive & ":\\EUPHORIA"

    if equal(upper(current_dir()), eu_dir) then
	-- we're in EUPHORIA directory already - just set up subdirectories
	clear_screen()
	return setupdir() 
    end if

    if exist(eu_dir) then
	puts(SCREEN,
	"An existing EUPHORIA directory was found on drive " & drive & ".\n")
	if sequence(move_command) then
	    rename_letter = 'F'
	    while rename_letter <= 'Z' do
		rename_dir = drive & ":\\" & rename_letter & "UPHORIA"
		if not exist(rename_dir) then
		    exit
		end if
		rename_letter += 1
	    end while
	    if rename_letter <= 'Z' then
		system(move_command & eu_dir & ' ' & rename_dir & "> NUL", NO_CLEAR)
		if exist(rename_dir) then
		    puts(SCREEN,"It has been renamed as " & rename_dir & "\n\n")
		else
		    rename_it()
		    return FAILURE
		end if
	    else
		rename_it()
		return FAILURE
	    end if
	else
	    rename_it()
	    return FAILURE
	end if
    end if

    puts(SCREEN, "The EUPHORIA files will now be copied to " & eu_dir & '\n')
    puts(SCREEN, "    * Press Enter to start copying. [recommended action]\n")
    puts(SCREEN, "    * or type ! to abort.\n")

    if find('!', gets(KEYBOARD)) then
	puts(SCREEN, "\ninstallation aborted - try again later\n")
	the_end(1)
    end if

    system("mkdir " & eu_dir, NO_CLEAR)
    if not exist(eu_dir) then
	puts(SCREEN, "\n\nCouldn't create " & eu_dir & ".\n")
	puts(SCREEN, "See install.doc\n")
	return FAILURE
    end if

    -- copy all files to EUPHORIA directory
    clear_screen()
    puts(SCREEN, "copying files to: ")
    fore_color(13)
    puts(SCREEN, eu_dir & "\n")
    fore_color(7)
    eu_copy("EUPHOR22.ZIP", eu_dir & "\\EUPHOR22.ZIP")
    eu_copy("README.DOC",   eu_dir & "\\README.DOC")
    eu_copy("FILE_ID.DIZ",  eu_dir & "\\FILE_ID.DIZ")
    eu_copy("INSTALL.DOC",  eu_dir & "\\INSTALL.DOC")
    eu_copy("INSTALL.BAT",  eu_dir & "\\INSTALL.BAT")
    eu_copy("0.DAT",        eu_dir & "\\0.DAT")
    eu_copy("INSTALL.EX",   eu_dir & "\\INSTALL.EX")
    eu_copy("EX.EXE",       eu_dir & "\\EX.EXE")
    
    if not exist(eu_dir & "\\EX.EXE") or 
       not exist(eu_dir & "\\INSTALL.EX") then 
	puts(SCREEN, "copy failed - see INSTALL.DOC\n")
	return FAILURE
    end if

    -- copy worked, now cd to EUPHORIA
    system(drive & ':', NO_CLEAR)
    system("cd " & eu_dir, NO_CLEAR)
    if not equal(upper(current_dir()), eu_dir) then
	puts(SCREEN, "cd failed - see install.doc\n")
	return FAILURE
    end if

    -- cd worked, now set up subdirectories
    return setupdir() 
end function

function Yes()
-- return TRUE if answer is "y"
    sequence answer
    
    while TRUE do
	answer = upper(gets(KEYBOARD))
	puts(SCREEN, '\n')
	if find('Y', answer) then
	    return TRUE
	elsif find('N', answer) then
	    return FALSE
	else
	    puts(SCREEN, "Please answer with y or n: ")
	end if
    end while
end function

-- Looks like the PATH can be longer than this now - just give a warning
constant MAX_PATH = 127

function edit_auto_exec(integer drive)
-- edit the autoexec.bat file
-- add to the PATH, set EUDIR
    integer path_found, q, auto_exec_no, p, white, semi_pos, d, new_path_length
    sequence path, auto_exec, auto_name, base_name, answer, set_line
    object line

    path = getenv("PATH")
    if sequence(path) then
	path = upper(path)
	p = match("EUPHORIA\\BIN", path) 
	if p then
	    q = p + length("EUPHORIA\\BIN") - 1
	    while p > 1 do
		p -= 1
		if path[p]=';' then
		    p += 1
		    exit
		end if
	    end while
	    puts(SCREEN, "\nYour current PATH already has " & path[p..q] & '\n')
	    d = upper(path[p])
	    if find(':', path[p..q]) and d >= 'A' and d <= 'Z' and 
	       d != upper(drive) then
		fore_color(4)
		puts(SCREEN, "WARNING: ")
		fore_color(7)
		puts(SCREEN, 
		  "You are installing to a different drive than before.\n")
		puts(SCREEN, 
		  "You must set up your AUTOEXEC.BAT for the version of Euphoria\n")
		puts(SCREEN, "that you want to use.\n")
	    end if
	    return NO_EDIT
	end if
    end if
    
    puts(SCREEN, "\n\nEditing AUTOEXEC.BAT...\n")
    set_line = "SET EUDIR=" & drive & ":\\EUPHORIA\n"
    base_name = ":\\AUTOEXEC.BAT"
    auto_name = "C" & base_name  -- try C first
    auto_exec = {}
    path_found = 0
    
    auto_exec_no = open(auto_name, "r")
    while auto_exec_no = -1 do
	puts(SCREEN, "Couldn't open " & auto_name & '\n')
	puts(SCREEN, "On what drive is your AUTOEXEC.BAT file?\n")
	puts(SCREEN, "Type a letter: (! to abort)\n")
	answer = gets(KEYBOARD)
	if find('!', answer) then
	    puts(SCREEN, "creating C:\\AUTOEXEC.BAT\n")
	    exit
	end if
	auto_name = answer[1] & base_name
	auto_exec_no = open(auto_name, "r")
    end while
    
    new_path_length = 0
    while auto_exec_no != -1 do
	-- read next line from autoexec.bat
	line = gets(auto_exec_no)
	if atom(line) then
	    exit
	end if
	p = match("PATH", upper(line))
	if p then
	    -- line contains the word "PATH" in upper or lower case
	    -- at position p
	    white = TRUE
	    q = p - 1
	    while q >= 1 do
		if not find(line[q], " \t") then
		    -- non whitespace - only "SET" is allowed
		    if q >= 3 then
			if equal("SET", upper(line[q-2..q])) then
			    q -= 2
			else
			    white = FALSE
			    exit
			end if
		    else
			white = FALSE
			exit
		    end if
		end if
		q -= 1
	    end while

	    if white and find(line[p+4], " \t=") then
		-- this is a PATH line
		path_found += 1
		if path_found = 1 then
		    -- only change the first one encountered
		    auto_exec = append(auto_exec, set_line)
		    if match(drive & ":\\EUPHORIA\\BIN", upper(line)) then
			-- its already there
			puts(SCREEN, "PATH already has " & drive & 
				     ":\\EUPHORIA\\BIN\n")
			close(auto_exec_no)
			return NO_EDIT
		    end if
		    semi_pos = find(';', line)
		    if semi_pos = 0 then
			semi_pos = length(line)
			line = line[1..length(line)-1] & ";\n"
		    end if
		    -- add EUPHORIA\BIN to path
		    puts(SCREEN, "Changing this line:\n")
		    fore_color(2)
		    puts(SCREEN, line)
		    fore_color(7)
		    puts(SCREEN, "to:\n")
		    fore_color(2)
		    puts(SCREEN, line[1..semi_pos])
		    fore_color(4)
		    puts(SCREEN, drive & ":\\EUPHORIA\\BIN;")
		    fore_color(2)
		    puts(SCREEN, line[semi_pos+1..length(line)])
		    line = line[1..semi_pos] &
			   drive & ":\\EUPHORIA\\BIN;" &
			   line[semi_pos+1..length(line)]
		    new_path_length = length(line)
		    fore_color(7)
		    puts(SCREEN, "and inserting the following line:\n")
		    fore_color(4)
		    puts(SCREEN, set_line)
		    fore_color(7)
		end if
	    end if
	end if
	auto_exec = append(auto_exec, line)
    end while

    if auto_exec_no = -1 or not path_found then
	-- no autoexec.bat file, or no PATH command was found - make one:
	line = "SET PATH=%PATH%;" & drive & ":\\EUPHORIA\\BIN\n"
	puts(SCREEN, "adding the following lines:\n")
	fore_color(4)
	puts(SCREEN, set_line)
	puts(SCREEN, line)
	fore_color(7)
	auto_exec &= {set_line, line}
	path_found = 1
    end if
    
    -- write out the new autoexec.bat
    puts(SCREEN, 
    "Is it OK to make these changes to your AUTOEXEC.BAT file? (y or n) \n")
    puts(SCREEN, "-----> ") 
    if not Yes() then
	return FAILURE
    end if
    if path_found = 2 then
	puts(SCREEN, "One other \"PATH\" line was found but not changed.\n") 
	puts(SCREEN, "Please take a look at it.\n")
    elsif path_found > 2 then
	printf(SCREEN, "%d other \"PATH\" lines were found but not changed.\n",
	path_found - 1)
	puts(SCREEN, "Please take a look at them.\n")
    end if
    if auto_exec_no != -1 then
	close(auto_exec_no)
    end if
    auto_exec_no = open(auto_name, "w")
    if auto_exec_no = -1 then
	puts(SCREEN, "Couldn't write out the new AUTOEXEC.BAT!\n")
	puts(SCREEN, "Your AUTOEXEC.BAT file is read-only.\n")
	return FAILURE
    end if
    for i = 1 to length(auto_exec) do
	puts(auto_exec_no, auto_exec[i])
    end for
    close(auto_exec_no)
    if new_path_length > MAX_PATH then
	-- line may be too long (old MS-DOS restriction)
	fore_color(4)
	puts(SCREEN, "WARNING: ")
	fore_color(7)
	printf(SCREEN, 
	 "Your PATH line in AUTOEXEC.BAT is getting quite long (%d characters).\n", 
	 new_path_length)
	puts(SCREEN, "You might have to delete a directory from it.\n\n")
    end if
    return SUCCESS
end function

procedure install()
-- main routine for Euphoria installation
    integer drive
    integer edit_status
    sequence answer

    clear_screen()
    fore_color(13)
    puts(SCREEN, "\nEuphoria")
    fore_color(7)
    puts(SCREEN, " Installation Program\n\n")

    if exist("EXW.EXE") then
	puts(SCREEN, "You have already installed Euphoria.\n")
	puts(SCREEN, "If you need to set up AUTOEXEC.BAT see INSTALL.DOC.\n")
	return
    end if

    puts(SCREEN, "On which drive do you want to put the EUPHORIA directory?\n")
    puts(SCREEN, "Type the drive letter, or just hit Enter for drive C\n")
    puts(SCREEN, "-----> ")

    answer = upper(gets(KEYBOARD))

    while answer[1] = ' ' or answer[1] = '\t' do
	answer = answer[2..length(answer)]
    end while

    drive = answer[1]
    if drive < 'A' or drive > 'Z' then
	drive = 'C'
    end if

    puts(SCREEN, '\n')

    if copy_to_hard_disk(drive) = FAILURE then
	the_end(1)
    end if

    edit_status = edit_auto_exec(drive)

    if edit_status = FAILURE then
	puts(SCREEN, 
	  "To complete the install you should edit AUTOEXEC.BAT manually.\n") 
	puts(SCREEN, 
	  "See DOC\\INSTALL.DOC - How To Manually Edit AUTOEXEC.BAT\n")
	return
    end if

    if edit_status != NO_EDIT then
	puts(SCREEN, "When the install is completed you must\n")
	fore_color(2)
	puts(SCREEN, "shut down and restart (soft-reboot) your computer")
	fore_color(7)
	puts(SCREEN, ".\nThis will set your PATH and EUDIR variables.\n\n")
    end if
end procedure

install()
the_end(0)

