-----------------------------------------------------------------------------
-- Window Manager
-- Written for Midget II
-- (c) Andrew Greenwood, 22nd October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------

include mouse.e
include die.e
include graphics.e
include image.e


-- Format of Window:
-- [1] Origin
-- [2] Size
-- [3] Menu handle (integer, for menu.e)

constant
    W_ORIGIN = 1,
    W_SIZE = 2,
    W_MENU = 3

sequence
    Window, Layer, destroyed, Pos, Order

integer
    Place

global integer
    active

Place=0
Order={}
Pos={1,1}
destroyed = {}
Window = {}
Layer = {}
active = 0


procedure CheckHandle(integer handle)
    if handle < 1 or handle > length(Window) then
        FatalExit("WinMgr","Invalid window handle: "&sprintf("%g",handle))
    end if
end procedure


global procedure CheckParent(integer handle)
    CheckHandle(handle)
end procedure


global procedure rectangle(integer colour, object tl, object br)
    polygon(colour,0,{{tl[1],tl[2]},{tl[1],br[2]},{br[1],br[2]},{br[1],tl[2]}})
end procedure


global procedure rectangle_fill(integer colour, object tl, object br)
    polygon(colour,1,{{tl[1],tl[2]},{tl[1],br[2]},{br[1],br[2]},{br[1],tl[2]}})
end procedure


global procedure SetActiveWindow(integer newone)
    CheckHandle(newone)
    active = newone
end procedure


global function CreateWindow(sequence origin, sequence size)
    integer handle
    if origin[1]<0 or origin[2]<0 then
        FatalExit("WinMgr","Bad window origin")
    end if
    if length(destroyed) > 0 then
        Window[destroyed[1]] = {origin, size, -1}
        handle=destroyed[1]
        if length(destroyed) > 1 then
            destroyed=destroyed[2..length(destroyed)]
        else
            destroyed={}
        end if
        return handle
    else
        Window = Window & {{origin, size, -1}}
        Layer = Layer & {{}}
        return length(Window)
    end if
end function


global procedure DestroyWindow(integer handle)
    sequence truepos
    CheckHandle(handle)
    mouse_pointer(0)
    if not find(handle,destroyed) then
        truepos = (Window[handle][W_ORIGIN][1]-1) * 8 &
                  (Window[handle][W_ORIGIN][2]-1) * 16
        display_image(truepos,Layer[handle])
        Layer[handle]={}
        destroyed = destroyed & handle
    end if
    Place = Place - 1
    if Place<0 then
        Place=0
    end if
    if Place <= length(Order) and Place>0 then
        SetActiveWindow(Order[Place])
    end if
    mouse_pointer(1)
end procedure


global procedure DisplayWindow(integer handle)
    sequence origin, size
    CheckHandle(handle)

    origin = {(Window[handle][W_ORIGIN][1]-1) * 8,
              (Window[handle][W_ORIGIN][2]-1) * 16}
    size = {(Window[handle][W_SIZE][1] * 8)-1,
            (Window[handle][W_SIZE][2] * 16)-1}

    mouse_pointer(0)

    Layer[handle] = save_image(origin, {origin[1]+size[1],origin[2]+size[2]})

    rectangle_fill(0, origin,
                      {origin[1]+size[1],
                       origin[2]+size[2]})
    rectangle(15, origin,
                      {origin[1]+size[1],
                       origin[2]+size[2]})
    Place = Place + 1
    active=handle
    Order = Order & active

    mouse_pointer(1)
end procedure


global function GetActiveWindow()
    return active
end function


global function GetWindowParams(integer handle)
    CheckHandle(handle)
    return Window[handle]
end function


global procedure polygon_w(integer handle, integer colour, integer fill,
                           object points)
    CheckHandle(handle)
    mouse_pointer(0)
    for loop=1 to length(points) do
        points[loop][1] = points[loop][1] + Window[handle][W_ORIGIN][1]
        points[loop][2] = points[loop][2] + Window[handle][W_ORIGIN][2]
    end for
    polygon(colour,fill,points)
    mouse_pointer(1)
end procedure


global procedure rectangle_w(integer handle, integer colour, integer fill,
                             object tl, object br)
    polygon_w(handle,colour,fill,{{tl[1],tl[2]},{tl[1],br[2]},{br[1],br[2]},{br[1],tl[2]}})
end procedure


global procedure w_puts(integer handle, object data)
 -- Use virtual screen soon!
    mouse_pointer(0)
    for loop=1 to length(data) do
    position(Pos[2] + Window[handle][W_ORIGIN][2]-1,
             Pos[1] + Window[handle][W_ORIGIN][1])
        if data[loop]='\n' then
            Pos[2]=Pos[2]+1
            Pos[1]=1
        else
            Pos[1]=Pos[1]+1
            puts(1,data[loop])
        end if
    end for
    mouse_pointer(1)
end procedure


global procedure w_position(integer y, integer x)
    Pos = {x,y}
end procedure


global procedure Minimize()
    mouse_pointer(0)
    display_image(
                {(Window[active][W_ORIGIN][1]-1)*8,
                 (Window[active][W_ORIGIN][2]-1)*16}, Layer[active])
    mouse_pointer(1)
    Place = Place - 1
    if Place <= length(Order) and Place > 0 then
        SetActiveWindow(Order[Place])
    end if
end procedure
