-----------------------------------------------------------------------------
-- Direct Mouse routines
-- Modified for Midget II
-- (c) Andrew Greenwood, 24th October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------

without warning
include die.e
include machine.e

object registers,events

global object IsPtrOn
IsPtrOn=0

global constant LEFT_BUTTON = 1,
                MIDDLE_BUTTON = 3,
                RIGHT_BUTTON = 2

events=-1
registers=repeat(0,10)

procedure clear_registers()
 registers=repeat(0,10)
end procedure

global procedure mouse_pointer(integer show_it)
 if show_it=0 and IsPtrOn=1 then
    IsPtrOn=0
    registers[REG_AX]=#0002
    registers=dos_interrupt(#33, registers)
 elsif show_it=1 and IsPtrOn=0 then
    IsPtrOn=1
    registers[REG_AX]=#0001
    registers=dos_interrupt(#33, registers)
 end if
 clear_registers()
end procedure

global function get_mouse_position()
 integer xpos, ypos
 registers[REG_AX]=#0003
 registers=dos_interrupt(#33, registers)
 xpos=registers[REG_CX]
 ypos=registers[REG_DX]
 clear_registers()
 return {xpos,ypos}
end function

global procedure mouse_position(integer xpos, integer ypos)
 if IsPtrOn=0 then
  FatalExit("Mouse","Attempt to retrieve event while pointer is hidden.")
--  IsPtrOn=1
 end if
 registers[REG_AX]=#0004
 registers[REG_CX]=xpos
 registers[REG_DX]=ypos
 registers=dos_interrupt(#33, registers)
 clear_registers()
end procedure

global function mouse_button(integer button_number)
 sequence button_bits
 if IsPtrOn=0 then
  FatalExit("Mouse","Attempt to retrieve event while pointer is hidden.")
--  IsPtrOn=1
 end if
 registers[REG_AX]=#0003
 registers=dos_interrupt(#33, registers)
 button_bits=int_to_bits(registers[REG_BX],3)
 clear_registers()
 return button_bits[button_number]
end function


-- BEGIN ORIGINAL MOUSE.E

-- Mouse Event Numbers:
global constant MOVE = 1,       -- track every movement of the mouse
		LEFT_DOWN = 2,  -- the rest are button pressing/releasing
		LEFT_UP = 4,
		RIGHT_DOWN = 8,
		RIGHT_UP = 16,
		MIDDLE_DOWN = 32,
		MIDDLE_UP = 64

constant M_GET_MOUSE = 14,
	 M_MOUSE_EVENTS = 15,
	 M_MOUSE_POINTER = 24

global function get_mouse()
-- report mouse events,
-- returns -1 if no mouse event,
-- otherwise returns {event#, x-coord, y-coord, x/8, x/16}
 object ret
 if IsPtrOn=0 then
  FatalExit("Mouse","Attempt to retrieve event while pointer is hidden.")
--  IsPtrOn=1
 end if
    ret = machine_func(M_GET_MOUSE, 0)
    if sequence(ret) then
        ret = ret & floor(ret[2]/8)+1 & floor(ret[3]/16)+1
    end if
    return ret
end function

global procedure mouse_events(integer events)
-- select the mouse events to be reported by get_mouse()
-- e.g. mouse_events(LEFT_UP + LEFT_DOWN + RIGHT_DOWN)
    machine_proc(M_MOUSE_EVENTS, events)
end procedure
