-----------------------------------------------------------------------------
-- Message Box
-- Written for Midget II
-- (c) Andrew Greenwood, 22nd October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------

include window.e
include buttons.e


global constant
    MB_OK = 1,
    MB_YESNO = 2



global function Message(object Msg, object Buttons)
    integer MsgWin, len, lines, YES_BTN, NO_BTN, OK_BTN
    sequence co_ords, text, longest
    object K
    text={}
    longest={1,1}
    len=0
    lines=1
    Msg=Msg & '\n'
    for loop=1 to length(Msg) do
        if Msg[loop] = '\n' then
            if len>longest[2] then
                longest = loop & len
            end if
            len=0
            lines=lines+1
        end if
        len=len+1
        text=text & Msg[loop]
    end for
    co_ords =
        {40-floor(longest[2]/2), 15-floor(lines/2)} &
        {floor(longest[2])+2, lines+2}
    MsgWin = CreateWindow(co_ords[1..2], co_ords[3..4])
    DisplayWindow(MsgWin)
    w_position(1,1)
    w_puts(MsgWin,text)
    if Buttons=MB_OK then
        OK_BTN = CreateButton(MsgWin,"OK",{floor(longest[2]/2),lines-1},13)
        DisplayButton(OK_BTN)
    elsif Buttons=MB_YESNO then
        YES_BTN = CreateButton(MsgWin,"YES",{floor(longest[2]/2)-3,lines-1},'Y')
        DisplayButton(YES_BTN)
        NO_BTN = CreateButton(MsgWin,"NO",{floor(longest[2]/2)+2,lines-1},'N')
        DisplayButton(NO_BTN)
    end if
    while 1 do
        K = get_key()
        if K=13 and Buttons=MB_OK then
            DestroyWindow(MsgWin)
            return 1
        elsif K='Y' or K='y' and Buttons=MB_YESNO then
            DestroyWindow(MsgWin)
            return 1
        elsif K='N' or K='n' and Buttons=MB_YESNO then
            DestroyWindow(MsgWin)
            return 0
        end if
    end while
end function
