-----------------------------------------------------------------------------
-- Menu Manager
-- Written for Midget II
-- (c) Andrew Greenwood, 22nd October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------

include window.e
include image.e
include graphics.e
include mouse.e
include die.e


-- Toplevel menu data format
-- [1] Name (string)
-- [2] Base text-X co-ordinate
-- [3] Base text-Y co-ordinate
-- [4] Colour (int)
-- [5] Menu contents (sequence)
-- [6] Enabled? (int)
-- [7] Parent window

-- Menu data format
-- [1] Name (string)
-- [2] Colour (int)
-- [3] Virtual key to return (char)
-- [4] Enabled? (int)


constant
    T_TITLE = 1,
    T_X = 2,
    T_Y = 3,
    T_COLOUR = 4,
    T_SUB = 5,
    T_ENABLED = 6,
    T_PARENT = 7,
    S_TITLE = 1,
    S_COLOUR = 2,
    S_VKEY = 3,
    S_ENABLED = 4


object
    Menu, OldPatch, RectangleCoords, OldPlace, OldRectangle, destroyed

integer
    Open, Width

global object
    VKey

destroyed={}
OldRectangle={{0,0},{0,0}}
RectangleCoords={{0,0},{0,0}}
Width = 0
Open = 0
Menu = {}
OldPatch = {}
OldPlace = {0,0}


procedure CheckHandle(integer handle)
    if handle < 1 or handle > length(Menu) then
        FatalExit("Menu","Invalid handle: "&sprintf("%g",handle))
    end if
end procedure


procedure CheckSubHandle(integer handle, integer subhandle)
    if subhandle < 1 or subhandle > length(Menu[handle][T_SUB]) then
        FatalExit("Menu","Invalid handle: "&sprintf("%g",handle))
    end if
end procedure



global function CreateMenu(object parent, object title, integer xp, integer yp,
                           integer colour)
    integer handle
    sequence WinParam
    CheckParent(parent)

    WinParam = GetWindowParams(parent)

    xp = xp + WinParam[1][1]
    yp = yp + WinParam[1][2]-1

    if length(destroyed) > 0 then
        Menu[destroyed[1]] = {title,xp,yp,colour,{},1,parent}
        handle = destroyed[1]

        if length(destroyed) > 1 then
            destroyed=destroyed[2..length(destroyed)]
        else
            destroyed={}
        end if
        return handle
    else
        Menu = Menu & {{title,xp,yp,colour,{},1,parent}}
    end if
    return length(Menu)  -- return handle
end function


global function CreateMenuItem(integer handle, object title, integer colour,
                                object vkey)
    CheckHandle(handle)
    Menu[handle][T_SUB] = Menu[handle][T_SUB] & {{title,colour,vkey,1}}
    return length(Menu[handle][T_SUB])
end function


global procedure DisplayMenu(integer handle)
    CheckHandle(handle)
    position(Menu[handle][T_Y], Menu[handle][T_X])
    text_color(Menu[handle][T_COLOUR])
    mouse_pointer(0)
    puts(1,Menu[handle][T_TITLE])
    mouse_pointer(1)
end procedure


function get_longest_menu(integer handle)
    integer len,longest
    len=0
    longest=0
    CheckHandle(handle)
    for loop=1 to length(Menu[handle][T_SUB]) do
        if length(Menu[handle][T_SUB][loop][S_TITLE]) > len then
            len=length(Menu[handle][T_SUB][loop][S_TITLE])
            longest=loop
        end if
    end for
    len=len+2  -- Space before and after
    return {longest,len}
end function


global procedure CloseMenu()
    mouse_pointer(0)
    if length(OldPatch) > 1 then
        display_image(OldPlace[1], OldPatch)
    end if
    mouse_pointer(1)
    Open=0
    OldRectangle={{0,0},{0,0}}
end procedure


procedure OpenMenu(object handle, object Clicked)
    sequence longest
    mouse_pointer(0)
    CheckHandle(handle)
    if Open != 0 then
        CloseMenu()
    end if
    Open=handle
    longest=get_longest_menu(handle)
    Width = (longest[2]+1) * 8

    OldPlace =
                {{(Menu[handle][T_X]-1)*8, (Menu[handle][T_Y])*16},
                {((Menu[handle][T_X]-1) + longest[2])*8,
                 ((Menu[handle][T_Y]-1) + length(Menu[handle][T_SUB])+1)*16}}
    OldPatch = save_image(OldPlace[1],OldPlace[2])

    rectangle_fill(0,
                {(Menu[handle][T_X]-1)*8, (Menu[handle][T_Y])*16},
                {((Menu[handle][T_X]-1) + longest[2])*8,
                 ((Menu[handle][T_Y]-1) + length(Menu[handle][T_SUB])+1)*16})

    for loop=1 to length(Menu[handle][T_SUB]) do
        if Menu[handle][T_SUB][loop][S_ENABLED] = 1 then
            text_color(Menu[handle][T_SUB][loop][S_COLOUR])
        else
            text_color(8)
        end if
        if Menu[handle][T_SUB][loop][S_TITLE][1] = '-' then
            position(Menu[handle][T_Y]+loop, Menu[handle][T_X])
            puts(1,repeat('',longest[2]))
        else
            position(Menu[handle][T_Y]+loop, Menu[handle][T_X]+1)
            puts(1,Menu[handle][T_SUB][loop][S_TITLE])
        end if
    end for

    rectangle(15,
                {(Menu[handle][T_X]-1)*8, (Menu[handle][T_Y])*16},
                {((Menu[handle][T_X]-1) + longest[2])*8,
                 ((Menu[handle][T_Y]-1) + length(Menu[handle][T_SUB])+1)*16})

    mouse_pointer(1)
--    FatalExit("Menu","Menu opened, NO ERROR.")
end procedure


procedure CheckMenus(object Clicked)  -- Return handle, or -1 for other
  -- "Clicked" is a two-element sequence of X and Y
    if Open=0 then
    for loop=1 to length(Menu) do
        if Menu[loop][T_X] <= Clicked[1] and
            Menu[loop][T_X] + length(Menu[loop][T_TITLE]) -1 >= Clicked[1] and
            Menu[loop][T_Y] = Clicked[2] and
            not find(loop,destroyed) and
            Menu[loop][T_ENABLED] = 1 then
            if Menu[loop][T_PARENT] = GetActiveWindow() then
                OpenMenu(loop,Clicked)
            end if
        end if
    end for
    end if
end procedure


global function GetMenu()
    object mouse
    mouse = get_mouse()
    if Open != 0 then
    if sequence(mouse) then
        if mouse[2] >= (Menu[Open][T_X]-1)*8 and
            mouse[2] <= (Menu[Open][T_X]-1)*8 + (Width-8) and
            mouse[3] >= (Menu[Open][T_Y])*16 and
            mouse[3] < (Menu[Open][T_Y] + length(Menu[Open][T_SUB]))*16
                                  then

            mouse_pointer(0)
            RectangleCoords=
                    {{((Menu[Open][T_X]-1)*8)+1, (floor(mouse[3]/16)*16)+1},
                    {((Menu[Open][T_X]-1)*8)-1 + (Width-8),
                    ((floor(mouse[3]/16)+1)*16)-1}}

            if not match(OldRectangle,RectangleCoords) then
                rectangle(0,OldRectangle[1],OldRectangle[2])
                rectangle(14,RectangleCoords[1],RectangleCoords[2])
                OldRectangle=RectangleCoords
            end if
            mouse_pointer(1)
            if mouse[1] = LEFT_DOWN then
                VKey = Menu[Open][T_SUB][mouse[5] - Menu[Open][T_Y]][S_VKEY]
                mouse = mouse & Menu[Open][T_SUB][mouse[5] - Menu[Open][T_Y]]
                                    [S_VKEY]
                CloseMenu()
            end if
        elsif mouse[1] = LEFT_DOWN then
            VKey = -1
            CloseMenu()
        end if
    end if
    end if
    if sequence(mouse) then
        if mouse[1] = LEFT_DOWN then
            CheckMenus(mouse[4..5])
        end if
    end if
    if Open != 0 and sequence(mouse) then
        mouse[1] = MOVE
    end if
    return mouse
end function


global procedure DisableMenu(integer handle)
    CheckHandle(handle)
    position(Menu[handle][T_Y], Menu[handle][T_X])
    text_color(8)
    puts(1,Menu[handle][T_TITLE])
    Menu[handle][T_ENABLED] = 0
end procedure


global procedure EnableMenu(integer handle)
    CheckHandle(handle)
    position(Menu[handle][T_Y], Menu[handle][T_X])
    text_color(Menu[handle][T_COLOUR])
    puts(1,Menu[handle][T_TITLE])
    Menu[handle][T_ENABLED] = 1
end procedure



global procedure DisableMenuItem(integer handle, integer subhand)
    CheckHandle(handle)
    CheckSubHandle(handle, subhand)
    Menu[handle][T_SUB][subhand][S_ENABLED] = 0
end procedure


global procedure EnableMenuItem(integer handle, integer subhand)
    CheckHandle(handle)
    CheckSubHandle(handle, subhand)
    Menu[handle][T_SUB][subhand][S_ENABLED] = 1
end procedure


global procedure DestroyMenu(integer handle)
    CheckHandle(handle)
    if Open != 0 then
        CloseMenu()
    end if
    destroyed=destroyed & handle
end procedure
