-----------------------------------------------------------------------------
-- Listbox Manager
-- Written for Midget II
-- (c) Andrew Greenwood, 23rd October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------

include mouse.e
include graphics.e
include window.e


-- Format of List:
-- [1] Origin X position (int)
-- [2] Origin Y position (int)
-- [3] Width (int)
-- [4] Length (int)
-- [5] Parent window handle (int)
-- [6] DATA LIST (sequence)
-- [7] Colour


-- Data list [7]:
-- [1] Caption
-- [2] Data (not displayed)

sequence
    List, destroyed, ListPatch, Range, OldRectangle, Selected

atom
    ClickStart

global integer
    DblClick

constant
    L_X = 1,
    L_Y = 2,
    L_WIDTH = 3,
    L_LENGTH = 4,
    L_PARENT = 5,
    L_DATA = 6,
    L_COLOUR = 7,
    S_CAPTION = 1,
    S_DATA = 2

ClickStart = time()
List = {}
ListPatch = {}
destroyed = {}
Range = {}
OldRectangle = {}
Selected = {}
DblClick = 0



procedure CheckHandle(integer handle)
    if handle < 1 or handle > length(List) then
        FatalExit("List","Invalid listbox handle: "&sprintf("%g",handle))
    end if
end procedure



global function CreateListBox(integer parent, sequence origin, sequence size,
                              integer colour)
    object Wdw
    integer handle, xp, yp, width, len
    xp = origin[1]
    yp = origin[2]
    width = size[1]
    len = size[2]

    CheckParent(parent)
    if xp<1 or yp<1 then
        FatalExit("List","Bad listbox origin")
    end if

    Wdw = GetWindowParams(parent)
    xp = (xp+Wdw[1][1]) * 8
    yp = (yp+Wdw[1][2]) * 16


    if length(destroyed) > 0 then
        List[destroyed[1]] = {xp, yp, width, len, parent, {}, colour}
        handle=destroyed[1]
        if length(destroyed) > 1 then
            destroyed=destroyed[2..length(destroyed)]
        else
            destroyed={}
        end if
        Selected[handle] = 0
        ListPatch[handle] = {1,len}
        OldRectangle[handle] = {{0,0},{0,0}}
        Range[handle] = 1
        return handle
    else
        Selected = Selected & 0
        List = List & {{xp, yp, width, len, parent,{}, colour}}
        ListPatch = ListPatch & {{1,len}}
        OldRectangle = OldRectangle & {{{0,0},{0,0}}}
        Range = Range & 1
        return length(List)
    end if
end function



global procedure DestroyListBox(integer handle)
    CheckHandle(handle)
    destroyed=destroyed & handle
    display_image({List[handle][L_X], List[handle][L_Y]}, ListPatch[handle])
    ListPatch[handle] = {}
end procedure


global procedure DisplayListBox(integer handle)
    CheckHandle(handle)
    mouse_pointer(0)
    ListPatch[handle] = save_image(
               {List[handle][L_X]-4, List[handle][L_Y]-1},
               {List[handle][L_X] + (List[handle][L_WIDTH] * 8),
                List[handle][L_Y] + (List[handle][L_LENGTH] * 16)+1})

    rectangle(15,
               {List[handle][L_X]-4, List[handle][L_Y]-1},
               {List[handle][L_X] + (List[handle][L_WIDTH] * 8),
                List[handle][L_Y] + (List[handle][L_LENGTH] * 16)+1})

    text_color(15)
    position(floor(List[handle][L_Y]/16)+1,
             floor(List[handle][L_X]/8)+List[handle][L_WIDTH])
    puts(1,'')  -- CTRL P X

    rectangle(15,{(List[handle][L_X]+(List[handle][L_WIDTH]*8)-10),
               List[handle][L_Y]-1},
               {(List[handle][L_X]+(List[handle][L_WIDTH]*8)),
                List[handle][L_Y]+16})

    position(floor(List[handle][L_Y]/16)+List[handle][L_LENGTH],
             floor(List[handle][L_X]/8)+List[handle][L_WIDTH])
    puts(1,'')  -- CTRL P Y

    rectangle(15,{(List[handle][L_X]+(List[handle][L_WIDTH]*8)-10),
               (List[handle][L_Y]-1)+((List[handle][L_LENGTH]-1)*16)},
               {(List[handle][L_X]+(List[handle][L_WIDTH]*8)),
                List[handle][L_Y]+(List[handle][L_LENGTH]*16)+1})


    mouse_pointer(1)
end procedure


global procedure HighlightItem(integer handle, integer index)
    sequence co_ords
    CheckHandle(handle)
    if index < 1 or index > length(List[handle][L_DATA]) then
        FatalExit("List","Index is out of range in HighlightItem: "&
                    sprintf("%g",index))
    end if
    mouse_pointer(0)

    Selected[handle] = index
    index = (index - Range[handle]) +1
    co_ords =
               {{List[handle][L_X]-1, (List[handle][L_Y]+((index-1)*16))+1},
               {List[handle][L_X] + (List[handle][L_WIDTH] * 8) - 16,
                List[handle][L_Y] + ((index)*16) - 1 }}


    index = Selected[handle]

    if not match(OldRectangle[handle],co_ords) and
    index >= Range[handle] and index <= Range[handle] + List[handle][L_LENGTH] -1 then
        rectangle(0, OldRectangle[handle][1], OldRectangle[handle][2])
        rectangle(14, co_ords[1], co_ords[2])
        OldRectangle[handle] = co_ords
    end if

    mouse_pointer(1)
end procedure



global procedure ScrollBox(integer handle, atom direction)
    CheckHandle(handle)
    text_color(List[handle][L_COLOUR])
    mouse_pointer(0)
    if direction = -1 and Range[handle] > 1 then
        Range[handle] = Range[handle] -1
    elsif direction = 1 and Range[handle] <
               length(List[handle][L_DATA]) - (List[handle][L_LENGTH]-1)
               then
        Range[handle] = Range[handle] +1
    end if
    rectangle(0, OldRectangle[handle][1], OldRectangle[handle][2])
    OldRectangle[handle] = {{0,0},{0,0}}

    for loop=Range[handle] to length(List[handle][L_DATA]) do
        if loop<=List[handle][L_LENGTH] + Range[handle] - 1 then
            position(floor(List[handle][L_Y]/16)+(loop-Range[handle])+1,
                     floor(List[handle][L_X]/8)+1)
            puts(1,repeat(32,List[handle][L_WIDTH]-2))
            position(floor(List[handle][L_Y]/16)+(loop-Range[handle])+1,
                     floor(List[handle][L_X]/8)+1)
            puts(1,List[handle][L_DATA][loop][S_CAPTION])
        end if
        if Selected[handle] = loop then
            HighlightItem(handle,Selected[handle])
        end if
    end for

    mouse_pointer(1)
end procedure


global procedure AddListBoxItem(integer handle, sequence caption, sequence data)
    CheckHandle(handle)
    text_color(List[handle][L_COLOUR])
    List[handle][L_DATA] = List[handle][L_DATA] & {{caption,data}}
    mouse_pointer(0)
    for loop=Range[handle] to length(List[handle][L_DATA]) do
        if loop<=List[handle][L_LENGTH] then
            position(floor(List[handle][L_Y]/16)+loop,
                     floor(List[handle][L_X]/8)+1)
            puts(1,List[handle][L_DATA][loop][S_CAPTION])
        end if
    end for
    mouse_pointer(1)
end procedure


global procedure CheckListBox(object Clicked)
    if sequence(Clicked) then
        if Clicked[1] = MOVE then
            DblClick = 0
            ClickStart = time() - 1
        end if
        for box=1 to length(List) do
            if Clicked[2] > List[box][L_X] and
               Clicked[2] < List[box][L_X] + (List[box][L_WIDTH] * 8) - 16 and
               Clicked[3] > List[box][L_Y] and
               Clicked[3] < List[box][L_Y] + (List[box][L_LENGTH] * 16) and
               not find(box,destroyed) and
               GetActiveWindow() = List[box][L_PARENT] then
               if Clicked[1] = LEFT_DOWN then
                    -- Select item in listbox
                    if floor((Clicked[3] - List[box][L_Y])/16)+1 <=
                            length(List[box][L_DATA]) then
                    HighlightItem(box, Range[box]+floor((Clicked[3] - List[box][L_Y])/16))
                    if time() - ClickStart < 0.5 then
                        DblClick = 1
                    else
                        ClickStart = time()
                        DblClick = 0
                    end if
                    end if
               end if

            elsif Clicked[2] >= List[box][L_X] + (List[box][L_WIDTH]*8) - 8 and
                  Clicked[2] <= List[box][L_X] + (List[box][L_WIDTH]*8) and
                  Clicked[3] >= List[box][L_Y] and
                  Clicked[3] <= List[box][L_Y]+16 and
                  not find(box,destroyed) and
                  GetActiveWindow() = List[box][L_PARENT] and
                  Clicked[1] = LEFT_DOWN then
--                  if Range[box] > 1 then
                      ScrollBox(box, -1)
--                  end if

            elsif Clicked[2] >= List[box][L_X] + (List[box][L_WIDTH]*8) - 8 and
                  Clicked[2] <= List[box][L_X] + (List[box][L_WIDTH]*8) and
                  Clicked[3] >= List[box][L_Y] + (List[box][L_LENGTH]*16) - 16 and
                  Clicked[3] <= List[box][L_Y] + (List[box][L_LENGTH]*16) and
                  not find(box,destroyed) and
                  GetActiveWindow() = List[box][L_PARENT] and
                  Clicked[1] = LEFT_DOWN then
--                  if Range[box] < length(List[box][L_DATA]) then  --!!
                      ScrollBox(box, 1)
--                  end if
            end if
        end for
    end if

    if time() - ClickStart >= 0.5 then
        DblClick = 0
    end if
end procedure


global function GetListData(integer handle, integer index)
    CheckHandle(handle)
    if index < 1 or index > length(List[handle][L_DATA]) then
        FatalExit("List","Index is out of range in GetListData: "&
                    sprintf("%g",index))
    end if
    return List[handle][L_DATA][index][S_DATA]
end function


global function GetListCaption(integer handle, integer index)
    CheckHandle(handle)
    if index < 1 or index > length(List[handle][L_DATA]) then
        FatalExit("List","Index is out of range in GetListData: "&
                    sprintf("%g",index))
    end if
    return List[handle][L_DATA][index][S_CAPTION]
end function



global procedure ClearListBox(integer handle)
    CheckHandle(handle)
    List[handle][L_DATA] = {}
    mouse_pointer(0)
    rectangle_fill(0, {List[handle][L_X],List[handle][L_Y]},
                  {List[handle][L_X] + (List[handle][L_WIDTH]*8)-11,
                  List[handle][L_Y] + (List[handle][L_LENGTH]*16)})
    mouse_pointer(1)
    ScrollBox(handle,0)
end procedure


global function GetSelected(integer handle)
    CheckHandle(handle)
    return Selected[handle]
end function


global procedure ClearSelection(integer handle)
    CheckHandle(handle)
    Selected[handle] = 0
    Range[handle] = 1
    mouse_pointer(0)
    rectangle(0, OldRectangle[handle][1], OldRectangle[handle][2])
    mouse_pointer(1)
    OldRectangle[handle] = {{0,0},{0,0}}
end procedure
