-- Modified version of Jacques Deschenes's file selector
-- This version by Andrew Greenwood, 24th October, 1999.
-- Please give credit if you use these!

without warning

--with trace

include int24.e
include list.e
include buttons.e
include mouse.e
include menu.e
include window.e
include message.e
include message.e

include graphics.e
include wildcard.e
include machine.e
include get.e
include image.e
include file.e



    object
	DRIVES, DIRS, FILES, WDW, K, B_OK, B_CANCEL, FILTERS
sequence drives,list,drive,path,filter, all_path
integer PrevIndex, PrevFirst

path = current_dir() & '\\'
drive = path[1..2]
path = path[3..length(path)]
list = {}
filter = "*.*"
all_path = repeat("\\",26)



-- math functions

function Min(integer a, integer b)
  if a < b then
    return a
  else
    return b
  end if
end function -- Min

function Max(integer a, integer b)
  if a > b then
    return a
  else
    return b
  end if
end function -- Max


function f_split(sequence path)
-- split path to drive, directory, name and extension
-- return sequence {drive,dir,name,ext}
    sequence slice,drive,dir,name,ext
    atom c
    slice = {}
    drive = {} dir = {} name = {} ext = {}
    path = upper(path)
    for i =1 to length(path) by 1 do
    c = path[i]
    slice = slice  & c
    if c = ':' then
	drive = slice
	slice = {}
    elsif c = '\\' then
	dir = dir & slice
	slice = {}
    elsif c = '.' then
	name = slice[1..length(slice)-1]
	slice = {}
    end if
    end for
    if length(name) = 0 then
    name = slice
    else
    ext = slice
    end if
    if length(ext)=0 and not match("*",name) and not match("?",name) then
    dir = dir & name 
    name = "*"
    ext = "*"
    end if
    if length(dir) then 
    if dir[length(dir)] != '\\' then
      dir = dir & '\\'
    end if 
    end if
    return {drive,dir,name,ext}
end function -- f_split()

function ParentDir(sequence path)
-- remove last sub directory from path if there is one and return it.
-- if root return empty sequence
sequence parent integer i

   if path[length(path)]  = '\\' then
      path = path[1..length(path)-1]
   end if
   i = length(path)
   while i > 0 do
      if path[i] = '\\' or path[i] = ':' then
    exit
      end if
      i = i-1
   end while
   if i = 0 then
      return {}
   end if
   parent = path[1..i]
   if parent[length(parent)] != '\\' then
     parent = parent & '\\'
   end if
   return parent
end function -- ParentDir()

function jsort(sequence fl)
-- quick sort a file list by ascending file name
sequence swap, m
integer l,r,p

    if length(fl) < 2 then
    return fl
    end if
    if length(fl) = 2 then
    if compare(fl[1][D_NAME],fl[2][D_NAME]) = 1 then
       return {fl[2],fl[1]}
    else
       return fl
    end if
    end if
    p = floor(length(fl)/2)
    m = fl[p][D_NAME]
    l = 1  r = length(fl)
    while l < r do
      while compare(fl[l][D_NAME],m) = -1 do
      l = l + 1
      end while
      while compare(m,fl[r][D_NAME]) = -1 do
      r = r - 1
      end while
      if l < r then
      swap = fl[r]
      fl[r] = fl[l]
      fl[l] = swap
      end if
    end while
    return jsort(fl[1..r]) & jsort(fl[r+1..length(fl)])
end function -- jsort()

function FilterList(sequence FileList, sequence filter)
-- filter list to remove unwanted files.
sequence dirs,files
    if length(FileList[1][D_NAME]) = 1 and match(".",FileList[1][D_NAME]) then
    FileList = FileList[2..length(FileList)]
    end if
    dirs ={}
    files = {}
    for i = 1 to length(FileList) do
    if match("d",FileList[i][D_ATTRIBUTES]) then
      dirs = append(dirs,FileList[i])
    else
      if wildcard_file(filter,FileList[i][D_NAME]) then
	 files = append(files,FileList[i])
      end if
    end if
    end for
    return jsort(dirs) & jsort(files)
end function -- FilterList()

function CreateList(sequence NewPath)
-- create a list of file from filter
 object FileList
    FileList = dir(NewPath&"*.*")
    if atom(FileList) then
    return {}
    end if
    return FilterList(FileList,filter)
end function -- CreateList


procedure NewDrive(object d)
    d=d[1]
    if not atom(dir(d&':'&all_path[d-'A'+1]&"*.*")) then
    drive = d&':'
    path = all_path[d-'A'+1]
    list = CreateList(drive&path)
    PrevIndex = 0
    PrevFirst = 0
    end if
end procedure --NewDrive()



procedure UpdateLists()
    ClearListBox(DRIVES)
    for loop=1 to length(drives) do
	AddListBoxItem(DRIVES, drives[loop] & ':', {drives[loop]})
    end for
    ScrollBox(DRIVES,0)

    ClearListBox(DIRS)
    ClearListBox(FILES)
    for loop=1 to length(list) do
	if match("d",list[loop][D_ATTRIBUTES]) then
	    AddListBoxItem(DIRS, list[loop][1], "0")
	elsif not match("d",list[loop][D_ATTRIBUTES]) then
	    AddListBoxItem(FILES, list[loop][1], "0")
	end if
    end for
    ScrollBox(DIRS,0)
    ScrollBox(FILES,0)
    ScrollBox(FILTERS,0)
end procedure



global function OpenDialog(sequence APath, sequence Filters)
-- display a list of file 
-- return the selected file or -1 if cancelled
    object error,OK

    filter=Filters[1][2]
    WDW = CreateWindow({10,9},{60,12})
    DisplayWindow(WDW)
    SetActiveWindow(WDW)

    DRIVES = CreateListBox(WDW, {2,1}, {5,5}, 10)
    DisplayListBox(DRIVES)
    DIRS = CreateListBox(WDW, {9,1}, {16,5}, 11)
    DisplayListBox(DIRS)
    FILES= CreateListBox(WDW, {27,1}, {20, 5}, 14)
    DisplayListBox(FILES)
    FILTERS = CreateListBox(WDW, {9,7}, {38, 2}, 13)
    DisplayListBox(FILTERS)
    for loop=1 to length(Filters) do
	AddListBoxItem(FILTERS, Filters[loop][1], Filters[loop][2])
    end for

    APath=f_split(APath)
    drive=APath[1]
    path=APath[2]
    all_path[drive[1]-'A'+1] = path
    list = CreateList(drive&path)
    UpdateLists()

    B_CANCEL = CreateButton(WDW,"Cancel",{50,3},27)
    B_OK     = CreateButton(WDW," Open ",{50,1},13)
    DisplayButton(B_OK)
    DisplayButton(B_CANCEL)

    while 1 do
	K = get_key()
	if K = 13 or DblClick = 1 then
	DblClick = 0
	if GetSelected(DRIVES) > 0 then
	    NewDrive(GetListData(DRIVES,GetSelected(DRIVES)))
	    ClearSelection(DRIVES)
	    UpdateLists()
	elsif GetSelected(DIRS) > 0 then
	    if match("..",list[GetSelected(DIRS)][D_NAME]) then
		path = ParentDir(path)
	    else
	    path  = path&list[GetSelected(DIRS)][D_NAME]&'\\'
	    end if
	    list = CreateList(drive&path)
	    all_path[drive[1]-'A'+1] = path
		PrevIndex = 0   PrevFirst = 0
	    ClearSelection(DIRS)
	    UpdateLists()
	elsif GetSelected(FILTERS) > 0 then
	    filter = GetListData(FILTERS,GetSelected(FILTERS))
	    list = CreateList(drive&path)
	    all_path[drive[1]-'A'+1] = path
		PrevIndex = 0   PrevFirst = 0
	    ClearSelection(FILTERS)
	    UpdateLists()
	elsif GetSelected(FILES) > 0 then
	    DestroyButton(B_OK)
	    DestroyButton(B_CANCEL)
	    DestroyListBox(DRIVES)
	    DestroyListBox(DIRS)
	    DestroyListBox(FILES)
	    DestroyListBox(FILTERS)
	    DestroyWindow(WDW)
	    return drive&path&GetListCaption(FILES,GetSelected(FILES))
	end if
	elsif K = 27 then
	    DestroyButton(B_OK)
	    DestroyButton(B_CANCEL)
	    DestroyListBox(DRIVES)
	    DestroyListBox(DIRS)
	    DestroyListBox(FILES)
	    DestroyListBox(FILTERS)
	    DestroyWindow(WDW)
	    return -1
	end if
    error=CheckIo()
    if error > 0 then
	    text_color(10)
	OK=Message(IO_ERRORS[error],MB_OK)
    end if
    end while

    return {}
end function -- ChooseFile


function DetectCD_ROM()
sequence r
integer FirstCD, NbrCD
    r = repeat(0,10)
    r[REG_AX] = #1500
    r = dos_interrupt(#2F,r)
    FirstCD = remainder(r[REG_CX],256)
    NbrCD = remainder(r[REG_BX],256)
    return {FirstCD,NbrCD}
end function -- DetectCD_ROM()

-- This will return a list of floppies, hard drives and CD-ROM
global function GetDriveList()
  integer hdn,fdn
  sequence fl,hl,cdl, cdInfo
  object d,j
  
  fdn = floor(peek(#410) / 64) -- number of floppies
  if fdn = 0 then
    fl = "A"
  elsif fdn = 1 then
    fl = "AB"
  end if

--check for CD-ROM
  cdl = ""
  cdInfo = DetectCD_ROM()
  if cdInfo[2] then
    for i = 0  to cdInfo[2] -1  do
    cdl = cdl & "A"+i+cdInfo[1]
    end for
  end if

  hdn = peek(#475) -- number of hard disk
  if hdn > 0 then
     hl = "C"
  end if
  for loop=4 to cdInfo[1]-1 do
   j=dir(64+loop&":\\")
   if not atom(j) then
    hl=hl & loop+64
   end if
  end for
  return fl & hl & cdl
end function -- GetDriveList()

-------------------------------------------------------------------------------

-- initialisation

drives = GetDriveList()
