-----------------------------------------------------------------------------
-- Umm... Death Manager!
-- Written for Midget II
-- Portions (c) Andrew Greenwood, 22nd October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- Purpose: To display a clear error message in the default graphics mode.
-- Also detects Windows version and mouse (both of which have been written
-- by Jacques Deschenes).

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------


include machine.e
include graphics.e


global object
    WinVer


global procedure FatalExit(object Module, object Message)
    if graphics_mode(-1) then
    end if
    text_color(14)
    puts(1,"Error in module:  "&Module&"\n\n")
    text_color(13)
    puts(1,Message&"\n\n")
    text_color(7)
    abort(1)
end procedure



constant MULTIPLEX = #2F
 
global function GetWinVer()
sequence r
integer r_AL
  r = repeat(0,10)
  r[REG_AX] = #1600
  r = dos_interrupt(MULTIPLEX,r)
  r_AL = remainder(r[REG_AX],256)
  if r_AL = 1 or r_AL = 255 then
    WinVer = 2.00
    return WinVer
  elsif  r_AL = 0 or r_AL = #80 then
    r[REG_AX] = #4680
    r = dos_interrupt(MULTIPLEX,r)
    r_AL = remainder(r[REG_AX],256)
    if r_AL = #80 then
	WinVer = 0
	return 0 -- windows not running
    else
	WinVer = 3.00
    return WinVer
    end if
  else --windows is running in extended mode, version in ax, al=major,ah=minor
    WinVer = r_AL + floor(r[REG_AX]/256)/100
    return WinVer
  end if    
end function  -- WindowIsRunning()



global function MousePresent()
-- return 1 if mouse detected
integer MouseVector
sequence r
   MouseVector = (256*peek(207)+peek(206)) *16 + 256*peek(205)+peek(204)
   if MouseVector  = 0 or peek(MouseVector) = #CF then
     return 0  -- no mouse
   end if
   r = repeat(0,10)
   r[REG_AX] =  0
   r = dos_interrupt(#33,r)
   if r[REG_AX] = #FFFF then
    return 1
   else
    return 0
   end if
end function -- MousePresent
