-----------------------------------------------------------------------------
-- Button Manager  (& HEART OF INTERFACE ROUTINES)
-- Written for Midget II
-- (c) Andrew Greenwood, 22nd October 1999.
-- andrew@goldcroft6.freeserve.co.uk

-- If you use these routines in your program(s), I'd appreciate a mention in
-- the credits.
-----------------------------------------------------------------------------

include list.e
include menu.e
include window.e
include graphics.e
include mouse.e


-- Button format:
-- [1] Button text (string)
-- [2] X pos (int)
-- [3] Y pos (int)
-- [4] Virtual key (char)


object
    Button, destroyed, ButtonPatch

constant
    B_CAPTION = 1,
    B_X = 2,
    B_Y = 3,
    B_VKEY = 4,
    B_PARENT = 5

ButtonPatch = {}
Button = {}
destroyed = {}



procedure CheckHandle(integer handle)
    if handle < 1 or handle > length(Button) then
        FatalExit("Buttons","Invalid handle: "&sprintf("%g",handle))
    end if
end procedure


global function CreateButton(integer parent, sequence text,
                             sequence coords, object key)
    object Wdw
    integer handle

    Wdw = GetWindowParams(parent)
    coords = (coords[1]+Wdw[1][1])*8 & (coords[2]+Wdw[1][2])*16

    if length(destroyed) > 0 then
        Button[destroyed[1]] = {text, coords[1], coords[2], key, parent}
        handle = destroyed[1]

        if length(destroyed) > 1 then
            destroyed=destroyed[2..length(destroyed)]
        else
            destroyed={}
        end if
        ButtonPatch[handle] = {}
        return handle
    else
        Button = Button & {{text,coords[1],coords[2],key,parent}}
        ButtonPatch = ButtonPatch & {{}}
        return length(Button)
    end if
end function


global procedure DestroyButton(integer handle)
    CheckHandle(handle)
    destroyed=destroyed & handle
    display_image({Button[handle][B_X], Button[handle][B_Y]}, ButtonPatch[handle])
    ButtonPatch[handle] = {}
end procedure


global procedure DisplayButton(integer handle)
    CheckHandle(handle)
    mouse_pointer(0)
    ButtonPatch[handle] = save_image(
               {Button[handle][B_X]-4, Button[handle][B_Y]-1},
               {Button[handle][B_X] + (length(Button[handle][B_CAPTION])*8),
                Button[handle][B_Y]+16})
    text_color(15)
    position(floor(Button[handle][B_Y]/16)+1, floor(Button[handle][B_X]/8)+1)
    puts(1,Button[handle][B_CAPTION])

    rectangle(15,{Button[handle][B_X]-4, Button[handle][B_Y]-1},
               {Button[handle][B_X] + (length(Button[handle][B_CAPTION])*8),
                Button[handle][B_Y]+16})

    mouse_pointer(1)
end procedure


global function CheckButtons(sequence Clicked)
    if sequence(Clicked) then
        for loop=1 to length(Button) do
            if Clicked[4] > floor(Button[loop][B_X]/8) and
               Clicked[4] <= floor(Button[loop][B_X]/8) +
                             length(Button[loop][B_CAPTION]) and
               GetActiveWindow() = Button[loop][B_PARENT] and
               Clicked[5] = floor(Button[loop][B_Y]/16)+1 then
                if Clicked[1] = LEFT_UP then
                    return Button[loop][B_VKEY]
                end if
            end if
        end for
    end if
    return -1
end function



global function old_get_key()
    return get_key()
end function

global function get_key()
    object Mouse, Key, J
    Key = old_get_key()
    Mouse = GetMenu()
    if sequence(Mouse) then
        CheckListBox(Mouse)
        J=CheckButtons(Mouse)
        if J != -1 then
            Key = J
        end if
        if length(Mouse) = 6 then
            if VKey != -1 then
                Key=VKey
            end if
        end if
    end if
    return Key
end function
